/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.common.utils.Cygwin;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.license.License;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.ui.console.MessageConsole;

public final class CompilerVersionInformationCollector {
    protected static final String TTCN3_LICENSE_FILE_KEY = "TTCN3_LICENSE_FILE";
    protected static final String TTCN3_DIR_KEY = "TTCN3_DIR";
    protected static final String LD_LIBRARY_PATH_KEY = "LD_LIBRARY_PATH";
    protected static final String LIBRARY_SUB_DIR = "/lib";
    public static final String VERSION_CHECK_FLAG = "v";
    public static final String COMPILER_SUBPATH = File.separatorChar + "bin" + File.separatorChar + "compiler";
    protected static final String SPACE = " ";
    protected static final String SUCCESS = "Operation finished successfully.";
    protected static final String FAILURE = "Operation failed with return value: ";
    private static final Pattern BASE_TITAN_HEADER_PATTERN = Pattern.compile("TTCN\\-3 and ASN\\.1 Compiler for the TTCN\\-3 Test Executor, version (.+)\\nProduct number: (.+)\\nBuild date: (.+)\\nCompiled with: (.+)\\n\\n(.+)", 40);
    private static final Pattern BASE_TITAN_HEADER_PATTERN2 = Pattern.compile("TTCN\\-3 and ASN\\.1 Compiler for the TTCN\\-3 Test Executor\\nProduct number: (.+)\\nBuild date: (.+)\\nCompiled with: (.+)\\n\\n(.+)", 40);
    private static String resolvedInstallationPath = "";
    private static CompilerInfoStruct compilerInfoStruct;
    private static boolean infoIsUptodate;

    private CompilerVersionInformationCollector() {
    }

    public static String getCompilerProductNumber() {
        if (!infoIsUptodate) {
            CompilerVersionInformationCollector.collectInformation();
        }
        if (compilerInfoStruct == null) {
            return null;
        }
        return compilerInfoStruct.compilerProductNumber;
    }

    public static String getBuildDate() {
        if (!infoIsUptodate) {
            CompilerVersionInformationCollector.collectInformation();
        }
        if (compilerInfoStruct == null) {
            return null;
        }
        return compilerInfoStruct.buildDate;
    }

    public static String getCCompilerVersion() {
        if (!infoIsUptodate) {
            CompilerVersionInformationCollector.collectInformation();
        }
        if (compilerInfoStruct == null) {
            return null;
        }
        return compilerInfoStruct.cCompilerVersion;
    }

    private static void setEnvironmentalVariables(ProcessBuilder pb, String path) {
        Map<String, String> env = pb.environment();
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        String ttcn3Dir = PathConverter.convert((String)path, (boolean)reportDebugInformation, (MessageConsole)TITANDebugConsole.getConsole());
        if (License.isLicenseNeeded()) {
            env.put(TTCN3_LICENSE_FILE_KEY, LicenseValidator.getResolvedLicenseFilePath(false));
        }
        env.put(TTCN3_DIR_KEY, ttcn3Dir);
        String temp = env.get(LD_LIBRARY_PATH_KEY);
        if (temp == null) {
            env.put(LD_LIBRARY_PATH_KEY, ttcn3Dir + LIBRARY_SUB_DIR);
        } else {
            env.put(LD_LIBRARY_PATH_KEY, temp + ":" + ttcn3Dir + LIBRARY_SUB_DIR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompilerInfoStruct collectVersionInformation(String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        if ("win32".equals(Platform.getOS()) && !Cygwin.isInstalled()) {
            return null;
        }
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        ArrayList<String> command = new ArrayList<String>();
        command.add(PathConverter.convert((String)new Path(path + COMPILER_SUBPATH).toOSString(), (boolean)reportDebugInformation, (MessageConsole)TITANDebugConsole.getConsole()));
        command.add("-v");
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        CompilerVersionInformationCollector.setEnvironmentalVariables(pb, path);
        pb.redirectErrorStream(true);
        Process proc = null;
        StringBuilder tempCommand = new StringBuilder();
        for (String c : command) {
            tempCommand.append(c).append(SPACE);
        }
        ArrayList<String> finalCommand = new ArrayList<String>();
        finalCommand.add("sh");
        finalCommand.add("-c");
        finalCommand.add(tempCommand.toString());
        StringBuilder readLines = new StringBuilder();
        pb.command(finalCommand);
        try {
            proc = pb.start();
        }
        catch (IOException e) {
            TITANConsole.println("execution failed");
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return null;
        }
        BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        try {
            int linesRead = 0;
            String line = stdout.readLine();
            while (line != null) {
                if (++linesRead < 7) {
                    readLines.append(line).append('\n');
                } else if (linesRead > 100) {
                    CompilerInfoStruct compilerInfoStruct = null;
                    return compilerInfoStruct;
                }
                if (reportDebugInformation) {
                    TITANConsole.println(line);
                }
                line = stdout.readLine();
            }
            int exitval = proc.waitFor();
            if (exitval != 0) {
                if (reportDebugInformation) {
                    TITANConsole.println(FAILURE + exitval);
                }
                proc.destroy();
                CompilerInfoStruct compilerInfoStruct = null;
                return compilerInfoStruct;
            }
            if (reportDebugInformation) {
                TITANConsole.println(SUCCESS);
            }
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        finally {
            try {
                stdout.close();
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        Matcher baseTITANErrorMatcher = BASE_TITAN_HEADER_PATTERN.matcher(readLines.toString());
        if (baseTITANErrorMatcher.matches()) {
            CompilerInfoStruct temp = new CompilerInfoStruct();
            temp.compilerProductNumber = baseTITANErrorMatcher.group(2);
            temp.buildDate = baseTITANErrorMatcher.group(3);
            temp.cCompilerVersion = baseTITANErrorMatcher.group(4);
            return temp;
        }
        Matcher baseTITANErrorMatcher2 = BASE_TITAN_HEADER_PATTERN2.matcher(readLines.toString());
        if (baseTITANErrorMatcher2.matches()) {
            CompilerInfoStruct temp = new CompilerInfoStruct();
            temp.compilerProductNumber = baseTITANErrorMatcher2.group(1);
            temp.buildDate = baseTITANErrorMatcher2.group(2);
            temp.cCompilerVersion = baseTITANErrorMatcher2.group(3);
            return temp;
        }
        return null;
    }

    public static String getResolvedInstallationPath(boolean force) {
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        if (force || resolvedInstallationPath.length() == 0) {
            String installationPath = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.TTCN3_INSTALL_DIR", "", null);
            resolvedInstallationPath = PathConverter.convert((String)installationPath, (boolean)reportDebugInformation, (MessageConsole)TITANDebugConsole.getConsole());
        }
        return resolvedInstallationPath;
    }

    public static String checkTemporalLocation(String path) {
        if (path == null) {
            return null;
        }
        CompilerInfoStruct temp = CompilerVersionInformationCollector.collectVersionInformation(path);
        if (temp == null) {
            return null;
        }
        return temp.compilerProductNumber;
    }

    public static void collectInformation() {
        if (compilerInfoStruct != null || infoIsUptodate) {
            return;
        }
        String installationPath = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.TTCN3_INSTALL_DIR", null, null);
        compilerInfoStruct = CompilerVersionInformationCollector.collectVersionInformation(installationPath);
        infoIsUptodate = true;
    }

    public static void clearStoredInformation() {
        compilerInfoStruct = null;
        resolvedInstallationPath = "";
        infoIsUptodate = false;
    }

    static {
        infoIsUptodate = false;
    }

    private static final class CompilerInfoStruct {
        private String compilerProductNumber;
        private String buildDate;
        private String cCompilerVersion;

        private CompilerInfoStruct() {
        }
    }
}

