/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.asn1editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.EditorTracker;
import org.eclipse.titan.designer.editors.FoldingSupport;
import org.eclipse.titan.designer.editors.IEditorWithCarretOffset;
import org.eclipse.titan.designer.editors.ISemanticTITANEditor;
import org.eclipse.titan.designer.editors.asn1editor.ASN1FoldingSupport;
import org.eclipse.titan.designer.editors.asn1editor.ASN1OccurrenceMarker;
import org.eclipse.titan.designer.editors.asn1editor.Configuration;
import org.eclipse.titan.designer.editors.asn1editor.DocumentSetupParticipant;
import org.eclipse.titan.designer.editors.asn1editor.OutlinePage;
import org.eclipse.titan.designer.editors.asn1editor.PairMatcher;
import org.eclipse.titan.designer.editors.asn1editor.ReconcilingStrategy;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.FileSaveTracker;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.GlobalProjectStructureTracker;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public final class ASN1Editor
extends AbstractDecoratedTextEditor
implements ISemanticTITANEditor,
IEditorWithCarretOffset {
    private static final String CONTENTASSISTPROPOSAL = "ContentAssistProposal.";
    private static final String ASN1_EDITOR = "org.eclipse.titan.designer.editors.asn1editor.ASN1Editor";
    private static final String EDITOR_CONTEXT = "org.eclipse.titan.designer.editors.asn1editor.context";
    private static final String EDITOR_SCOPE = "org.eclipse.titan.designer.editors.ASN1EditorScope";
    private ProjectionSupport projectionSupport;
    private List<Annotation> oldAnnotations = new ArrayList<Annotation>();
    private ProjectionAnnotationModel annotationModel;
    private ColorManager colorManager;
    private Configuration configuration;
    private ProjectionViewer projectionViewer;
    private OutlinePage outlinePage;
    private ReconcilingStrategy strategy;
    private ASN1OccurrenceMarker occurrencesMarker;
    private final IPropertyChangeListener foldingListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if ("org.eclipse.titan.designer.foldingEnabledPreference".equals(property) || "org.eclipse.titan.designer.foldComments".equals(property) || "org.eclipse.titan.designer.foldStatementBlocks".equals(property) || "org.eclipse.titan.designer.foldParenthesis".equals(property) || "org.eclipse.titan.designer.distance".equals(property)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ASN1Editor.this.updateFoldingStructure(new ASN1FoldingSupport().calculatePositions(ASN1Editor.this.getDocument()));
                    }
                });
            }
        }
    };

    public ASN1Editor() {
        this.occurrencesMarker = new ASN1OccurrenceMarker(this);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore[] stores = new IPreferenceStore[]{this.getPreferenceStore(), Activator.getDefault().getPreferenceStore()};
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(stores));
        this.colorManager = new ColorManager();
        this.configuration = new Configuration(this.colorManager, this);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.configuration);
        DocumentSetupParticipant participant = new DocumentSetupParticipant(this);
        ForwardingDocumentProvider forwardingProvider = new ForwardingDocumentProvider("__asn1_partitioning", (IDocumentSetupParticipant)participant, (IDocumentProvider)new TextFileDocumentProvider());
        this.setDocumentProvider((IDocumentProvider)forwardingProvider);
        this.setEditorContextMenuId(EDITOR_CONTEXT);
    }

    public boolean isSemanticCheckingDelayed() {
        IPreferencesService prefs = Platform.getPreferencesService();
        return prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.delaySemantiCheckingTillSave", false, null);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            FileSaveTracker.fileBeingSaved(file);
        }
        super.doSave(progressMonitor);
        if (file != null && this.isSemanticCheckingDelayed()) {
            WorkspaceJob op = new WorkspaceJob("Reconciliation on save"){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
                    projectSourceParser.reportOutdating(file);
                    ASN1Editor.this.strategy.analyze(true);
                    return Status.OK_STATUS;
                }
            };
            op.setPriority(30);
            op.setSystem(true);
            op.setUser(false);
            op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
            op.schedule();
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("org.eclipse.titan.designer")) {
            this.colorManager.update(event.getProperty());
            this.invalidateTextPresentation();
            this.updateTITANIndentPrefixes();
            return true;
        }
        return super.affectsTextPresentation(event);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        PairMatcher pairMatcher = new PairMatcher();
        support.setCharacterPairMatcher((ICharacterPairMatcher)pairMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("org.eclipse.titan.designer.matchingBracketEnabled", "org.eclipse.titan.designer.color.matchingBracket");
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction caAction = new TextOperationAction(Activator.getDefault().getResourceBundle(), CONTENTASSISTPROPOSAL, (ITextEditor)this, 13);
        String id = "org.eclipse.ui.edit.text.contentAssist.proposals";
        caAction.setActionDefinitionId(id);
        this.setAction(CONTENTASSISTPROPOSAL, (IAction)caAction);
        this.markAsStateDependentAction(CONTENTASSISTPROPOSAL, true);
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.outlinePage == null) {
                this.outlinePage = new OutlinePage(this);
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        this.oldAnnotations = null;
        if (this.projectionSupport != null) {
            this.projectionSupport.dispose();
            this.projectionSupport = null;
        }
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
            this.outlinePage = null;
        }
        this.annotationModel = null;
        this.configuration = null;
        this.projectionViewer = null;
        if (this.occurrencesMarker != null) {
            this.occurrencesMarker.dispose();
            this.occurrencesMarker = null;
        }
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.foldingListener);
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            EditorTracker.remove(file, this);
        }
        super.dispose();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void editorSaved() {
        super.editorSaved();
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            GlobalProjectStructureTracker.saveFile(file);
        }
    }

    @Override
    public IDocument getDocument() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        return sourceViewer.getDocument();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(this.projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        this.projectionViewer.doOperation(19);
        this.annotationModel = this.projectionViewer.getProjectionAnnotationModel();
        this.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ASN1Editor.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
            }
        });
        this.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty() || !(selection instanceof TextSelection) || "".equals(((TextSelection)selection).getText())) {
                    return;
                }
                TextSelection textSelection = (TextSelection)selection;
                int offset = textSelection.getOffset() + textSelection.getLength();
                ASN1Editor.this.occurrencesMarker.markOccurences(ASN1Editor.this.getDocument(), offset);
            }
        });
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (file != null) {
            EditorTracker.put(file, this);
        }
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        this.occurrencesMarker.markOccurences(this.getDocument(), this.getCarretOffset());
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.foldingListener);
        IContextService contextService = (IContextService)this.getEditorSite().getService(IContextService.class);
        contextService.activateContext(EDITOR_SCOPE);
        return viewer;
    }

    @Override
    public void updateOutlinePage() {
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }

    public void refreshOutlinePage() {
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
    }

    @Override
    public void updateFoldingStructure(List<Position> positions) {
        FoldingSupport.updateFoldingStructure(this.annotationModel, this.oldAnnotations, positions);
    }

    @Override
    public void invalidateTextPresentation() {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer != null) {
            viewer.invalidateTextPresentation();
        }
    }

    @Override
    public int getCarretOffset() {
        int widgetOffset = this.getSourceViewer().getTextWidget().getCaretOffset();
        return this.projectionViewer.widgetOffset2ModelOffset(widgetOffset);
    }

    public void setCarretOffset(int i) {
        int temp = this.projectionViewer.modelOffset2WidgetOffset(i);
        this.getSourceViewer().getTextWidget().setCaretOffset(temp);
    }

    protected void updateTITANIndentPrefixes() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        ISourceViewer sourceViewer = this.getSourceViewer();
        String[] types = configuration.getConfiguredContentTypes(sourceViewer);
        for (int i = 0; i < types.length; ++i) {
            String[] prefixes = configuration.getIndentPrefixes(sourceViewer, types[i]);
            if (prefixes == null || prefixes.length <= 0) continue;
            sourceViewer.setIndentPrefixes(prefixes, types[i]);
        }
    }

    public void setReconciler(ReconcilingStrategy strategy) {
        this.strategy = strategy;
    }

    public static IEditorDescriptor findASN1Editor(IWorkbench workbench) {
        return workbench.getEditorRegistry().findEditor(ASN1_EDITOR);
    }
}

