/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.referenceSearch;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.editors.IEditorWithCarretOffset;
import org.eclipse.titan.designer.editors.referenceSearch.ReferenceSearchQuery;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorPart;

public final class ReferenceSearch {
    public static final String FILENOTIDENTIFIABLE = "The file related to the editor could not be identified";
    public static final String NORECOGNISABLEMODULENAME = "The name of the module in the file `{0}'' could not be identified";
    public static final String EXCLUDEDFROMBUILD = "The name of the module in the file `{0}'' could not be identified, the file is excluded from build";
    public static final String NOTFOUNDMODULE = "The module in file `{0}'' could not be found";

    private ReferenceSearch() {
    }

    public static void runAction(IEditorPart targetEditor, ISelection selection) {
        int offset;
        targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        IFile file = (IFile)targetEditor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(FILENOTIDENTIFIABLE);
            return;
        }
        if (!TITANNature.hasTITANNature(file.getProject())) {
            targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("The project containing the selected file does not have the TITAN nature among its natures");
            return;
        }
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean reportDebugInformation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
        if (selection instanceof TextSelection && !selection.isEmpty() && !"".equals(((TextSelection)selection).getText())) {
            if (reportDebugInformation) {
                TITANDebugConsole.println("text selected: " + ((TextSelection)selection).getText());
            }
            TextSelection tSelection = (TextSelection)selection;
            offset = tSelection.getOffset() + tSelection.getLength();
        } else {
            offset = ((IEditorWithCarretOffset)targetEditor).getCarretOffset();
        }
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        if (ResourceExclusionHelper.isExcluded((IResource)file)) {
            targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(MessageFormat.format(EXCLUDEDFROMBUILD, file.getFullPath()));
            return;
        }
        Module module = projectSourceParser.containedModule(file);
        if (module == null) {
            targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(MessageFormat.format(NOTFOUNDMODULE, file.getName()));
            return;
        }
        ReferenceFinder rf = new ReferenceFinder();
        boolean isDetected = rf.detectAssignmentDataByOffset(module, offset, targetEditor, true, reportDebugInformation);
        if (!isDetected) {
            return;
        }
        ReferenceSearchQuery query = new ReferenceSearchQuery(rf, module, file.getProject());
        for (ISearchQuery runningQuery : NewSearchUI.getQueries()) {
            NewSearchUI.cancelQuery((ISearchQuery)runningQuery);
        }
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
    }
}

