/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.designer.editors.GeneralTITANAutoEditStrategy;

public final class SmartIndentAfterNewLineAutoEditStrategy
extends GeneralTITANAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.length != 0 || command.text == null || !this.endsWithDelimiter(document, command.text)) {
            return;
        }
        this.refreshAutoEditStrategy();
        this.initializeRootInterval(document);
        if (this.rootInterval == null) {
            return;
        }
        try {
            StringBuilder builder = new StringBuilder(document.get());
            if (this.isWithinMultiLineComment(command.offset) || this.isWithinString(builder, command.offset)) {
                return;
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        this.smartIndentAfterNewLine(document, command);
    }

    protected void smartIndentAfterNewLine(IDocument document, DocumentCommand command) {
        int docLength = document.getLength();
        if (command.offset == -1 || docLength == 0) {
            return;
        }
        try {
            boolean willInsertClosingBracket;
            int p = command.offset == docLength ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            StringBuilder builder = new StringBuilder(command.text);
            String lineDelimeter = document.getLineDelimiter(line);
            if (lineDelimeter == null) {
                lineDelimeter = "";
            }
            int carretShiftSize = lineDelimeter.length();
            String lineIndent = this.getIndentOfLine(document, line, command);
            builder.append(lineIndent);
            carretShiftSize += lineIndent.length();
            int start = document.getLineOffset(line);
            int end = start + document.getLineLength(line) - command.text.length();
            if (this.containsUnclosedInterval(start, command.offset)) {
                Interval endInterval = this.rootInterval.getSmallestEnclosingInterval(command.offset);
                if (endInterval.getDepth() <= 1 || endInterval.getStartOffset() == command.offset) {
                    command.text = builder.toString();
                    return;
                }
                builder.append(this.indentString);
                carretShiftSize += this.indentString.length();
            }
            boolean bl = willInsertClosingBracket = this.preferenceStore.getBoolean("org.eclipse.titan.designer.typing.close_braces") && this.canStatementBlockBeOpen(document, command.offset);
            if (this.preferenceStore.getBoolean("org.eclipse.titan.designer.typing.automatically_move_on_new_line_braces") && (willInsertClosingBracket || this.containsUnopenedInterval(command.offset, end))) {
                builder.append(lineDelimeter + lineIndent);
                command.caretOffset = command.offset + carretShiftSize;
                command.shiftsCaret = false;
            }
            if (willInsertClosingBracket) {
                builder.append('}');
            }
            command.text = builder.toString();
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }
}

