/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.titan.designer.parsers.GlobalParser;

public class OutdatedConfigFileCollector
implements IResourceVisitor {
    public static final String TRUE = "true";
    private static final String DOT = ".";
    private String resourcename;
    private Map<IFile, String> uptodateFiles;
    private Set<IFile> highlySyntaxErroneousFiles;
    private List<IFile> cfgFilesToCheck;
    private final IContainer[] workingDirectories;

    public OutdatedConfigFileCollector(IContainer[] workingDirectories, Map<IFile, String> uptodateFiles, Set<IFile> highlySyntaxErroneousFiles) {
        this.uptodateFiles = uptodateFiles;
        this.highlySyntaxErroneousFiles = highlySyntaxErroneousFiles;
        this.cfgFilesToCheck = new ArrayList<IFile>();
        this.workingDirectories = workingDirectories;
    }

    public List<IFile> getCFGFilesToCheck() {
        return this.cfgFilesToCheck;
    }

    public boolean visit(IResource resource) {
        if (resource == null || !resource.isAccessible()) {
            return false;
        }
        this.resourcename = resource.getName();
        if (this.resourcename == null || this.resourcename.startsWith(DOT)) {
            return false;
        }
        switch (resource.getType()) {
            case 1: {
                IFile file = (IFile)resource;
                String extension = file.getFileExtension();
                if (this.uptodateFiles.containsKey(file) || this.highlySyntaxErroneousFiles.contains(file) || !GlobalParser.SUPPORTED_CONFIG_FILE_EXTENSIONS[0].equals(extension)) break;
                this.cfgFilesToCheck.add(file);
                break;
            }
            case 2: {
                for (IContainer workingDirectory : this.workingDirectories) {
                    if (!workingDirectory.equals(resource)) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }
}

