/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers.preprocess;

public class PreprocessorDirective {
    public Directive_type type;
    public boolean condition;
    public String str;
    public int line;

    public PreprocessorDirective(Directive_type type) {
        this.type = type;
        this.condition = true;
    }

    public PreprocessorDirective(Directive_type type, boolean condition) {
        this.type = type;
        this.condition = condition;
    }

    public PreprocessorDirective(Directive_type type, String str) {
        this.type = type;
        this.str = str;
    }

    public boolean isConditional() {
        switch (this.type) {
            case IFDEF: 
            case IFNDEF: 
            case IF: 
            case ELIF: 
            case ELSE: 
            case ENDIF: {
                return true;
            }
        }
        return false;
    }

    public static enum Directive_type {
        IFDEF("#ifdef"),
        IFNDEF("#ifndef"),
        IF("#if"),
        ELIF("#elif"),
        ELSE("#else"),
        ENDIF("#endif"),
        DEFINE("#define"),
        UNDEF("#undef"),
        ERROR("#error"),
        WARNING("#warning"),
        INCLUDE("#include"),
        LINEMARKER("linemarker"),
        LINECONTROL("#line"),
        PRAGMA("#pragma"),
        NULL("null");

        private final String name;

        private Directive_type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

