/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.pages.ConfigurationManagerControl;
import org.eclipse.titan.designer.wizards.projectFormat.TITANAutomaticProjectExporter;
import org.eclipse.ui.dialogs.PropertyPage;

public final class FolderBuildPropertyPage
extends PropertyPage {
    private Composite pageComposite = null;
    private Label headLabel = null;
    private ConfigurationManagerControl configurationManager;
    private String firstConfiguration;
    private Button centralStorageButton = null;
    private static final String CENTRAL_STORAGE_DISPLAY_TEXT = "Folder is in central storage.";
    private Button excludeFromBuildButton = null;
    private static final String EXCLUDE_DISPLAY_TEXT = "Excluded from build.";
    private IFolder folderResource;
    private final PreferenceStore tempStore = new PreferenceStore();

    public void dispose() {
        this.pageComposite.dispose();
        this.headLabel.dispose();
        super.dispose();
    }

    public void changeConfiguration(String configuration) {
        this.configurationManager.changeActualConfiguration();
        this.loadProperties();
        PropertyNotificationManager.firePropertyChange((IResource)this.folderResource.getProject());
    }

    protected Control createContents(Composite parent) {
        String mode;
        this.folderResource = (IFolder)this.getElement();
        try {
            String temp = this.folderResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "centralStorage"));
            this.tempStore.setValue("centralStorage", "true".equals(temp) ? "true" : "false");
            temp = this.folderResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "excludeFromBuild"));
            this.tempStore.setValue("excludeFromBuild", "true".equals(temp) ? "true" : "false");
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        this.pageComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.pageComposite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        this.pageComposite.setLayoutData((Object)data);
        if (TITANBuilder.isBuilderEnabled(this.folderResource.getProject())) {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText("This TITAN project has the TITAN builder enabled.");
        } else {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText("This TITAN project has the TITAN builder disabled.");
        }
        this.configurationManager = new ConfigurationManagerControl(this.pageComposite, this.folderResource.getProject());
        this.configurationManager.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FolderBuildPropertyPage.this.configurationManager.hasConfigurationChanged()) {
                    FolderBuildPropertyPage.this.changeConfiguration(FolderBuildPropertyPage.this.configurationManager.getActualSelection());
                }
            }
        });
        this.firstConfiguration = this.configurationManager.getActualSelection();
        this.centralStorageButton = new Button(this.pageComposite, 32);
        this.centralStorageButton.setText(CENTRAL_STORAGE_DISPLAY_TEXT);
        this.centralStorageButton.setEnabled(true);
        try {
            mode = this.folderResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "centralStorage"));
            this.centralStorageButton.setSelection("true".equals(mode));
            if (mode == null) {
                this.folderResource.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "centralStorage"), "false");
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        this.excludeFromBuildButton = new Button(this.pageComposite, 32);
        this.excludeFromBuildButton.setText(EXCLUDE_DISPLAY_TEXT);
        this.excludeFromBuildButton.setEnabled(true);
        try {
            mode = this.folderResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "excludeFromBuild"));
            this.excludeFromBuildButton.setSelection("true".equals(mode));
            if (mode == null) {
                this.folderResource.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "excludeFromBuild"), "false");
            }
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            return;
        }
        if (this.configurationManager != null) {
            this.configurationManager.refresh();
        }
        super.setVisible(visible);
    }

    protected void performDefaults() {
        this.centralStorageButton.setSelection(false);
        this.excludeFromBuildButton.setSelection(false);
        this.configurationManager.saveActualConfiguration();
    }

    public boolean performCancel() {
        this.configurationManager.clearActualConfiguration();
        return super.performCancel();
    }

    public boolean performOk() {
        IProject project = this.folderResource.getProject();
        try {
            boolean configurationChanged;
            String tempCentralStorage = this.centralStorageButton.getSelection() ? "true" : "false";
            String tempExcluded = this.excludeFromBuildButton.getSelection() ? "true" : "false";
            this.folderResource.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "centralStorage"), tempCentralStorage);
            this.folderResource.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "excludeFromBuild"), tempExcluded);
            boolean bl = configurationChanged = !this.firstConfiguration.equals(this.configurationManager.getActualSelection());
            if (configurationChanged || !tempCentralStorage.equals(this.tempStore.getString("centralStorage")) || !tempExcluded.equals(this.tempStore.getString("excludeFromBuild"))) {
                this.tempStore.setValue("centralStorage", "true".equals(tempCentralStorage) ? "true" : "false");
                this.tempStore.setValue("excludeFromBuild", "true".equals(tempExcluded) ? "true" : "false");
                this.configurationManager.saveActualConfiguration();
                ProjectDocumentHandlingUtility.saveDocument(project);
                TITANAutomaticProjectExporter.saveAllAutomatically(project);
                MarkerHandler.markAllMarkersForRemoval((IResource)this.folderResource);
                PropertyNotificationManager.firePropertyChange((IResource)this.folderResource);
            }
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
            return false;
        }
        return true;
    }

    private void loadProperties() {
        String mode;
        try {
            mode = this.folderResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "centralStorage"));
            this.centralStorageButton.setSelection("true".equals(mode));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        try {
            mode = this.folderResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "excludeFromBuild"));
            this.excludeFromBuildButton.setSelection("true".equals(mode));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
    }
}

