/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.tabpages.performance;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.executor.graphics.ImageCache;

public abstract class BasePerformanceSettingsTab
extends AbstractLaunchConfigurationTab {
    private static final String TITLE = "Basic performance settings";
    private static final String IMAGE = "progress_spinner.gif";
    protected static final String CONSOLE_LOGGING_TEXT = "Enable logging to the console";
    protected static final String CONSOLE_LOGGING_TOOLTIP = "If this option is turned off messages are not redirected to the console";
    protected static final String TESTCASE_REFRESH_TEXT = "Refresh the list of testcases on launch";
    protected static final String TESTCASE_REFRESH_TOOLTIP = "If this option is turned off the list of testcases will not be refreshed on launch";
    protected static final String SEVERITY_EXTRACTION_TEXT = "Enable severity level extraction";
    protected static final String SEVERITY_EXTRACTION_TOOLTIP = "If this option is turned off severity levels will not be displayed in the notifications";
    protected static final String LINECOUNT_TEXT = "Limit the amount of notifications in the Notifications view to:";
    protected static final String LINECOUNT_TOOLTIP = "0 means unlimited";
    protected static final String LINECOUNTSPINNER_TOOLTIP = "The maximum ammount of notifications in the Notifications view";
    protected static final String REFRESHTIMEOUT_TEXT = "State information shall be automatically refreshed in seconds:";
    protected static final String REFRESHTIMEOUT_TOOLTIP = "A high value might mean out of sync issues, while a low value can cause performane loss";
    protected static final String REFRESHTIMEOUTSPINNER_TOOLTIP = "The maximum ammount of time without knowing the state of the Main Controller";
    protected static final String VERDICTEXTRACTION_TEXT = "Enable verdict extaction from messages";
    protected static final String VERDICTEXTRACTION_TOOLTIP = "If this option is set verdicts are extracted to the Test Execution view";
    protected static final String KEEPCONFIG_TEXT = "Keep the temporary configuration files in single mode execution";
    protected static final String KEEPCONFIG_TOOLTIP = "In single mode execution, the executable is driven by temporarily generated configuration files";
    private BasicSelectorListener selectorListener = new BasicSelectorListener();
    private Button consoleLogging;
    private Button testcaseRefreshOnStart;
    private Button severityLevelExtraction;
    private Label prefixLabel;
    private Spinner lineCountSpinner;
    private Spinner refreshTimeoutSpinner;
    private Button verdictExtraction;
    private Button keepConfigFile;

    public abstract void executorSpecificControls(Composite var1);

    public final void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        GridLayout pageCompositeLayout = new GridLayout();
        pageCompositeLayout.numColumns = 1;
        pageComposite.setLayout((Layout)pageCompositeLayout);
        GridData pageCompositeGridData = new GridData();
        pageCompositeGridData.horizontalAlignment = 4;
        pageCompositeGridData.grabExcessHorizontalSpace = true;
        pageCompositeGridData.grabExcessVerticalSpace = true;
        pageComposite.setLayoutData((Object)pageCompositeGridData);
        this.createLineCountArea(pageComposite);
        this.createVerdictExtractionArea(pageComposite);
        this.createTestcaseRefreshArea(pageComposite);
        this.executorSpecificControls(pageComposite);
        this.setControl((Control)pageComposite);
    }

    protected final void createConsoleLoggingArea(Composite parent) {
        this.consoleLogging = new Button(parent, 32);
        this.consoleLogging.setText(CONSOLE_LOGGING_TEXT);
        this.consoleLogging.setToolTipText(CONSOLE_LOGGING_TOOLTIP);
        this.consoleLogging.setSelection(true);
        this.consoleLogging.addSelectionListener((SelectionListener)this.selectorListener);
    }

    protected final void createTestcaseRefreshArea(Composite parent) {
        this.testcaseRefreshOnStart = new Button(parent, 32);
        this.testcaseRefreshOnStart.setText(TESTCASE_REFRESH_TEXT);
        this.testcaseRefreshOnStart.setToolTipText(TESTCASE_REFRESH_TOOLTIP);
        this.testcaseRefreshOnStart.setSelection(true);
        this.testcaseRefreshOnStart.addSelectionListener((SelectionListener)this.selectorListener);
    }

    protected final void createSeverityLevelExtractionArea(Composite parent) {
        this.severityLevelExtraction = new Button(parent, 32);
        this.severityLevelExtraction.setText(SEVERITY_EXTRACTION_TEXT);
        this.severityLevelExtraction.setToolTipText(SEVERITY_EXTRACTION_TOOLTIP);
        this.severityLevelExtraction.setSelection(true);
        this.severityLevelExtraction.addSelectionListener((SelectionListener)this.selectorListener);
    }

    protected final void createLineCountArea(Composite parent) {
        Composite lineCountComposite = new Composite(parent, 0);
        lineCountComposite.setLayout((Layout)new GridLayout(2, false));
        this.prefixLabel = new Label(lineCountComposite, 0);
        this.prefixLabel.setLayoutData((Object)new GridData(32));
        this.prefixLabel.setText(LINECOUNT_TEXT);
        this.prefixLabel.setToolTipText(LINECOUNT_TOOLTIP);
        this.lineCountSpinner = new Spinner(lineCountComposite, 0);
        this.lineCountSpinner.setLayoutData((Object)new GridData(32));
        this.lineCountSpinner.setMinimum(0);
        this.lineCountSpinner.setMaximum(1000000);
        this.lineCountSpinner.setIncrement(100);
        this.lineCountSpinner.setPageIncrement(10000);
        this.lineCountSpinner.setToolTipText(LINECOUNTSPINNER_TOOLTIP);
        this.lineCountSpinner.setSelection(1000);
        this.lineCountSpinner.addSelectionListener((SelectionListener)this.selectorListener);
        this.lineCountSpinner.addModifyListener((ModifyListener)this.selectorListener);
    }

    protected final void createRefreshTimeoutArea(Composite parent) {
        Composite lineCountComposite = new Composite(parent, 0);
        lineCountComposite.setLayout((Layout)new GridLayout(2, false));
        this.prefixLabel = new Label(lineCountComposite, 0);
        this.prefixLabel.setLayoutData((Object)new GridData(32));
        this.prefixLabel.setText(REFRESHTIMEOUT_TEXT);
        this.prefixLabel.setToolTipText(REFRESHTIMEOUT_TOOLTIP);
        this.refreshTimeoutSpinner = new Spinner(lineCountComposite, 0);
        this.refreshTimeoutSpinner.setLayoutData((Object)new GridData(32));
        this.refreshTimeoutSpinner.setMinimum(2);
        this.refreshTimeoutSpinner.setMaximum(1000);
        this.refreshTimeoutSpinner.setIncrement(1);
        this.refreshTimeoutSpinner.setPageIncrement(10);
        this.refreshTimeoutSpinner.setToolTipText(REFRESHTIMEOUT_TOOLTIP);
        this.refreshTimeoutSpinner.setSelection(5);
        this.refreshTimeoutSpinner.addSelectionListener((SelectionListener)this.selectorListener);
        this.refreshTimeoutSpinner.addModifyListener((ModifyListener)this.selectorListener);
    }

    protected final void createVerdictExtractionArea(Composite parent) {
        this.verdictExtraction = new Button(parent, 32);
        this.verdictExtraction.setText(VERDICTEXTRACTION_TEXT);
        this.verdictExtraction.setToolTipText(VERDICTEXTRACTION_TOOLTIP);
        this.verdictExtraction.setSelection(true);
        this.verdictExtraction.addSelectionListener((SelectionListener)this.selectorListener);
    }

    protected final void createKeepConfigfileArea(Composite parent) {
        this.keepConfigFile = new Button(parent, 32);
        this.keepConfigFile.setText(KEEPCONFIG_TEXT);
        this.keepConfigFile.setToolTipText(KEEPCONFIG_TOOLTIP);
        this.keepConfigFile.setSelection(false);
        this.keepConfigFile.addSelectionListener((SelectionListener)this.selectorListener);
    }

    public final String getName() {
        return TITLE;
    }

    public final Image getImage() {
        return ImageCache.getImage(IMAGE);
    }

    public final void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean tempBool = configuration.getAttribute("org.eclipse.titan.executor.consoleLogging", true);
            if (null != this.consoleLogging && this.consoleLogging.getSelection() != tempBool) {
                this.consoleLogging.setSelection(tempBool);
            }
            tempBool = configuration.getAttribute("org.eclipse.titan.executor.testcaseRefreshOnStart", true);
            if (null != this.testcaseRefreshOnStart && this.testcaseRefreshOnStart.getSelection() != tempBool) {
                this.testcaseRefreshOnStart.setSelection(tempBool);
            }
            tempBool = configuration.getAttribute("org.eclipse.titan.executor.severityLevelExtraction", true);
            if (null != this.severityLevelExtraction && this.severityLevelExtraction.getSelection() != tempBool) {
                this.severityLevelExtraction.setSelection(tempBool);
            }
            int tempInt = configuration.getAttribute("org.eclipse.titan.executor.maximumNotificationLineCount", 1000);
            if (null != this.lineCountSpinner && this.lineCountSpinner.getSelection() != tempInt) {
                this.lineCountSpinner.setSelection(tempInt);
            }
            tempInt = configuration.getAttribute("org.eclipse.titan.executor.MainControllerStateRefreshTimeout", 5);
            if (null != this.refreshTimeoutSpinner && this.refreshTimeoutSpinner.getSelection() != tempInt) {
                this.refreshTimeoutSpinner.setSelection(tempInt);
            }
            tempBool = configuration.getAttribute("org.eclipse.titan.executor.verdictExtraction", true);
            if (null != this.verdictExtraction && this.verdictExtraction.getSelection() != tempBool) {
                this.verdictExtraction.setSelection(tempBool);
            }
            tempBool = configuration.getAttribute("org.eclipse.titan.executor.keepTemporarilyGeneratedConfigurationFiles", true);
            if (null != this.keepConfigFile && this.keepConfigFile.getSelection() != tempBool) {
                this.keepConfigFile.setSelection(tempBool);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public final void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.titan.executor.consoleLogging", null != this.consoleLogging ? this.consoleLogging.getSelection() : true);
        configuration.setAttribute("org.eclipse.titan.executor.testcaseRefreshOnStart", this.testcaseRefreshOnStart != null ? this.testcaseRefreshOnStart.getSelection() : true);
        configuration.setAttribute("org.eclipse.titan.executor.severityLevelExtraction", this.severityLevelExtraction != null ? this.severityLevelExtraction.getSelection() : true);
        configuration.setAttribute("org.eclipse.titan.executor.maximumNotificationLineCount", this.lineCountSpinner != null ? this.lineCountSpinner.getSelection() : 1000);
        configuration.setAttribute("org.eclipse.titan.executor.MainControllerStateRefreshTimeout", this.refreshTimeoutSpinner != null ? this.refreshTimeoutSpinner.getSelection() : 5);
        configuration.setAttribute("org.eclipse.titan.executor.verdictExtraction", this.verdictExtraction != null ? this.verdictExtraction.getSelection() : true);
        configuration.setAttribute("org.eclipse.titan.executor.keepTemporarilyGeneratedConfigurationFiles", this.keepConfigFile != null ? this.keepConfigFile.getSelection() : true);
    }

    public final void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.titan.executor.consoleLogging", true);
        configuration.setAttribute("org.eclipse.titan.executor.testcaseRefreshOnStart", true);
        configuration.setAttribute("org.eclipse.titan.executor.severityLevelExtraction", true);
        configuration.setAttribute("org.eclipse.titan.executor.maximumNotificationLineCount", 1000);
        configuration.setAttribute("org.eclipse.titan.executor.MainControllerStateRefreshTimeout", 5);
        configuration.setAttribute("org.eclipse.titan.executor.verdictExtraction", true);
        configuration.setAttribute("org.eclipse.titan.executor.keepTemporarilyGeneratedConfigurationFiles", true);
    }

    private final class BasicSelectorListener
    extends SelectionAdapter
    implements ModifyListener {
        private BasicSelectorListener() {
        }

        public void modifyText(ModifyEvent e) {
            BasePerformanceSettingsTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            BasePerformanceSettingsTab.this.updateLaunchConfigurationDialog();
        }
    }
}

