/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.views.executormonitor;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.executor.executors.ITreeLeaf;
import org.eclipse.titan.executor.executors.TreeBranch;
import org.eclipse.titan.executor.views.executormonitor.ExecutorMonitorView;
import org.eclipse.titan.executor.views.executormonitor.ExecutorStorage;
import org.eclipse.titan.executor.views.executormonitor.LaunchElement;
import org.eclipse.titan.executor.views.executormonitor.LaunchStorage;
import org.eclipse.titan.executor.views.executormonitor.MainControllerElement;
import org.eclipse.ui.PlatformUI;

public final class LaunchesListener
implements ILaunchesListener2 {
    private ExecutorMonitorView executorMonitorView;

    public LaunchesListener(ExecutorMonitorView executorMonitorView) {
        this.executorMonitorView = executorMonitorView;
    }

    public void launchesAdded(ILaunch[] launches) {
        for (ILaunch launch : launches) {
            ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
            try {
                LaunchElement launchElement;
                if (!ExecutorMonitorView.isSupportedConfiguration(launchConfiguration)) continue;
                if (LaunchStorage.getLaunchElementMap().containsKey(launch)) {
                    launchElement = LaunchStorage.getLaunchElementMap().get(launch);
                } else {
                    String name = launchConfiguration.getName() + " [ " + launchConfiguration.getType().getName() + " ]";
                    launchElement = new LaunchElement(name, launch);
                    LaunchStorage.registerLaunchElement(launchElement);
                    ExecutorStorage.registerExecutorStorage(launchElement);
                }
                this.executorMonitorView.getRoot().addChildToEnd(launchElement);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)(" While processing launch configuration " + launchConfiguration.getName()), (Throwable)e);
            }
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LaunchesListener.this.executorMonitorView.getTreeViewer().refresh((Object)LaunchesListener.this.executorMonitorView.getRoot());
            }
        });
        this.executorMonitorView.updateActions();
    }

    public void launchesChanged(ILaunch[] launches) {
        for (int i = 0; i < launches.length; ++i) {
            ILaunch launched = launches[i];
            List<ITreeLeaf> children = this.executorMonitorView.getRoot().children();
            int j = 0;
            int size = children.size();
            while (i < size) {
                final LaunchElement launchElement = (LaunchElement)children.get(j);
                if (launched.equals(launchElement.launch())) {
                    launchElement.changed();
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            LaunchesListener.this.executorMonitorView.getTreeViewer().expandToLevel((Object)launchElement, 3);
                            LaunchesListener.this.executorMonitorView.getTreeViewer().refresh((Object)launchElement);
                        }
                    });
                }
                ++i;
            }
        }
        this.executorMonitorView.updateActions();
    }

    public void launchesRemoved(ILaunch[] launches) {
        TreeBranch root = this.executorMonitorView.getRoot();
        for (ILaunch launched : launches) {
            for (int i = root.children().size() - 1; i >= 0; --i) {
                ILaunch temporal = ((LaunchElement)root.children().get(i)).launch();
                if (!launched.equals(temporal)) continue;
                root.children().get(i).dispose();
                root.children().remove(i);
            }
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LaunchesListener.this.executorMonitorView.getTreeViewer().refresh((Object)LaunchesListener.this.executorMonitorView.getRoot());
            }
        });
        this.executorMonitorView.updateActions();
    }

    public void launchesTerminated(ILaunch[] launches) {
        for (ILaunch launched : launches) {
            for (ITreeLeaf element : this.executorMonitorView.getRoot().children()) {
                final LaunchElement launchElement = (LaunchElement)element;
                if (!launched.equals(launchElement.launch())) continue;
                launchElement.changed();
                MainControllerElement mainController = 1 == ((LaunchElement)element).children().size() ? (MainControllerElement)((LaunchElement)element).children().get(0) : null;
                if (null != mainController) {
                    mainController.executor().terminate(true);
                }
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        LaunchesListener.this.executorMonitorView.getTreeViewer().refresh((Object)launchElement);
                    }
                });
            }
        }
        this.executorMonitorView.updateActions();
    }
}

