/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.metrics.topview.TopView;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class TopViewOpener
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        this.doOpenTopView();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.doOpenTopView();
        return null;
    }

    private void doOpenTopView() {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        if (structSelection.isEmpty()) {
            return;
        }
        Object firstElement = structSelection.getFirstElement();
        if (!(firstElement instanceof IProject)) {
            ErrorReporter.logError((String)"The open top risk view command needs to be called on a project ");
            return;
        }
        IProject project = (IProject)firstElement;
        try {
            IViewPart activeView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.titanium.metrics.topview");
            if (activeView instanceof TopView) {
                TopView topView = (TopView)activeView;
                topView.setSelectedProject(project);
                topView.startMeasuring();
            }
        }
        catch (PartInitException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while initializing the top metrics view", (Throwable)e);
        }
    }
}

