/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.statements.Assignment_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.For_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.LengthofExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.SizeOfExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class IterateOnWrongArray
extends BaseModuleCodeSmellSpotter {
    private static final String ERR_MSG = "The loop parameter `{0}'' might be used to index the wrong list.";

    public IterateOnWrongArray() {
        super(CodeSmellType.ITERATE_ON_WRONG_ARRAY);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (!(node instanceof For_Statement)) {
            return;
        }
        For_Statement fs = (For_Statement)node;
        LoopVariableFinder lvVisitor = new LoopVariableFinder();
        fs.accept((ASTVisitor)lvVisitor);
        Reference loopVar = lvVisitor.getLoopVariable();
        if (loopVar == null) {
            return;
        }
        Assignment loopVarDef = loopVar.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
        if (loopVarDef == null) {
            return;
        }
        Value finalExpr = fs.getFinalExpression();
        FinalExprVisitor exprVisitor = new FinalExprVisitor();
        if (finalExpr == null) {
            return;
        }
        finalExpr.accept((ASTVisitor)exprVisitor);
        List<Reference> arraysIterated = exprVisitor.getArraysIterated();
        if (arraysIterated.isEmpty()) {
            return;
        }
        StatementBlock sb = fs.getStatementBlock();
        if (sb == null) {
            return;
        }
        StatementBlockVisitor sbVisitor = new StatementBlockVisitor(loopVar, arraysIterated);
        sb.accept((ASTVisitor)sbVisitor);
        List<Reference> matchingRefs = sbVisitor.getMatchingReferences();
        for (Reference r : matchingRefs) {
            if (r.getUsedOnLeftHandSide()) continue;
            problems.report(r.getLocation(), MessageFormat.format(ERR_MSG, loopVar));
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(For_Statement.class);
        return ret;
    }

    private static final class LoopVariableFinder
    extends ASTVisitor {
        private Reference loopVariable;

        private LoopVariableFinder() {
        }

        public Reference getLoopVariable() {
            return this.loopVariable;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof For_Statement) {
                return 3;
            }
            if (node instanceof Assignment_Statement) {
                Assignment_Statement as = (Assignment_Statement)node;
                this.loopVariable = as.getReference();
                return 2;
            }
            return 1;
        }
    }

    private static final class StatementBlockVisitor
    extends ASTVisitor {
        private final Reference loopVariable;
        private final List<Reference> arraysIterated;
        private final List<Reference> matchingReferences;
        private Reference parentReference;

        public StatementBlockVisitor(Reference loopVariable, List<Reference> arraysIterated) {
            this.loopVariable = loopVariable;
            this.arraysIterated = arraysIterated;
            this.matchingReferences = new ArrayList<Reference>();
        }

        public List<Reference> getMatchingReferences() {
            return this.matchingReferences;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof For_Statement) {
                return 1;
            }
            if (node instanceof Reference) {
                Reference ref;
                this.parentReference = ref = (Reference)node;
                return 3;
            }
            if (node instanceof ArraySubReference) {
                IValue cval;
                ArraySubReference asr = (ArraySubReference)node;
                Value val = asr.getValue();
                if (val == null || val.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
                    return 1;
                }
                if (val instanceof Undefined_LowerIdentifier_Value && (cval = val.setLoweridToReference(CompilationTimeStamp.getBaseTimestamp())) instanceof Referenced_Value) {
                    val = (Referenced_Value)cval;
                }
                if (val instanceof Referenced_Value) {
                    Reference ref = ((Referenced_Value)val).getReference();
                    if (ref == null) {
                        return 1;
                    }
                    Assignment as = ref.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                    Assignment parentRefDef = this.parentReference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                    Assignment loopVariableDef = this.loopVariable.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                    for (Reference arrayIterated : this.arraysIterated) {
                        Assignment arrayIteratedDef = arrayIterated.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                        if (as == loopVariableDef && (parentRefDef != arrayIteratedDef || !this.hasSubreferencePrefix(arrayIterated, this.parentReference))) continue;
                        return 1;
                    }
                    this.matchingReferences.add(this.parentReference);
                }
                return 1;
            }
            return 3;
        }

        private boolean hasSubreferencePrefix(Reference prefix, Reference toTest) {
            if (prefix == null || toTest == null || prefix.getSubreferences() == null || toTest.getSubreferences() == null) {
                return false;
            }
            ListIterator itPrefix = prefix.getSubreferences().listIterator();
            ListIterator itToTest = toTest.getSubreferences().listIterator();
            while (itPrefix.hasNext() && itToTest.hasNext()) {
                ISubReference srPrefix = (ISubReference)itPrefix.next();
                ISubReference srToTest = (ISubReference)itToTest.next();
                if (srPrefix instanceof ArraySubReference) {
                    if (!(srToTest instanceof ArraySubReference)) {
                        return false;
                    }
                    ArraySubReference asrPrefix = (ArraySubReference)srPrefix;
                    ArraySubReference asrToTest = (ArraySubReference)srToTest;
                    Value vPrefix = asrPrefix.getValue();
                    Value vToTest = asrToTest.getValue();
                    if (vPrefix == null || vToTest == null) {
                        return false;
                    }
                    if (vPrefix.createStringRepresentation().equals(vToTest.createStringRepresentation())) continue;
                    return false;
                }
                if (srPrefix.toString().equals(srToTest.toString())) continue;
                return false;
            }
            return !itPrefix.hasNext();
        }
    }

    private static final class IteratedArrayFinder
    extends ASTVisitor {
        private Reference arrayIterated;

        private IteratedArrayFinder() {
        }

        public Reference getArrayIterated() {
            return this.arrayIterated;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof LengthofExpression || node instanceof SizeOfExpression) {
                return 3;
            }
            if (node instanceof Value) {
                Value v = (Value)node;
                if (v instanceof Undefined_LowerIdentifier_Value) {
                    Undefined_LowerIdentifier_Value uliv = (Undefined_LowerIdentifier_Value)v;
                    v = uliv.setLoweridToReference(CompilationTimeStamp.getBaseTimestamp());
                }
                if (v instanceof Referenced_Value) {
                    Referenced_Value rv = (Referenced_Value)v;
                    this.arrayIterated = rv.getReference();
                    if (this.arrayIterated != null) {
                        return 2;
                    }
                }
                return 1;
            }
            return 3;
        }
    }

    private static final class FinalExprVisitor
    extends ASTVisitor {
        private List<Reference> arraysIterated = new ArrayList<Reference>();

        private FinalExprVisitor() {
        }

        public List<Reference> getArraysIterated() {
            return this.arraysIterated;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof LengthofExpression || node instanceof SizeOfExpression) {
                IteratedArrayFinder visitor = new IteratedArrayFinder();
                node.accept((ASTVisitor)visitor);
                this.arraysIterated.add(visitor.getArrayIterated());
                return 1;
            }
            return 3;
        }
    }
}

