/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.statemachine;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TransitionMoc implements Enumerator
{
    SIMPLE(0, "simple", "simple"),
    ABORT(1, "abort", "abort"),
    FINAL(2, "final", "final");

    public static final int SIMPLE_VALUE = 0;
    public static final int ABORT_VALUE = 1;
    public static final int FINAL_VALUE = 2;
    private static final TransitionMoc[] VALUES_ARRAY;
    public static final List<TransitionMoc> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TransitionMoc[]{SIMPLE, ABORT, FINAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TransitionMoc get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransitionMoc result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransitionMoc getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransitionMoc result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransitionMoc get(int value) {
        switch (value) {
            case 0: {
                return SIMPLE;
            }
            case 1: {
                return ABORT;
            }
            case 2: {
                return FINAL;
            }
        }
        return null;
    }

    private TransitionMoc(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

