/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.Translucent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public abstract class Glyph<T>
implements Cloneable,
Translucent {
    private T owner;
    private String type;
    public double vx;
    public double vy;
    protected int vz;
    protected double size;
    protected double orient = 0.0;
    protected boolean visible = true;
    protected boolean sensit = true;
    static Color DEFAULT_MOUSE_INSIDE_COLOR = Color.WHITE;
    protected Color color;
    protected float[] HSV = new float[3];
    protected Color fColor = Color.white;
    protected Color cursorInsideColor = DEFAULT_MOUSE_INSIDE_COLOR;
    public AlphaComposite alphaC;
    private boolean selected = false;
    protected Stroke stroke = null;
    Glyph[] stickedGlyphs;
    public Object stickedTo;
    public static final short ENTERED_GLYPH = 1;
    public static final short EXITED_GLYPH = -1;
    public static final short NO_CURSOR_EVENT = 0;
    protected double coef = 1.0;

    public T getOwner() {
        return this.owner;
    }

    public void setOwner(T t) {
        this.owner = t;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    public String toString() {
        return new String(super.toString() + " Glyph ID " + this.hashCode() + " pos (" + this.vx + "," + this.vy + "," + this.vz + ") type=" + this.type);
    }

    public void move(double x, double y) {
        this.vx += x;
        this.vy += y;
        this.propagateMove(x, y);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public void moveTo(double x, double y) {
        this.propagateMove(x - this.vx, y - this.vy);
        this.vx = x;
        this.vy = y;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public Point2D.Double getLocation() {
        return new Point2D.Double(this.vx, this.vy);
    }

    public abstract double getSize();

    public abstract void sizeTo(double var1);

    public abstract void reSize(double var1);

    public abstract double getOrient();

    public abstract void orientTo(double var1);

    public int getZindex() {
        return this.vz;
    }

    public void setZindex(int z) {
        this.vz = z;
    }

    public void setSensitivity(boolean b) {
        this.sensit = b;
    }

    public boolean isSensitive() {
        return this.sensit;
    }

    public void setVisible(boolean b) {
        if (b != this.visible) {
            this.visible = b;
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isVisibleThroughLens() {
        return this.visible;
    }

    public static void setDefaultCursorInsideHighlightColor(Color c) {
        DEFAULT_MOUSE_INSIDE_COLOR = c;
    }

    public static Color getDefaultCursorInsideHighlightColor() {
        return DEFAULT_MOUSE_INSIDE_COLOR;
    }

    public boolean isFilled() {
        return true;
    }

    public boolean isBorderDrawn() {
        return true;
    }

    public void setCursorInsideHighlightColor(Color c) {
        this.cursorInsideColor = c;
    }

    public void setColor(Color c) {
        this.fColor = this.color = c;
        this.HSV = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), new float[3]);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public void setBorderColor(Color c) {
    }

    public void setHSVColor(float h, float s, float v) {
        this.HSV[0] = h;
        if (this.HSV[0] > 1.0f) {
            this.HSV[0] = 1.0f;
        } else if (this.HSV[0] < 0.0f) {
            this.HSV[0] = 0.0f;
        }
        this.HSV[1] = s;
        if (this.HSV[1] > 1.0f) {
            this.HSV[1] = 1.0f;
        } else if (this.HSV[1] < 0.0f) {
            this.HSV[1] = 0.0f;
        }
        this.HSV[2] = v;
        if (this.HSV[2] > 1.0f) {
            this.HSV[2] = 1.0f;
        } else if (this.HSV[2] < 0.0f) {
            this.HSV[2] = 0.0f;
        }
        this.fColor = this.color = Color.getHSBColor(this.HSV[0], this.HSV[1], this.HSV[2]);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public void addHSVColor(float h, float s, float v) {
        this.HSV[0] = this.HSV[0] + h;
        if (this.HSV[0] > 1.0f) {
            this.HSV[0] = 1.0f;
        } else if (this.HSV[0] < 0.0f) {
            this.HSV[0] = 0.0f;
        }
        this.HSV[1] = this.HSV[1] + s;
        if (this.HSV[1] > 1.0f) {
            this.HSV[1] = 1.0f;
        } else if (this.HSV[1] < 0.0f) {
            this.HSV[1] = 0.0f;
        }
        this.HSV[2] = this.HSV[2] + v;
        if (this.HSV[2] > 1.0f) {
            this.HSV[2] = 1.0f;
        } else if (this.HSV[2] < 0.0f) {
            this.HSV[2] = 0.0f;
        }
        this.fColor = this.color = Color.getHSBColor(this.HSV[0], this.HSV[1], this.HSV[2]);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public void setHSVbColor(float h, float s, float v) {
    }

    public void addHSVbColor(float h, float s, float v) {
    }

    public float[] getHSVColor() {
        return this.HSV;
    }

    public float[] getHSVbColor() {
        float[] res = new float[]{0.0f, 0.0f, 0.0f};
        return res;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getDefaultColor() {
        return this.fColor;
    }

    public Color getBorderColor() {
        return Color.BLACK;
    }

    public abstract void highlight(boolean var1, Color var2);

    @Override
    public void setTranslucencyValue(float alpha) {
        this.alphaC = alpha == 1.0f ? null : AlphaComposite.getInstance(3, alpha);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public float getTranslucencyValue() {
        return this.alphaC != null ? this.alphaC.getAlpha() : 1.0f;
    }

    public void select(boolean b) {
        this.selected = b;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setStroke(Stroke s) {
        this.stroke = s != null ? s : null;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void propagateMove(double x, double y) {
        if (this.stickedGlyphs != null) {
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                this.stickedGlyphs[i].move(x, y);
            }
        }
    }

    public void stick(Glyph g) {
        if (this.stickedGlyphs == null) {
            this.stickedGlyphs = new Glyph[1];
            this.stickedGlyphs[0] = g;
            g.stickedTo = this;
        } else {
            boolean alreadySticked = false;
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                if (this.stickedGlyphs[i] != g) continue;
                alreadySticked = true;
                break;
            }
            if (!alreadySticked) {
                Glyph[] newStickList = new Glyph[this.stickedGlyphs.length + 1];
                System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, this.stickedGlyphs.length);
                newStickList[this.stickedGlyphs.length] = g;
                this.stickedGlyphs = newStickList;
                g.stickedTo = this;
            } else if (VirtualSpaceManager.debugModeON()) {
                System.err.println("Warning: trying to stick Glyph " + g + " to Glyph " + this + " while they are already sticked.");
            }
        }
    }

    public void unstick(Glyph g) {
        if (this.stickedGlyphs != null) {
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                if (this.stickedGlyphs[i] != g) continue;
                g.stickedTo = null;
                Glyph[] newStickList = new Glyph[this.stickedGlyphs.length - 1];
                System.arraycopy(this.stickedGlyphs, 0, newStickList, 0, i);
                System.arraycopy(this.stickedGlyphs, i + 1, newStickList, i, this.stickedGlyphs.length - i - 1);
                this.stickedGlyphs = newStickList;
                break;
            }
            if (this.stickedGlyphs.length == 0) {
                this.stickedGlyphs = null;
            }
            g.stickedTo = null;
        }
    }

    public void unstickAllGlyphs() {
        if (this.stickedGlyphs != null) {
            for (int i = 0; i < this.stickedGlyphs.length; ++i) {
                this.stickedGlyphs[i].stickedTo = null;
                this.stickedGlyphs[i] = null;
            }
            this.stickedGlyphs = null;
        }
    }

    public Glyph[] getStickedGlyphArray() {
        return this.stickedGlyphs;
    }

    public abstract void project(Camera var1, Dimension var2);

    public abstract void projectForLens(Camera var1, int var2, int var3, float var4, double var5, double var7);

    public abstract void draw(Graphics2D var1, int var2, int var3, int var4, Stroke var5, AffineTransform var6, int var7, int var8);

    public abstract void drawForLens(Graphics2D var1, int var2, int var3, int var4, Stroke var5, AffineTransform var6, int var7, int var8);

    public abstract void initCams(int var1);

    public abstract void addCamera(int var1);

    public abstract void removeCamera(int var1);

    public abstract boolean coordInside(int var1, int var2, int var3, double var4, double var6);

    public abstract void resetMouseIn();

    public abstract void resetMouseIn(int var1);

    public abstract short mouseInOut(int var1, int var2, int var3, double var4, double var6);

    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return this.vx - this.size <= eb && this.vx + this.size >= wb && this.vy - this.size <= nb && this.vy + this.size >= sb;
    }

    public boolean visibleInViewport(double wb, double nb, double eb, double sb, Camera c) {
        return this.visibleInRegion(wb, nb, eb, sb, c.getIndex());
    }

    public boolean containedInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return this.vx + this.size <= eb && this.vx - this.size >= wb && this.vy + this.size <= nb && this.vy - this.size >= sb;
        }
        return false;
    }

    public abstract boolean fillsView(double var1, double var3, int var5);

    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return false;
    }

    public double[] getBounds() {
        double[] res = new double[]{this.vx - this.size, this.vy + this.size, this.vx + this.size, this.vy - this.size};
        return res;
    }

    public static void stickToGlyph(Glyph g1, Glyph g2) {
        g2.stick(g1);
    }

    public static void unstickFromGlyph(Glyph g1, Glyph g2) {
        g2.unstick(g1);
    }

    public static void unstickAllGlyphs(Glyph g) {
        g.unstickAllGlyphs();
    }

    public abstract Shape getJava2DShape();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }
}

