/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.log.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.titan.common.utils.StandardCharsets;
import org.eclipse.titan.common.utils.StringUtils;

public class LogFormatter {
    private static final int DEFAULT_INDENTATION_SIZE = 100;
    public static final int TICK_SIZE = 65536;
    private static final int IN_BUFFER_SIZE = 8192;
    private static final int OUT_BUFFER_SIZE = 65536;
    private static final int INDENTATION_SIZE = 4;
    private static final byte[] NEWLINE = StringUtils.lineSeparator().getBytes(StandardCharsets.UTF8);
    private static byte[] indentation;
    private IProgressMonitor internalMonitor;
    private FileChannel inChannel;
    private FileChannel outChannel;
    private LastTokenTypes lastToken;
    private int indentationLevel;
    private boolean insideString;

    public LogFormatter(IProgressMonitor internalMonitor, FileChannel inChannel, FileChannel outChannel) {
        this.internalMonitor = internalMonitor;
        this.inChannel = inChannel;
        this.outChannel = outChannel;
    }

    public void format() throws IOException {
        long nofProcessedBytes = 0L;
        this.indentationLevel = 0;
        this.insideString = false;
        boolean cancelled = false;
        this.lastToken = LastTokenTypes.OTHER;
        ByteBuffer inBuf = ByteBuffer.allocateDirect(8192);
        ByteBuffer outBuffer = ByteBuffer.allocate(65536);
        inBuf.clear();
        while (!cancelled && this.inChannel.read(inBuf) != -1) {
            if (this.internalMonitor.isCanceled()) {
                cancelled = true;
            }
            inBuf.flip();
            this.processBuffer(inBuf, outBuffer);
            nofProcessedBytes += (long)inBuf.limit();
            inBuf.flip();
            outBuffer.flip();
            this.outChannel.write(outBuffer);
            outBuffer.clear();
            if (nofProcessedBytes <= 65536L) continue;
            this.internalMonitor.worked((int)nofProcessedBytes / 65536);
            nofProcessedBytes %= 65536L;
        }
    }

    private void processBuffer(ByteBuffer inBuf, ByteBuffer outBuffer) throws IOException {
        while (inBuf.hasRemaining()) {
            byte temp = inBuf.get();
            if (outBuffer.remaining() < this.indentationLevel * 4 + 1) {
                outBuffer.flip();
                this.outChannel.write(outBuffer);
                outBuffer.clear();
            }
            if (this.insideString) {
                this.processInsideString(inBuf, outBuffer, temp);
                continue;
            }
            this.outsideString(inBuf, outBuffer, temp);
        }
    }

    private void outsideString(ByteBuffer inBuf, ByteBuffer outBuffer, byte temp) {
        switch (temp) {
            case 123: {
                if (this.indentationLevel > 0) {
                    switch (this.lastToken) {
                        case OPEN_BRACE: 
                        case COMMA: {
                            outBuffer.put(NEWLINE);
                            this.indent(outBuffer, this.indentationLevel);
                            break;
                        }
                        default: {
                            outBuffer.put((byte)32);
                        }
                    }
                }
                outBuffer.put(temp);
                ++this.indentationLevel;
                this.lastToken = LastTokenTypes.OPEN_BRACE;
                break;
            }
            case 125: {
                if (this.indentationLevel > 0) {
                    --this.indentationLevel;
                    if (LastTokenTypes.OPEN_BRACE.equals((Object)this.lastToken)) {
                        outBuffer.put((byte)32);
                    } else {
                        outBuffer.put(NEWLINE);
                        this.indent(outBuffer, this.indentationLevel);
                    }
                    this.lastToken = LastTokenTypes.CLOSE_BRACE;
                }
                outBuffer.put(temp);
                break;
            }
            case 44: {
                outBuffer.put(temp);
                if (this.indentationLevel <= 0) break;
                this.lastToken = LastTokenTypes.COMMA;
                break;
            }
            case 34: {
                outBuffer.put(temp);
                this.insideString = true;
                break;
            }
            case 9: 
            case 32: {
                if (this.indentationLevel > 0) {
                    if (!LastTokenTypes.OTHER.equals((Object)this.lastToken)) break;
                    this.lastToken = LastTokenTypes.WHITE_SPACE;
                    break;
                }
                outBuffer.put(temp);
                break;
            }
            case 10: {
                if (this.indentationLevel > 0) {
                    if (!LastTokenTypes.OTHER.equals((Object)this.lastToken)) break;
                    this.lastToken = LastTokenTypes.WHITE_SPACE;
                    break;
                }
                outBuffer.put(NEWLINE);
                break;
            }
            case 13: {
                if (inBuf.remaining() > 0) {
                    byte temp2 = inBuf.get();
                    if (10 == temp2) {
                        if (this.indentationLevel > 0) {
                            if (!LastTokenTypes.OTHER.equals((Object)this.lastToken)) break;
                            this.lastToken = LastTokenTypes.WHITE_SPACE;
                            break;
                        }
                        outBuffer.put(NEWLINE);
                        break;
                    }
                    outBuffer.put(NEWLINE);
                    break;
                }
                outBuffer.put(temp);
                break;
            }
            default: {
                if (this.indentationLevel > 0) {
                    switch (this.lastToken) {
                        case OPEN_BRACE: 
                        case COMMA: {
                            outBuffer.put(NEWLINE);
                            this.indent(outBuffer, this.indentationLevel);
                            break;
                        }
                        case CLOSE_BRACE: 
                        case WHITE_SPACE: {
                            outBuffer.put((byte)32);
                            break;
                        }
                    }
                    this.lastToken = LastTokenTypes.OTHER;
                }
                outBuffer.put(temp);
            }
        }
    }

    private void processInsideString(ByteBuffer inBuf, ByteBuffer outBuffer, byte temp) {
        outBuffer.put(temp);
        switch (temp) {
            case 34: {
                this.insideString = false;
                break;
            }
            case 92: {
                if (!inBuf.hasRemaining()) break;
                byte temp2 = inBuf.get();
                outBuffer.put(temp2);
                break;
            }
        }
    }

    private void indent(ByteBuffer outBuffer, int amount) {
        int temp = amount * 4;
        if (temp > indentation.length) {
            LogFormatter.resizeIndentation(temp);
        }
        outBuffer.put(indentation, 0, temp);
    }

    private static void resizeIndentation(int newSize) {
        indentation = new byte[newSize];
        for (int i = 0; i < newSize; ++i) {
            LogFormatter.indentation[i] = 32;
        }
    }

    static {
        LogFormatter.resizeIndentation(100);
    }

    private static enum LastTokenTypes {
        OPEN_BRACE,
        CLOSE_BRACE,
        COMMA,
        WHITE_SPACE,
        OTHER;

    }
}

