/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.engine.Camera;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.PrintUtilities;

public class PrintWindow {
    private static final String[] units = new String[]{"pixels", "inches", "cm", "mm"};
    private static final int PIXEL = 0;
    private static final int INCH = 1;
    private static final int CM = 2;
    private static final int MM = 3;
    private static final double CM_PER_INCH = 2.54;
    private static final double MM_PER_INCH = 25.4;
    private int last_dpi = 72;
    private int last_width_unit = 0;
    private int last_height_unit = 0;
    private JFrame frame;
    private JPanel content;
    private JPanel options;
    private JPanel buttons;
    private JButton cancel;
    private JButton export;
    private TitledBorder optionsBorder;
    private SpinnerNumberModel width;
    private SpinnerNumberModel height;
    private JComboBox widthUnit;
    private JComboBox heightUnit;
    private SpinnerNumberModel dpiSpinner;
    private FlowLayout layout;
    private double realWidth;
    private double realHeight;
    boolean stateLock = false;
    private int dpi = this.last_dpi;
    GraphicsManager grMngr;

    public PrintWindow(double w, double h, GraphicsManager gm) {
        this.grMngr = gm;
        if (w < 1.0 || h < 1.0) {
            JOptionPane.showMessageDialog(this.grMngr.mainView.getFrame(), "Can not export visible region of size 0.", "Export to PNG error", 0);
            return;
        }
        this.realWidth = w;
        this.realHeight = h;
        this.frame = new JFrame("Print Options");
        this.frame.setResizable(false);
        this.content = new JPanel(new BorderLayout());
        this.frame.setContentPane(this.content);
        this.options = new JPanel(new GridLayout(3, 3));
        this.optionsBorder = BorderFactory.createTitledBorder("Print options");
        this.options.setBorder(this.optionsBorder);
        class UnitActionListener
        implements ActionListener {
            UnitActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintWindow.this.updateTextFields(false);
            }
        }
        UnitActionListener unitListener = new UnitActionListener();
        class TextChangeListener
        implements ChangeListener {
            TextChangeListener() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                PrintWindow.this.updateTextFields(true);
            }
        }
        TextChangeListener textListener = new TextChangeListener();
        this.width = new SpinnerNumberModel(this.realWidth, 1.0, Double.MAX_VALUE, 1.0);
        this.width.addChangeListener(textListener);
        this.widthUnit = new JComboBox<String>(units);
        this.widthUnit.addActionListener(unitListener);
        this.options.add(new JLabel("Image width: ", 4));
        this.options.add(new JSpinner(this.width));
        this.options.add(this.widthUnit);
        this.height = new SpinnerNumberModel(this.realHeight, 1.0, Double.MAX_VALUE, 1.0);
        this.height.addChangeListener(textListener);
        this.heightUnit = new JComboBox<String>(units);
        this.heightUnit.addActionListener(unitListener);
        this.options.add(new JLabel("Image height: ", 4));
        this.options.add(new JSpinner(this.height));
        this.options.add(this.heightUnit);
        this.dpiSpinner = new SpinnerNumberModel(this.last_dpi, 72, 9999, 1);
        class DPIChangeListener
        implements ChangeListener {
            DPIChangeListener() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                PrintWindow.this.dpi = PrintWindow.this.dpiSpinner.getNumber().intValue();
                PrintWindow.this.updateTextFields(false);
                PrintWindow.this.last_dpi = PrintWindow.this.dpi;
            }
        }
        this.dpiSpinner.addChangeListener(new DPIChangeListener());
        this.options.add(new JLabel("Dots per inch: ", 4));
        this.options.add(new JSpinner(this.dpiSpinner));
        this.content.add((Component)this.options, "Center");
        this.buttons = new JPanel(new FlowLayout(2));
        this.export = new JButton("Export");
        class ExportActionListener
        implements ActionListener {
            ExportActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintWindow.this.hide();
                PrintWindow.this.grMngr.mainView.setStatusBarText("Sending image to printer ... (This operation can take some time)");
                PrintWindow.this.realWidth = PrintWindow.this.unitToPixel(PrintWindow.this.realWidth, PrintWindow.this.widthUnit.getSelectedIndex());
                PrintWindow.this.realHeight = PrintWindow.this.unitToPixel(PrintWindow.this.realHeight, PrintWindow.this.heightUnit.getSelectedIndex());
                Vector<Camera> layers = new Vector<Camera>();
                layers.add(PrintWindow.this.grMngr.mainCamera);
                BufferedImage bi = PrintWindow.this.grMngr.mainView.rasterize((int)PrintWindow.this.realWidth, (int)PrintWindow.this.realHeight, layers);
                if (bi != null) {
                    PrintUtilities pu = new PrintUtilities(bi);
                    pu.print();
                }
                PrintWindow.this.grMngr.mainView.setStatusBarText("Sending image to printer ...done");
            }
        }
        this.export.addActionListener(new ExportActionListener());
        this.cancel = new JButton("Cancel");
        class CancelActionListener
        implements ActionListener {
            CancelActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintWindow.this.hide();
            }
        }
        this.cancel.addActionListener(new CancelActionListener());
        this.buttons.add(this.cancel);
        this.buttons.add(this.export);
        this.content.add((Component)this.buttons, "South");
        this.updateTextFields(false);
        this.frame.getRootPane().setDefaultButton(this.export);
        this.content.setPreferredSize(new Dimension(400, 200));
        this.frame.pack();
        this.frame.setLocationRelativeTo(this.grMngr.mainView.getFrame());
        this.frame.setVisible(true);
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public void hide() {
        this.frame.setVisible(false);
    }

    private void updateTextFields(boolean textChange) {
        if (this.stateLock) {
            return;
        }
        this.stateLock = true;
        String text = "";
        if (textChange) {
            this.realWidth = this.width.getNumber().doubleValue();
            this.realHeight = this.height.getNumber().doubleValue();
        }
        double pixels = this.realWidth;
        pixels = this.unitToPixel(this.realWidth, this.last_width_unit);
        pixels = this.pixelToUnit(pixels, this.widthUnit.getSelectedIndex());
        text = this.widthUnit.getSelectedIndex() == 0 ? "" + (int)pixels : "" + pixels;
        if (text.indexOf(".") >= 0) {
            text = text.substring(0, text.indexOf(".") + 2);
        }
        this.width.setValue(new Double(text));
        this.realWidth = pixels;
        pixels = this.realHeight;
        pixels = this.unitToPixel(this.realHeight, this.last_height_unit);
        pixels = this.pixelToUnit(pixels, this.heightUnit.getSelectedIndex());
        text = this.heightUnit.getSelectedIndex() == 0 ? "" + (int)pixels : "" + pixels;
        if (text.indexOf(".") >= 0) {
            text = text.substring(0, text.indexOf(".") + 2);
        }
        this.height.setValue(new Double(text));
        this.realHeight = pixels;
        this.last_width_unit = this.widthUnit.getSelectedIndex();
        this.last_height_unit = this.heightUnit.getSelectedIndex();
        this.stateLock = false;
    }

    private double unitToPixel(double number, int unit) {
        switch (unit) {
            case 1: {
                number *= (double)this.last_dpi;
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                number = number / 2.54 * (double)this.last_dpi;
                break;
            }
            case 3: {
                number = number / 25.4 * (double)this.last_dpi;
            }
        }
        return number;
    }

    private double pixelToUnit(double pixels, int unit) {
        switch (unit) {
            case 1: {
                pixels /= (double)this.last_dpi;
                break;
            }
            case 0: {
                pixels = pixels * (double)this.dpi / (double)this.last_dpi;
                break;
            }
            case 2: {
                pixels = pixels / (double)this.last_dpi * 2.54;
                break;
            }
            case 3: {
                pixels = pixels / (double)this.last_dpi * 25.4;
            }
        }
        return pixels;
    }
}

