/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.animation.AnimationManager;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.EView;
import fr.inria.zvtm.engine.PView;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.portals.Portal;
import fr.inria.zvtm.event.RepaintListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VText;
import java.awt.AWTEvent;
import java.awt.event.AWTEventListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.swing.JMenuBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualSpaceManager
implements AWTEventListener {
    public static short VIS_AND_SENS_GLYPHS = 0;
    public static short VISIBLE_GLYPHS = 1;
    public static short SENSITIVE_GLYPHS = (short)2;
    public static short ALL_GLYPHS = (short)3;
    static boolean debug = false;
    protected Hashtable<String, VirtualSpace> allVirtualSpaces;
    private List<VirtualSpace> virtualSpaceList;
    protected View[] allViews;
    protected Hashtable<String, Integer> name2viewIndex;
    View activeView;
    protected int activeViewIndex = -1;
    boolean defaultMultiFill = false;
    private final AnimationManager animationManager;
    public static final VirtualSpaceManager INSTANCE = new VirtualSpaceManager();
    Object activeJFrame = null;

    public void onMainFontUpdated() {
        for (int i = 0; i < this.allViews.length; ++i) {
            this.allViews[i].updateFont();
        }
        Enumeration<VirtualSpace> e = this.allVirtualSpaces.elements();
        while (e.hasMoreElements()) {
            Enumeration<Glyph> e2 = e.nextElement().getAllGlyphs().elements();
            while (e2.hasMoreElements()) {
                Glyph g = e2.nextElement();
                if (!(g instanceof VText)) continue;
                ((VText)g).invalidate();
            }
        }
        this.repaint();
    }

    private VirtualSpaceManager() {
        if (debug) {
            System.out.println("Debug mode ON");
        }
        this.animationManager = new AnimationManager(this);
        this.allVirtualSpaces = new Hashtable();
        this.virtualSpaceList = new ArrayList<VirtualSpace>(0);
        this.allViews = new View[0];
        this.name2viewIndex = new Hashtable();
    }

    public static void setDebug(boolean b) {
        debug = b;
    }

    public static boolean debugModeON() {
        return debug;
    }

    public AnimationManager getAnimationManager() {
        return this.animationManager;
    }

    public void setDefaultDetectMultiFills(boolean b) {
        this.defaultMultiFill = b;
    }

    public boolean getDefaultDetectMultiFills() {
        return this.defaultMultiFill;
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        if (e.getID() == 205) {
            this.activeJFrame = e.getSource();
        }
    }

    public void setActiveView(View v) {
        this.activeView = v;
        this.activeViewIndex = v != null ? this.getViewIndex(v.getName()) : -1;
    }

    public View getActiveView() {
        return this.activeView;
    }

    public Camera getActiveCamera() {
        return this.activeView != null ? this.activeView.getActiveCamera() : null;
    }

    public Portal addPortal(Portal p, View v) {
        return v.addPortal(p);
    }

    public void destroyPortal(Portal p) {
        View v = p.getOwningView();
        v.removePortal(p);
    }

    public EView addFrameView(List<Camera> c, String name, String viewType, int w, int h, boolean visible) {
        return this.addFrameView(new Vector<Camera>(c), name, viewType, w, h, false, visible, true, null);
    }

    public EView addFrameView(List<Camera> c, String name, String viewType, int w, int h, boolean bar, boolean visible, boolean decorated, JMenuBar mnb) {
        EView v = null;
        if (name == "AnonView") {
            name = UUID.randomUUID().toString();
            while (this.name2viewIndex.containsKey(name)) {
                name = UUID.randomUUID().toString();
            }
        }
        v = mnb != null ? new EView(viewType, new Vector<Camera>(c), name, w, h, bar, visible, decorated, mnb) : new EView(viewType, new Vector<Camera>(c), name, w, h, visible, decorated);
        this.addView(v);
        return v;
    }

    public PView addPanelView(List<Camera> c, String name, String viewType, int w, int h) {
        if (name == "AnonView") {
            name = UUID.randomUUID().toString();
            while (this.name2viewIndex.containsKey(name)) {
                name = UUID.randomUUID().toString();
            }
        }
        PView tvi = new PView(viewType, new Vector<Camera>(c), name, w, h);
        this.addView(tvi);
        return tvi;
    }

    protected void addView(View v) {
        View[] tmpA = new View[this.allViews.length + 1];
        System.arraycopy(this.allViews, 0, tmpA, 0, this.allViews.length);
        tmpA[this.allViews.length] = v;
        this.allViews = tmpA;
        this.name2viewIndex.put(v.name, new Integer(this.allViews.length - 1));
        this.animationManager.start();
    }

    protected int getViewIndex(String n) {
        try {
            return this.name2viewIndex.get(n);
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public View getView(String n) {
        int index = this.getViewIndex(n);
        if (index != -1) {
            return this.allViews[index];
        }
        return null;
    }

    protected void destroyView(int i) {
        View[] tmpA = new View[this.allViews.length - 1];
        if (tmpA.length > 0) {
            System.arraycopy(this.allViews, 0, tmpA, 0, i);
            System.arraycopy(this.allViews, i + 1, tmpA, i, this.allViews.length - i - 1);
        }
        this.allViews = tmpA;
        this.updateViewIndex();
    }

    protected void updateViewIndex() {
        this.name2viewIndex.clear();
        for (int i = 0; i < this.allViews.length; ++i) {
            this.name2viewIndex.put(this.allViews[i].name, new Integer(i));
        }
    }

    protected void destroyView(View v) {
        for (int i = 0; i < this.allViews.length; ++i) {
            if (this.allViews[i] != v) continue;
            this.destroyView(i);
            break;
        }
    }

    protected void destroyView(String viewName) {
        this.destroyView(this.getView(viewName));
    }

    public void repaint() {
        for (int i = 0; i < this.allViews.length; ++i) {
            this.allViews[i].repaint();
        }
    }

    public void repaint(View v) {
        v.repaint();
    }

    public void repaint(View v, RepaintListener rl) {
        v.repaint(rl);
    }

    public VirtualSpace addVirtualSpace(String name) {
        if (name == "AnonVS") {
            name = UUID.randomUUID().toString();
            while (this.allVirtualSpaces.containsKey(name)) {
                name = UUID.randomUUID().toString();
            }
        }
        VirtualSpace tvs = new VirtualSpace(name);
        this.allVirtualSpaces.put(name, tvs);
        this.updateVirtualSpaceList();
        return tvs;
    }

    public void destroyVirtualSpace(String name) {
        if (this.allVirtualSpaces.containsKey(name)) {
            this.allVirtualSpaces.get(name).destroy();
            this.allVirtualSpaces.remove(name);
            this.updateVirtualSpaceList();
        }
    }

    public void destroyVirtualSpace(VirtualSpace vs) {
        vs.destroy();
        String n = vs.getName();
        if (this.allVirtualSpaces.containsKey(n)) {
            this.allVirtualSpaces.remove(n);
            this.updateVirtualSpaceList();
        }
    }

    void updateVirtualSpaceList() {
        this.virtualSpaceList = new ArrayList<VirtualSpace>(this.allVirtualSpaces.values());
    }

    public VirtualSpace getOwningSpace(Glyph g) {
        Enumeration<VirtualSpace> e = this.allVirtualSpaces.elements();
        while (e.hasMoreElements()) {
            VirtualSpace vs = e.nextElement();
            if (!vs.getAllGlyphs().contains(g)) continue;
            return vs;
        }
        return null;
    }

    public VirtualSpace getVirtualSpace(String n) {
        return this.allVirtualSpaces.get(n);
    }

    public List<VirtualSpace> getVirtualSpaces() {
        return Collections.unmodifiableList(this.virtualSpaceList);
    }

    public VirtualSpace getActiveSpace() {
        return this.activeView != null ? this.activeView.getActiveCamera().getOwningSpace() : null;
    }
}

