/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.MapIterator;
import org.apache.commons.collections15.OrderedMap;
import org.apache.commons.collections15.OrderedMapIterator;
import org.apache.commons.collections15.Unmodifiable;
import org.apache.commons.collections15.collection.UnmodifiableCollection;
import org.apache.commons.collections15.iterators.UnmodifiableMapIterator;
import org.apache.commons.collections15.iterators.UnmodifiableOrderedMapIterator;
import org.apache.commons.collections15.map.AbstractOrderedMapDecorator;
import org.apache.commons.collections15.map.UnmodifiableEntrySet;
import org.apache.commons.collections15.set.UnmodifiableSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableOrderedMap<K, V>
extends AbstractOrderedMapDecorator<K, V>
implements Unmodifiable,
Serializable {
    private static final long serialVersionUID = 8136428161720526266L;

    public static <K, V> OrderedMap<K, V> decorate(OrderedMap<K, V> map) {
        if (map instanceof Unmodifiable) {
            return map;
        }
        return new UnmodifiableOrderedMap<K, V>(map);
    }

    private UnmodifiableOrderedMap(OrderedMap<K, V> map) {
        super(map);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    @Override
    public MapIterator<K, V> mapIterator() {
        MapIterator it = this.getOrderedMap().mapIterator();
        return UnmodifiableMapIterator.decorate(it);
    }

    @Override
    public OrderedMapIterator<K, V> orderedMapIterator() {
        OrderedMapIterator it = this.getOrderedMap().orderedMapIterator();
        return UnmodifiableOrderedMapIterator.decorate(it);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> mapToCopy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = super.entrySet();
        return UnmodifiableEntrySet.decorate(set);
    }

    @Override
    public Set<K> keySet() {
        Set set = super.keySet();
        return UnmodifiableSet.decorate(set);
    }

    @Override
    public Collection<V> values() {
        Collection coll = super.values();
        return UnmodifiableCollection.decorate(coll);
    }
}

