/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class XtextProjectHelper {
    public static final String NATURE_ID = "org.eclipse.xtext.ui.shared.xtextNature";
    public static final String BUILDER_ID = "org.eclipse.xtext.ui.shared.xtextBuilder";
    private static final Logger log = Logger.getLogger(XtextProjectHelper.class);

    public static boolean hasNature(IProject project) {
        try {
            if (project.isAccessible()) {
                return project.hasNature(NATURE_ID);
            }
        }
        catch (CoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasBuilder(IProject project) {
        if (!project.isAccessible()) return false;
        try {
            ICommand[] iCommandArray = project.getDescription().getBuildSpec();
            int n = iCommandArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICommand command = iCommandArray[n2];
                if (BUILDER_ID.equals(command.getBuilderName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            log.error((Object)"Can't build due to an exception.", (Throwable)e);
        }
        return false;
    }
}

