/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.workflow.serializer;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.sew.launcher.workflow.Director;
import org.eclipse.efm.sew.launcher.workflow.IWorkflowConfigurationConstants;
import org.eclipse.efm.sew.launcher.workflow.common.DeveloperTuningOptionCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.ManifestCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.TraceSpecificationCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.serializer.impl.SymbexGraphVizSerializerWorkerImpl;
import org.eclipse.efm.sew.launcher.workflow.util.PrettyPrintWriter;

public class ModelGraphvizSerializerWorkerCustomImpl
extends SymbexGraphVizSerializerWorkerImpl
implements IWorkflowConfigurationConstants {
    public ModelGraphvizSerializerWorkerCustomImpl(Director director, String name) {
        this.setDirector(director);
        this.setName(name);
    }

    public ModelGraphvizSerializerWorkerCustomImpl(Director director, String name, String description) {
        this.setDirector(director);
        this.setName(name);
        this.setDescription(description);
    }

    public static ModelGraphvizSerializerWorkerCustomImpl create(Director director, ILaunchConfiguration configuration) {
        ModelGraphvizSerializerWorkerCustomImpl serializerWorker = new ModelGraphvizSerializerWorkerCustomImpl(director, "model2graphiz");
        String modelFilename = DeveloperTuningOptionCustomImpl.getModelFilename(configuration);
        serializerWorker.setFileName(String.valueOf(modelFilename) + "_graph.gv");
        return serializerWorker;
    }

    public void toWriter(PrettyPrintWriter writer) {
        TraceSpecificationCustomImpl format;
        writer.commentLine(this.getComment());
        writer.appendTab("serializer#model#graphviz");
        String str = this.getName();
        if (str != null) {
            writer.append(' ').append(str);
        }
        if ((str = this.getDescription()) != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" {");
        PrettyPrintWriter writer2 = writer.itab2();
        ManifestCustomImpl manifest = (ManifestCustomImpl)this.getManifest();
        if (manifest != null) {
            manifest.toWriter(writer2);
        }
        if ((format = (TraceSpecificationCustomImpl)this.getFormat()) != null) {
            format.toWriter(writer2);
        }
        String justifier = "";
        writer2.appendTabEol("vfs [");
        String path = this.getFolderName();
        if (path != null) {
            writer2.appendTab2("folder = \"").append(path).appendEol("\"");
            justifier = "  ";
        }
        if ((path = this.getFileName()) != null) {
            writer2.appendTab2("file").append(justifier).append(" = \"").append(path).appendEol("\"");
        }
        writer2.appendTabEol("] // end vfs");
        writer.appendTabEol("}");
    }
}

