/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.image.spi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.ServiceLoader;
import javafx.scene.text.Font;
import org.eclipse.fx.ui.controls.image.spi.IconFontProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class IconFontLookup {
    public static IconFontProvider getProviderForFont(Font font) {
        IconFontProvider result = null;
        try {
            Class<?> util = Class.forName("org.osgi.framework.FrameworkUtil");
            if (util != null) {
                Method method = util.getMethod("getBundle", Class.class);
                Bundle bundle = (Bundle)method.invoke(null, IconFontLookup.class);
                if (bundle != null) {
                    result = IconFontLookup.getProviderForFontOSGi(bundle, font);
                    return result;
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        if (result == null) {
            result = IconFontLookup.getProviderForFontSPI(font);
        }
        return result;
    }

    private static IconFontProvider getProviderForFontOSGi(Bundle bundle, Font font) {
        IconFontProvider result = null;
        try {
            BundleContext bundleContext = bundle.getBundleContext();
            Collection serviceReferences = bundleContext.getServiceReferences(IconFontProvider.class, null);
            for (ServiceReference ref : serviceReferences) {
                IconFontProvider service = (IconFontProvider)bundleContext.getService(ref);
                if (!service.getName().equals(font.getName())) continue;
                result = service;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static IconFontProvider getProviderForFontSPI(Font font) {
        IconFontProvider result = null;
        ServiceLoader<IconFontProvider> load = ServiceLoader.load(IconFontProvider.class);
        for (IconFontProvider sup : load) {
            if (!sup.getName().equals(font.getName())) continue;
            result = sup;
            break;
        }
        return result;
    }
}

