/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopes;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.IExpressionScope;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureScopeSessionToResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.Maps2;

public class ExpressionScope
implements IExpressionScope {
    private final FeatureScopes featureScopes;
    private final EObject context;
    private final List<FeatureScopeSessionToResolvedTypes> data;
    private final IExpressionScope.Anchor anchor;
    private EnumMap<IExpressionScope.Anchor, IScope> cachedFeatureScope = Maps.newEnumMap(IExpressionScope.Anchor.class);
    private IScope cachedReceiverFeatureScope;
    private XAbstractFeatureCall requestedFeatureCall;
    private ITypeReferenceOwner owner;

    public ExpressionScope(FeatureScopes featureScopes, EObject context, IExpressionScope.Anchor anchor, ITypeReferenceOwner owner) {
        this.owner = owner;
        this.data = Lists.newArrayListWithExpectedSize((int)2);
        this.featureScopes = featureScopes;
        this.context = context;
        this.anchor = anchor;
    }

    public IExpressionScope withAnchor(final IExpressionScope.Anchor anchor) {
        if (anchor == this.anchor) {
            return this;
        }
        return new IExpressionScope(){

            @Override
            public IScope getFeatureScope() {
                return ExpressionScope.this.getFeatureScope(anchor);
            }

            @Override
            public IScope getFeatureScope(XAbstractFeatureCall currentFeatureCall) {
                return ExpressionScope.this.getFeatureScope(currentFeatureCall, anchor);
            }

            @Override
            public List<String> getTypeNamePrefix() {
                return ExpressionScope.this.getTypeNamePrefix();
            }

            @Override
            public boolean isPotentialTypeLiteral() {
                return ExpressionScope.this.isPotentialTypeLiteral();
            }
        };
    }

    protected IScope getFeatureScope(IExpressionScope.Anchor anchor) {
        IScope cached = this.cachedFeatureScope.get((Object)anchor);
        if (cached != null) {
            return cached;
        }
        if (anchor != IExpressionScope.Anchor.RECEIVER) {
            cached = this.createSimpleFeatureCallScope();
            this.cachedFeatureScope.put(anchor, cached);
            return cached;
        }
        if (this.context instanceof XExpression) {
            cached = this.createFeatureCallScopeForReceiver(null);
            this.cachedFeatureScope.put(anchor, cached);
            return cached;
        }
        this.cachedFeatureScope.put(anchor, IScope.NULLSCOPE);
        return IScope.NULLSCOPE;
    }

    protected IScope createFeatureCallScopeForReceiver(XAbstractFeatureCall receiver) {
        int i;
        ArrayList dataToUse;
        if (this.data.size() == 1) {
            dataToUse = this.data;
        } else {
            dataToUse = Lists.newArrayListWithExpectedSize((int)3);
            HashSet seenReceiverTypes = Sets.newHashSet();
            i = 0;
            while (i < this.data.size()) {
                FeatureScopeSessionToResolvedTypes next = this.data.get(i);
                LightweightTypeReference receiverType = next.getTypes().getActualType(receiver);
                if (receiverType == null) {
                    if (seenReceiverTypes.add(null)) {
                        dataToUse.add(next);
                    }
                } else if (seenReceiverTypes.add(receiverType.getIdentifier())) {
                    dataToUse.add(next);
                }
                ++i;
            }
        }
        if (dataToUse.size() == 1) {
            FeatureScopeSessionToResolvedTypes single = (FeatureScopeSessionToResolvedTypes)dataToUse.get(0);
            Scope result = new Scope(this.featureScopes.createFeatureCallScopeForReceiver(receiver, (XExpression)this.context, single.getSession(), single.getTypes()), this.owner);
            return result;
        }
        Object result = IScope.NULLSCOPE;
        i = dataToUse.size() - 1;
        while (i >= 0) {
            FeatureScopeSessionToResolvedTypes f = (FeatureScopeSessionToResolvedTypes)dataToUse.get(i);
            result = new DelegateScope((IScope)result, this.featureScopes.createFeatureCallScopeForReceiver(receiver, (XExpression)this.context, f.getSession(), f.getTypes()));
            --i;
        }
        return new Scope((IScope)result, this.owner);
    }

    protected IScope createSimpleFeatureCallScope() {
        int i;
        ArrayList dataToUse;
        if (this.data.size() == 1) {
            dataToUse = this.data;
        } else {
            dataToUse = Lists.newArrayListWithExpectedSize((int)3);
            HashSet seenSessionData = Sets.newHashSet();
            i = 0;
            while (i < this.data.size()) {
                FeatureScopeSessionToResolvedTypes next = this.data.get(i);
                if (seenSessionData.add(next)) {
                    dataToUse.add(next);
                }
                ++i;
            }
        }
        if (dataToUse.size() == 1) {
            FeatureScopeSessionToResolvedTypes single = (FeatureScopeSessionToResolvedTypes)dataToUse.get(0);
            Scope result = new Scope(this.featureScopes.createSimpleFeatureCallScope(this.context, single.getSession(), single.getTypes()), this.owner);
            return result;
        }
        Object result = IScope.NULLSCOPE;
        i = dataToUse.size() - 1;
        while (i >= 0) {
            FeatureScopeSessionToResolvedTypes f = (FeatureScopeSessionToResolvedTypes)dataToUse.get(i);
            result = new DelegateScope((IScope)result, this.featureScopes.createSimpleFeatureCallScope(this.context, f.getSession(), f.getTypes()));
            --i;
        }
        return new Scope((IScope)result, this.owner);
    }

    public IScope getFeatureScope(XAbstractFeatureCall currentFeatureCall, IExpressionScope.Anchor anchor) {
        if (anchor == IExpressionScope.Anchor.RECEIVER) {
            if (currentFeatureCall == this.requestedFeatureCall && this.cachedReceiverFeatureScope != null) {
                return this.cachedReceiverFeatureScope;
            }
            IScope result = this.createFeatureCallScopeForReceiver(currentFeatureCall);
            this.requestedFeatureCall = currentFeatureCall;
            this.cachedReceiverFeatureScope = result;
            return this.cachedReceiverFeatureScope;
        }
        return this.getFeatureScope(anchor);
    }

    @Override
    public IScope getFeatureScope() {
        return this.getFeatureScope(this.anchor);
    }

    @Override
    public IScope getFeatureScope(XAbstractFeatureCall currentFeatureCall) {
        return this.getFeatureScope(currentFeatureCall, this.anchor);
    }

    public void addData(IFeatureScopeSession session, IResolvedTypes types) {
        this.cachedFeatureScope.clear();
        this.cachedReceiverFeatureScope = null;
        this.requestedFeatureCall = null;
        this.data.add(new FeatureScopeSessionToResolvedTypes(session, types));
    }

    public void replacePreviousData(IFeatureScopeSession session) {
        FeatureScopeSessionToResolvedTypes prev = this.data.remove(this.data.size() - 1);
        this.data.add(new FeatureScopeSessionToResolvedTypes(session, prev.getTypes()));
    }

    @Override
    public List<String> getTypeNamePrefix() {
        return Collections.emptyList();
    }

    @Override
    public boolean isPotentialTypeLiteral() {
        return false;
    }

    public static class DelegateScope
    extends AbstractScope {
        private IScope delegate;
        private Set<String> containedKeys;
        private List<IEObjectDescription> containedElements;

        protected DelegateScope(IScope parent, IScope delegate) {
            super(parent, false);
            this.delegate = delegate;
        }

        protected Iterable<IEObjectDescription> getAllLocalElements() {
            if (this.containedElements == null) {
                if (this.getParent() != IScope.NULLSCOPE) {
                    Iterable result = this.delegate.getAllElements();
                    ArrayList list = Lists.newArrayList((Iterable)result);
                    HashSet keys = Sets.newHashSet();
                    for (IEObjectDescription desc : result) {
                        list.add(desc);
                        keys.add(this.getShadowingKey(desc));
                    }
                    this.containedKeys = keys;
                    this.containedElements = list;
                    return list;
                }
                return this.delegate.getAllElements();
            }
            return this.containedElements;
        }

        protected boolean isShadowed(IEObjectDescription fromParent) {
            if (this.containedKeys == null) {
                return super.isShadowed(fromParent);
            }
            return this.containedKeys.contains(this.getShadowingKey(fromParent));
        }

        protected String getShadowingKey(IEObjectDescription description) {
            if (description instanceof BucketedEObjectDescription) {
                return ((BucketedEObjectDescription)description).getShadowingKey();
            }
            return description.getName().toString();
        }
    }

    public static class Scope
    implements IScope {
        private final IScope delegate;
        private final ITypeReferenceOwner owner;
        private List<IEObjectDescription> allElements;
        private Map<QualifiedName, List<IEObjectDescription>> allElementsByName;

        public Scope(IScope delegate, ITypeReferenceOwner owner) {
            this.delegate = delegate;
            this.owner = owner;
        }

        public IEObjectDescription getSingleElement(QualifiedName name) {
            return this.delegate.getSingleElement(name);
        }

        public Iterable<IEObjectDescription> getElements(QualifiedName name) {
            this.ensureInitialized();
            List<IEObjectDescription> result = this.allElementsByName.get(name);
            if (result != null) {
                return result;
            }
            return Collections.emptyList();
        }

        public IEObjectDescription getSingleElement(EObject object) {
            return this.delegate.getSingleElement(object);
        }

        public Iterable<IEObjectDescription> getElements(EObject object) {
            return this.delegate.getElements(object);
        }

        public Iterable<IEObjectDescription> getAllElements() {
            this.ensureInitialized();
            return this.allElements;
        }

        protected void ensureInitialized() {
            if (this.allElements == null) {
                ArrayList allElements = Lists.newArrayList();
                HashMap allElementsByName = Maps.newHashMap();
                this.populateFromParent(allElements, allElementsByName);
                this.allElements = allElements;
                this.allElementsByName = allElementsByName;
            }
        }

        protected void populateFromParent(List<IEObjectDescription> allElements, Map<QualifiedName, List<IEObjectDescription>> allElementsByName) {
            HashMap extensionSignatures = Maps.newHashMap();
            HashMap signatures = Maps.newHashMap();
            for (IEObjectDescription element : this.delegate.getAllElements()) {
                if (element instanceof IIdentifiableElementDescription) {
                    IIdentifiableElementDescription desc = (IIdentifiableElementDescription)element;
                    if (!desc.isVisible() || !desc.isValidStaticState() || this.isInvalidThisReference(desc)) continue;
                    if (desc.isExtension()) {
                        Maps2.putIntoListMap(this.getExtensionSignature(desc), desc, extensionSignatures);
                        continue;
                    }
                    if (desc.getImplicitReceiver() != null && desc.getSyntacticReceiver() instanceof XMemberFeatureCall) continue;
                    this.recordDescription(desc, (Map<String, IEObjectDescription>)signatures);
                    continue;
                }
                this.recordDescription(element, (Map<String, IEObjectDescription>)signatures);
            }
            List<IIdentifiableElementDescription> extensionDescriptions = this.getFilteredExtensionDescriptions(extensionSignatures);
            for (IIdentifiableElementDescription desc : extensionDescriptions) {
                this.recordDescription(desc, (Map<String, IEObjectDescription>)signatures);
            }
            for (IEObjectDescription valid : signatures.values()) {
                allElements.add(valid);
                Maps2.putIntoListMap(valid.getName(), valid, allElementsByName);
            }
        }

        private boolean isInvalidThisReference(IIdentifiableElementDescription desc) {
            EObject object = desc.getEObjectOrProxy();
            return object instanceof JvmGenericType && ((JvmGenericType)object).isInterface() && IFeatureNames.THIS.equals((Object)desc.getName());
        }

        protected void recordDescription(IEObjectDescription element, Map<String, IEObjectDescription> result) {
            this.recordDescription(this.getSignature(element), element, result);
        }

        protected void recordDescription(String signature, IEObjectDescription element, Map<String, IEObjectDescription> result) {
            IEObjectDescription known = result.get(signature);
            if (known != null) {
                if (!this.isAliased(known)) {
                    return;
                }
                if (this.isAliased(element)) {
                    return;
                }
            }
            result.put(signature, element);
        }

        protected boolean isAliased(IEObjectDescription desc) {
            String usedName;
            String actualName = ((JvmIdentifiableElement)desc.getEObjectOrProxy()).getSimpleName();
            return !actualName.equals(usedName = desc.getName().getFirstSegment());
        }

        protected void recordDescription(IIdentifiableElementDescription desc, Map<String, IEObjectDescription> result) {
            this.recordDescription(this.getSignature(desc), desc, result);
        }

        protected LightweightTypeReference getFirstParameterType(IIdentifiableElementDescription candidate) {
            JvmOperation operation = (JvmOperation)candidate.getElementOrProxy();
            return this.getParameterType((JvmFormalParameter)operation.getParameters().get(0));
        }

        protected LightweightTypeReference getParameterType(JvmFormalParameter p) {
            JvmTypeReference parameterType = p.getParameterType();
            JvmType type = parameterType.getType();
            if (type == null) {
                return null;
            }
            return this.owner.toPlainTypeReference(type).getRawTypeReference();
        }

        protected List<IIdentifiableElementDescription> getFilteredExtensionDescriptions(Map<String, List<IIdentifiableElementDescription>> extensionSignatures) {
            ArrayList result = Lists.newArrayList();
            for (List<IIdentifiableElementDescription> list : extensionSignatures.values()) {
                int size = list.size();
                int i = 0;
                while (i < size) {
                    IIdentifiableElementDescription candidate = list.get(i);
                    if (candidate != null) {
                        LightweightTypeReference firstParameterType = this.getFirstParameterType(candidate);
                        if (firstParameterType != null && i + 1 < list.size()) {
                            int j = i + 1;
                            while (j < list.size() && firstParameterType != null) {
                                IIdentifiableElementDescription next = list.get(j);
                                if (next != null) {
                                    if (next.isStatic() != candidate.isStatic()) {
                                        if (next.isStatic()) {
                                            list.set(j, null);
                                        } else {
                                            list.set(j, null);
                                            candidate = next;
                                            firstParameterType = this.getFirstParameterType(next);
                                        }
                                    } else {
                                        LightweightTypeReference otherFirstParameterType = this.getFirstParameterType(next);
                                        if (otherFirstParameterType != null) {
                                            if (otherFirstParameterType.isAssignableFrom(firstParameterType)) {
                                                list.set(j, null);
                                            } else if (firstParameterType.isAssignableFrom(otherFirstParameterType)) {
                                                list.set(j, null);
                                                candidate = next;
                                                firstParameterType = otherFirstParameterType;
                                            }
                                        }
                                    }
                                }
                                ++j;
                            }
                        }
                        result.add(candidate);
                    }
                    ++i;
                }
            }
            return result;
        }

        protected String getExtensionSignature(IIdentifiableElementDescription desc) {
            JvmOperation operation = (JvmOperation)desc.getElementOrProxy();
            StringBuilder builder = new StringBuilder(64).append(desc.getName());
            String opName = operation.getSimpleName();
            if (opName.length() - 3 == desc.getName().getFirstSegment().length() && opName.startsWith("set")) {
                builder.append("=");
            }
            this.appendParameters((JvmExecutable)operation, builder, desc.isExtension());
            return builder.toString();
        }

        protected String getSignature(IEObjectDescription desc) {
            if (desc instanceof IIdentifiableElementDescription) {
                return this.getSignature((IIdentifiableElementDescription)desc);
            }
            return desc.getName().toString();
        }

        protected String getSignature(IIdentifiableElementDescription desc) {
            String descName = desc.getName().getFirstSegment();
            StringBuilder builder = new StringBuilder(64).append(descName);
            JvmIdentifiableElement elementOrProxy = desc.getElementOrProxy();
            if (elementOrProxy instanceof JvmExecutable) {
                JvmExecutable executable = (JvmExecutable)desc.getElementOrProxy();
                String opName = executable.getSimpleName();
                if (opName.length() - 3 == descName.length() && opName.startsWith("set")) {
                    builder.append("=");
                }
                this.appendParameters(executable, builder, desc.isExtension());
            }
            return builder.toString();
        }

        protected void appendParameters(JvmExecutable executable, StringBuilder result, boolean extension) {
            EList parameters;
            int end;
            int start = extension ? 1 : 0;
            if (start != (end = (parameters = executable.getParameters()).size())) {
                result.append('(');
                int i = start;
                while (i < end) {
                    JvmFormalParameter parameter;
                    LightweightTypeReference parameterType;
                    if (i != start) {
                        result.append(',');
                    }
                    if ((parameterType = this.getParameterType(parameter = (JvmFormalParameter)parameters.get(i))) != null) {
                        result.append(parameterType.getIdentifier());
                    } else {
                        result.append("[null]");
                    }
                    ++i;
                }
                result.append(')');
            }
        }
    }
}

