/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.fx.code.editor.SourceFileChange;
import org.eclipse.fx.code.editor.SourceFileInput;
import org.eclipse.fx.core.URI;
import org.eclipse.fx.core.adapter.Adapt;
import org.eclipse.fx.core.event.EventBus;

public class LocalSourceFileInput
implements SourceFileInput {
    private final Path path;
    private final Charset charSet;
    private String data;
    private String savedData;
    private EventBus eventBus;

    @Inject
    public LocalSourceFileInput(@Adapt @Named(value="documentUrl") Path path, @Optional EventBus eventBus) {
        this(path, StandardCharsets.UTF_8, eventBus);
    }

    public LocalSourceFileInput(Path path, Charset charSet, @Optional EventBus eventBus) {
        this.path = path;
        this.charSet = charSet;
        this.eventBus = eventBus;
    }

    @PostConstruct
    protected void init() {
        if (this.eventBus != null) {
            this.eventBus.publish("at/bestsolution/dart/editor/file-input/created", (Object)this, true);
        }
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    @PreDestroy
    public final void dispose() {
        this.doDispose();
    }

    protected void doDispose() {
        if (this.eventBus != null) {
            this.eventBus.publish("at/bestsolution/dart/editor/file-input/disposed", (Object)this, true);
        }
    }

    @Override
    public String getData() {
        if (this.data == null) {
            try {
                byte[] bytes = Files.readAllBytes(this.path);
                this.data = this.savedData = new String(bytes, this.charSet);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read file content of '" + this.path + "'", e);
            }
        }
        return this.data;
    }

    @Override
    public void setData(String data) {
        this.data = data;
    }

    @Override
    public void persist() {
        try {
            Files.write(this.path, this.data.getBytes(this.charSet), new OpenOption[0]);
            this.savedData = this.data;
            if (this.eventBus != null) {
                this.eventBus.publish("at/bestsolution/dart/editor/file-input/saved", (Object)this, true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write content to file '" + this.path + "'", e);
        }
    }

    @Override
    public void reset() {
        this.data = this.savedData;
    }

    @Override
    public URI getURI() {
        return URI.create((String)this.path.toUri().toString());
    }

    @Override
    public void updateData(int offset, int length, String replacement) {
        StringBuilder b = new StringBuilder(this.data.length() - length + replacement.length());
        b.append(this.data.substring(0, offset));
        b.append(replacement);
        b.append(this.data.substring(offset + length, this.data.length()));
        this.data = b.toString();
        if (this.eventBus != null) {
            SourceFileChange sourceChange = new SourceFileChange(this, offset, length, replacement);
            this.eventBus.publish("at/bestsolution/dart/editor/file-input/modified", (Object)sourceChange, true);
        }
    }
}

