/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;

public class LineMappingProvider {
    public List<LineMapping> getLineMapping(AbstractTraceRegion rootTraceRegion) {
        LinkedHashSet lineData = Sets.newLinkedHashSet();
        this.createSmapInfo(rootTraceRegion, lineData);
        if (lineData.isEmpty()) {
            return null;
        }
        List<LineMapping> lineInfo = this.normalizeLineInfo(lineData);
        if (lineInfo.isEmpty()) {
            return null;
        }
        return lineInfo;
    }

    protected Set<Integer> createSmapInfo(AbstractTraceRegion targetRegion, Set<LineMapping> lineMappings) {
        URI path;
        ILocationData location;
        HashSet mapped = Sets.newHashSet();
        for (AbstractTraceRegion nested : targetRegion.getNestedRegions()) {
            mapped.addAll(this.createSmapInfo(nested, lineMappings));
        }
        if (targetRegion.isUseForDebugging() && (location = targetRegion.getMergedAssociatedLocation()) != null && (path = targetRegion.getAssociatedPath()) != null) {
            int myLineNumber = targetRegion.getMyLineNumber();
            int myEndLineNumber = targetRegion.getMyEndLineNumber();
            int i = myLineNumber;
            while (i <= myEndLineNumber) {
                if (!mapped.contains(i)) {
                    LineMapping e = new LineMapping(location.getLineNumber() + 1, i, i, path);
                    lineMappings.add(e);
                    mapped.add(i);
                }
                ++i;
            }
        }
        return mapped;
    }

    protected List<LineMapping> normalizeLineInfo(Set<LineMapping> lineData) {
        ArrayList list = Lists.newArrayList(lineData);
        Collections.sort(list, new Comparator<LineMapping>(){

            @Override
            public int compare(LineMapping o1, LineMapping o2) {
                int compareResult = o2.targetStartLine - o1.targetStartLine;
                if (compareResult == 0) {
                    return o2.targetEndLine - o1.targetEndLine;
                }
                return compareResult;
            }
        });
        LinkedList result = Lists.newLinkedList();
        LineMapping current = null;
        for (LineMapping mapping : list) {
            if (current != null && current.sourceStartLine == mapping.sourceStartLine && current.source.equals(mapping.source)) {
                current.targetStartLine = Math.min(current.targetStartLine, mapping.targetStartLine);
                current.targetEndLine = Math.max(current.targetEndLine, mapping.targetEndLine);
                continue;
            }
            if (current != null) {
                result.add(0, current);
            }
            current = new LineMapping(mapping.sourceStartLine, mapping.targetStartLine, mapping.targetEndLine, mapping.source);
        }
        if (current != null) {
            result.add(0, current);
        }
        return result;
    }

    public static class LineMapping {
        public int sourceStartLine;
        public int targetStartLine;
        public int targetEndLine;
        public URI source;

        public LineMapping(int sourceStartLine, int targetStartLine, int targetEndLine, URI source) {
            this.sourceStartLine = sourceStartLine;
            this.targetStartLine = targetStartLine;
            this.targetEndLine = targetEndLine;
            this.source = source;
            if (sourceStartLine < 0 || targetStartLine < 0 || targetEndLine < 0 || targetStartLine > targetEndLine || source == null) {
                throw new IllegalArgumentException(this.toString());
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + this.sourceStartLine;
            result = 31 * result + this.targetEndLine;
            result = 31 * result + this.targetStartLine;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LineMapping other = (LineMapping)obj;
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            if (this.sourceStartLine != other.sourceStartLine) {
                return false;
            }
            if (this.targetEndLine != other.targetEndLine) {
                return false;
            }
            return this.targetStartLine == other.targetStartLine;
        }

        public String toString() {
            return "LineMapping [sourceStartLine=" + this.sourceStartLine + ", targetStartLine=" + this.targetStartLine + ", targetEndLine=" + this.targetEndLine + ", source=" + this.source + "]";
        }
    }
}

