/*******************************************************************************
 * Copyright (c) 2012 BestSolution.at and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tom Schindl<tom.schindl@bestsolution.at> - initial API and implementation
 *******************************************************************************/
package org.eclipse.fx.formats.svg.svg;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Fe Spot Light Element</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getX <em>X</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getY <em>Y</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getZ <em>Z</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getPointsAtX <em>Points At X</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getPointsAtY <em>Points At Y</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getPointsAtZ <em>Points At Z</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getSpecularExponent <em>Specular Exponent</em>}</li>
 *   <li>{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getLimitingConeAngle <em>Limiting Cone Angle</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgFeSpotLightElement()
 * @model
 * @generated
 */
public interface SvgFeSpotLightElement extends SvgElement, CoreAttributes, LightSourceElement, ContentElement<SvgElement> {
	/**
	 * Returns the value of the '<em><b>X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>X</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>X</em>' attribute.
	 * @see #setX(Double)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgFeSpotLightElement_X()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.Number"
	 * @generated
	 */
	Double getX();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getX <em>X</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>X</em>' attribute.
	 * @see #getX()
	 * @generated
	 */
	void setX(Double value);

	/**
	 * Returns the value of the '<em><b>Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Y</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Y</em>' attribute.
	 * @see #setY(Double)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgFeSpotLightElement_Y()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.Number"
	 * @generated
	 */
	Double getY();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getY <em>Y</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Y</em>' attribute.
	 * @see #getY()
	 * @generated
	 */
	void setY(Double value);

	/**
	 * Returns the value of the '<em><b>Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Z</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Z</em>' attribute.
	 * @see #setZ(Double)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgFeSpotLightElement_Z()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.Number"
	 * @generated
	 */
	Double getZ();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getZ <em>Z</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Z</em>' attribute.
	 * @see #getZ()
	 * @generated
	 */
	void setZ(Double value);

	/**
	 * Returns the value of the '<em><b>Points At X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Points At X</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Points At X</em>' attribute.
	 * @see #setPointsAtX(Double)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgFeSpotLightElement_PointsAtX()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.Number"
	 * @generated
	 */
	Double getPointsAtX();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getPointsAtX <em>Points At X</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Points At X</em>' attribute.
	 * @see #getPointsAtX()
	 * @generated
	 */
	void setPointsAtX(Double value);

	/**
	 * Returns the value of the '<em><b>Points At Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Points At Y</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Points At Y</em>' attribute.
	 * @see #setPointsAtY(Double)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgFeSpotLightElement_PointsAtY()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.Number"
	 * @generated
	 */
	Double getPointsAtY();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getPointsAtY <em>Points At Y</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Points At Y</em>' attribute.
	 * @see #getPointsAtY()
	 * @generated
	 */
	void setPointsAtY(Double value);

	/**
	 * Returns the value of the '<em><b>Points At Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Points At Z</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Points At Z</em>' attribute.
	 * @see #setPointsAtZ(Double)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgFeSpotLightElement_PointsAtZ()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.Number"
	 * @generated
	 */
	Double getPointsAtZ();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getPointsAtZ <em>Points At Z</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Points At Z</em>' attribute.
	 * @see #getPointsAtZ()
	 * @generated
	 */
	void setPointsAtZ(Double value);

	/**
	 * Returns the value of the '<em><b>Specular Exponent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Specular Exponent</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Specular Exponent</em>' attribute.
	 * @see #setSpecularExponent(Double)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgFeSpotLightElement_SpecularExponent()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.Number"
	 * @generated
	 */
	Double getSpecularExponent();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getSpecularExponent <em>Specular Exponent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Specular Exponent</em>' attribute.
	 * @see #getSpecularExponent()
	 * @generated
	 */
	void setSpecularExponent(Double value);

	/**
	 * Returns the value of the '<em><b>Limiting Cone Angle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Limiting Cone Angle</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Limiting Cone Angle</em>' attribute.
	 * @see #setLimitingConeAngle(Double)
	 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getSvgFeSpotLightElement_LimitingConeAngle()
	 * @model dataType="org.eclipse.fx.formats.svg.svg.Number"
	 * @generated
	 */
	Double getLimitingConeAngle();

	/**
	 * Sets the value of the '{@link org.eclipse.fx.formats.svg.svg.SvgFeSpotLightElement#getLimitingConeAngle <em>Limiting Cone Angle</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Limiting Cone Angle</em>' attribute.
	 * @see #getLimitingConeAngle()
	 * @generated
	 */
	void setLimitingConeAngle(Double value);

} // SvgFeSpotLightElement
