/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter.linewrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Token;
import org.eclipse.jdt.internal.formatter.TokenManager;
import org.eclipse.jdt.internal.formatter.TokenTraverser;
import org.eclipse.jdt.internal.formatter.linewrap.CommentWrapExecutor;
import org.eclipse.jdt.internal.formatter.linewrap.FieldAligner;
import org.eclipse.jdt.internal.formatter.linewrap.WrapExecutor;

public class WrapPreparator
extends ASTVisitor {
    private static final Map<InfixExpression.Operator, Integer> OPERATOR_PRECEDENCE;
    private static final float PREFERRED = 0.875f;
    final TokenManager tm;
    final DefaultCodeFormatterOptions options;
    final int kind;
    final FieldAligner fieldAligner;
    int importsStart = -1;
    int importsEnd = -1;
    private List<Integer> wrapIndexes = new ArrayList<Integer>();
    private List<Float> wrapPenalties = new ArrayList<Float>();
    private int wrapParentIndex = -1;
    private int wrapGroupEnd = -1;
    private int currentDepth = 0;

    static {
        HashMap<InfixExpression.Operator, Integer> precedence = new HashMap<InfixExpression.Operator, Integer>();
        precedence.put(InfixExpression.Operator.TIMES, 1);
        precedence.put(InfixExpression.Operator.DIVIDE, 1);
        precedence.put(InfixExpression.Operator.REMAINDER, 1);
        precedence.put(InfixExpression.Operator.PLUS, 2);
        precedence.put(InfixExpression.Operator.MINUS, 2);
        precedence.put(InfixExpression.Operator.AND, 6);
        precedence.put(InfixExpression.Operator.XOR, 7);
        precedence.put(InfixExpression.Operator.OR, 8);
        precedence.put(InfixExpression.Operator.CONDITIONAL_AND, 9);
        precedence.put(InfixExpression.Operator.CONDITIONAL_OR, 10);
        OPERATOR_PRECEDENCE = Collections.unmodifiableMap(precedence);
    }

    public WrapPreparator(TokenManager tokenManager, DefaultCodeFormatterOptions options, int kind) {
        this.tm = tokenManager;
        this.options = options;
        this.kind = kind;
        this.fieldAligner = new FieldAligner(this.tm);
    }

    @Override
    public boolean preVisit2(ASTNode node) {
        boolean isMalformed;
        ++this.currentDepth;
        boolean bl = isMalformed = (node.getFlags() & 1) != 0;
        if (isMalformed) {
            this.tm.addDisableFormatTokenPair(this.tm.firstTokenIn(node, -1), this.tm.lastTokenIn(node, -1));
        }
        return !isMalformed;
    }

    @Override
    public void postVisit(ASTNode node) {
        --this.currentDepth;
    }

    @Override
    public boolean visit(CompilationUnit node) {
        List imports = node.imports();
        if (!imports.isEmpty()) {
            this.importsStart = this.tm.firstIndexIn((ASTNode)imports.get(0), -1);
            this.importsEnd = this.tm.lastIndexIn((ASTNode)imports.get(imports.size() - 1), -1);
        }
        return true;
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        this.handleArguments(node.values(), this.options.alignment_for_arguments_in_annotation);
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        List superInterfaceTypes;
        Type superclassType = node.getSuperclassType();
        if (superclassType != null) {
            this.wrapParentIndex = this.tm.lastIndexIn(node.getName(), -1);
            this.wrapGroupEnd = this.tm.lastIndexIn(superclassType, -1);
            this.wrapIndexes.add(this.tm.firstIndexBefore(superclassType, 96));
            this.wrapIndexes.add(this.tm.firstIndexIn(superclassType, -1));
            this.handleWrap(this.options.alignment_for_superclass_in_type_declaration, 0.875f);
        }
        if (!(superInterfaceTypes = node.superInterfaceTypes()).isEmpty()) {
            int implementsToken = node.isInterface() ? 96 : 114;
            this.wrapParentIndex = this.tm.lastIndexIn(node.getName(), -1);
            this.wrapGroupEnd = this.tm.lastIndexIn((ASTNode)superInterfaceTypes.get(superInterfaceTypes.size() - 1), -1);
            this.wrapIndexes.add(this.tm.firstIndexBefore((ASTNode)superInterfaceTypes.get(0), implementsToken));
            for (Type type : superInterfaceTypes) {
                this.wrapIndexes.add(this.tm.firstIndexIn(type, -1));
            }
            this.handleWrap(this.options.alignment_for_superinterfaces_in_type_declaration, 0.875f);
        }
        if (this.options.align_type_members_on_columns) {
            this.fieldAligner.prepareAlign(node.bodyDeclarations());
        }
        return true;
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        if (this.options.align_type_members_on_columns) {
            this.fieldAligner.prepareAlign(node.bodyDeclarations());
        }
        return true;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        if (this.options.align_type_members_on_columns) {
            this.fieldAligner.prepareAlign(node.bodyDeclarations());
        }
        return true;
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        List exceptionTypes;
        List parameters = node.parameters();
        Type receiverType = node.getReceiverType();
        if (!parameters.isEmpty() || receiverType != null) {
            if (receiverType != null) {
                this.wrapIndexes.add(this.tm.firstIndexIn(receiverType, -1));
            }
            int wrappingOption = node.isConstructor() ? this.options.alignment_for_parameters_in_constructor_declaration : this.options.alignment_for_parameters_in_method_declaration;
            this.wrapGroupEnd = this.tm.lastIndexIn(parameters.isEmpty() ? receiverType : (ASTNode)parameters.get(parameters.size() - 1), -1);
            this.handleArguments(parameters, wrappingOption);
        }
        if (!(exceptionTypes = node.thrownExceptionTypes()).isEmpty()) {
            this.wrapParentIndex = this.tm.firstIndexBefore((ASTNode)exceptionTypes.get(0), 26);
            this.wrapGroupEnd = this.tm.lastIndexIn((ASTNode)exceptionTypes.get(exceptionTypes.size() - 1), -1);
            int wrappingOption = node.isConstructor() ? this.options.alignment_for_throws_clause_in_constructor_declaration : this.options.alignment_for_throws_clause_in_method_declaration;
            for (Type exceptionType : exceptionTypes) {
                this.wrapIndexes.add(this.tm.firstIndexIn(exceptionType, -1));
            }
            this.wrapIndexes.set(0, this.tm.firstIndexBefore((ASTNode)exceptionTypes.get(0), 112));
            this.handleWrap(wrappingOption, 0.5f);
        }
        if (!node.isConstructor()) {
            List typeParameters = node.typeParameters();
            if (!typeParameters.isEmpty()) {
                this.wrapIndexes.add(this.tm.firstIndexIn((ASTNode)typeParameters.get(0), -1));
            }
            if (node.getReturnType2() != null && !node.modifiers().isEmpty()) {
                this.wrapIndexes.add(this.tm.firstIndexIn(node.getReturnType2(), -1));
            }
            this.wrapIndexes.add(this.tm.firstIndexIn(node.getName(), -1));
            this.wrapParentIndex = this.tm.findFirstTokenInLine(this.tm.firstIndexIn(node.getName(), -1));
            this.wrapGroupEnd = this.tm.lastIndexIn(node.getName(), -1);
            this.handleWrap(this.options.alignment_for_method_declaration);
        }
        return true;
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        List superInterfaceTypes;
        List enumConstants = node.enumConstants();
        if (!enumConstants.isEmpty()) {
            for (EnumConstantDeclaration constant : enumConstants) {
                this.wrapIndexes.add(this.tm.firstIndexIn(constant, -1));
            }
            this.wrapParentIndex = this.tm.firstIndexBefore((ASTNode)enumConstants.get(0), 49);
            this.wrapGroupEnd = this.tm.lastIndexIn((ASTNode)enumConstants.get(enumConstants.size() - 1), -1);
            this.handleWrap(this.options.alignment_for_enum_constants, node);
        }
        if (!(superInterfaceTypes = node.superInterfaceTypes()).isEmpty()) {
            this.wrapIndexes.add(this.tm.firstIndexBefore((ASTNode)superInterfaceTypes.get(0), 114));
            for (Type type : superInterfaceTypes) {
                this.wrapIndexes.add(this.tm.firstIndexIn(type, -1));
            }
            this.wrapParentIndex = this.tm.lastIndexIn(node.getName(), -1);
            this.wrapGroupEnd = this.tm.lastIndexIn((ASTNode)superInterfaceTypes.get(superInterfaceTypes.size() - 1), -1);
            this.wrapPenalties.add(Float.valueOf(0.875f));
            this.handleWrap(this.options.alignment_for_superinterfaces_in_enum_declaration, node);
        }
        if (this.options.align_type_members_on_columns) {
            this.fieldAligner.prepareAlign(node.bodyDeclarations());
        }
        return true;
    }

    @Override
    public boolean visit(EnumConstantDeclaration node) {
        this.handleArguments(node.arguments(), this.options.alignment_for_arguments_in_enum_constant);
        AnonymousClassDeclaration anonymousClass = node.getAnonymousClassDeclaration();
        if (anonymousClass != null) {
            this.forceContinuousWrapping(anonymousClass, this.tm.firstIndexIn(node.getName(), -1));
        }
        return true;
    }

    @Override
    public boolean visit(MethodInvocation node) {
        boolean isInvocationChainRoot;
        this.handleArguments(node.arguments(), this.options.alignment_for_arguments_in_method_invocation);
        boolean bl = isInvocationChainRoot = !(node.getParent() instanceof MethodInvocation) || node.getLocationInParent() != MethodInvocation.EXPRESSION_PROPERTY;
        if (isInvocationChainRoot) {
            Expression expression = node;
            MethodInvocation invocation = node;
            while (expression instanceof MethodInvocation) {
                invocation = expression;
                if ((expression = invocation.getExpression()) == null) continue;
                this.wrapIndexes.add(this.tm.firstIndexBefore(invocation.getName(), 3));
            }
            Collections.reverse(this.wrapIndexes);
            this.wrapParentIndex = expression != null ? this.tm.lastIndexIn(expression, -1) : this.tm.lastIndexIn(invocation, -1);
            this.wrapGroupEnd = this.tm.firstIndexIn(node.getName(), -1);
            this.handleWrap(this.options.alignment_for_selector_in_method_invocation);
        }
        return true;
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        this.handleArguments(node.arguments(), this.options.alignment_for_arguments_in_method_invocation);
        return true;
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        AnonymousClassDeclaration anonymousClass = node.getAnonymousClassDeclaration();
        if (anonymousClass != null) {
            this.forceContinuousWrapping(anonymousClass, this.tm.firstIndexIn(node, 36));
        }
        int wrappingOption = node.getExpression() != null ? this.options.alignment_for_arguments_in_qualified_allocation_expression : this.options.alignment_for_arguments_in_allocation_expression;
        this.handleArguments(node.arguments(), wrappingOption);
        return true;
    }

    @Override
    public boolean visit(ConstructorInvocation node) {
        this.handleArguments(node.arguments(), this.options.alignment_for_arguments_in_explicit_constructor_call);
        return true;
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        this.handleArguments(node.arguments(), this.options.alignment_for_arguments_in_explicit_constructor_call);
        return true;
    }

    @Override
    public boolean visit(InfixExpression node) {
        Integer operatorPrecedence = OPERATOR_PRECEDENCE.get(node.getOperator());
        if (operatorPrecedence == null) {
            return true;
        }
        ASTNode parent = node.getParent();
        if (parent instanceof InfixExpression && this.samePrecedence(node, (InfixExpression)parent)) {
            return true;
        }
        this.findTokensToWrap(node, 0);
        this.wrapParentIndex = this.wrapIndexes.remove(0);
        this.wrapGroupEnd = this.tm.lastIndexIn(node, -1);
        if ((this.options.alignment_for_binary_expression & 2) != 0 && this.wrapParentIndex > 0) {
            --this.wrapParentIndex;
        }
        int i = this.wrapParentIndex;
        while (i >= 0) {
            if (!this.tm.get(i).isComment()) {
                this.wrapParentIndex = i;
                break;
            }
            --i;
        }
        this.handleWrap(this.options.alignment_for_binary_expression, node);
        return true;
    }

    private void findTokensToWrap(InfixExpression node, int depth) {
        Expression left = node.getLeftOperand();
        if (left instanceof InfixExpression && this.samePrecedence(node, (InfixExpression)left)) {
            this.findTokensToWrap((InfixExpression)left, depth + 1);
        } else if (this.wrapIndexes.isEmpty() || !this.options.wrap_before_binary_operator) {
            this.wrapIndexes.add(this.tm.firstIndexIn(left, -1));
        }
        Expression right = node.getRightOperand();
        List extended = node.extendedOperands();
        int i = -1;
        while (i < extended.size()) {
            Expression operand;
            Expression expression = operand = i == -1 ? right : (Expression)extended.get(i);
            if (operand instanceof InfixExpression && this.samePrecedence(node, (InfixExpression)operand)) {
                this.findTokensToWrap((InfixExpression)operand, depth + 1);
            }
            int indexBefore = this.tm.firstIndexBefore(operand, -1);
            while (this.tm.get(indexBefore).isComment()) {
                --indexBefore;
            }
            assert (node.getOperator().toString().equals(this.tm.toString(indexBefore)));
            int indexAfter = this.tm.firstIndexIn(operand, -1);
            this.wrapIndexes.add(this.options.wrap_before_binary_operator ? indexBefore : indexAfter);
            if (!this.options.join_wrapped_lines) {
                if (this.options.wrap_before_binary_operator) {
                    if (this.tm.countLineBreaksBetween(this.tm.get(indexAfter - 1), this.tm.get(indexAfter)) > 0) {
                        this.wrapIndexes.add(indexAfter);
                    }
                } else if (this.tm.countLineBreaksBetween(this.tm.get(indexBefore), this.tm.get(indexBefore - 1)) > 0) {
                    this.wrapIndexes.add(indexBefore);
                }
            }
            ++i;
        }
    }

    private boolean samePrecedence(InfixExpression expression1, InfixExpression expression2) {
        Integer precedence1 = OPERATOR_PRECEDENCE.get(expression1.getOperator());
        Integer precedence2 = OPERATOR_PRECEDENCE.get(expression2.getOperator());
        if (precedence1 == null || precedence2 == null) {
            return false;
        }
        return precedence1.equals(precedence2);
    }

    @Override
    public boolean visit(ConditionalExpression node) {
        this.wrapIndexes.add(this.tm.firstIndexAfter(node.getExpression(), 29));
        this.wrapIndexes.add(this.tm.firstIndexAfter(node.getThenExpression(), 61));
        this.wrapParentIndex = this.tm.lastIndexIn(node.getExpression(), -1);
        this.wrapGroupEnd = this.tm.lastIndexIn(node, -1);
        this.handleWrap(this.options.alignment_for_conditional_expression);
        return true;
    }

    @Override
    public boolean visit(ArrayInitializer node) {
        List expressions = node.expressions();
        if (!expressions.isEmpty()) {
            for (Expression expression : expressions) {
                this.wrapIndexes.add(this.tm.firstIndexIn(expression, -1));
            }
            this.wrapParentIndex = this.tm.firstIndexBefore((ASTNode)expressions.get(0), 49);
            this.wrapGroupEnd = this.tm.lastIndexIn(node, -1);
            this.handleWrap(this.options.alignment_for_expressions_in_array_initializer, node);
        }
        if (!this.options.join_wrapped_lines && !this.options.insert_new_line_before_closing_brace_in_array_initializer) {
            int closingBraceIndex = this.tm.lastIndexIn(node, 32);
            Token closingBrace = this.tm.get(closingBraceIndex);
            if (this.tm.countLineBreaksBetween(this.tm.get(closingBraceIndex - 1), closingBrace) == 1) {
                int openingBraceIndex = this.tm.firstIndexIn(node, 49);
                closingBrace.setWrapPolicy(new Token.WrapPolicy(0, openingBraceIndex, this.currentDepth, 1.0f, true, false, -1, false));
            }
        }
        return true;
    }

    @Override
    public boolean visit(Assignment node) {
        this.wrapIndexes.add(this.tm.firstIndexIn(node.getRightHandSide(), -1));
        int operatorIndex = this.tm.firstIndexBefore(node.getRightHandSide(), -1);
        while (this.tm.get(operatorIndex).isComment()) {
            --operatorIndex;
        }
        assert (node.getOperator().toString().equals(this.tm.toString(operatorIndex)));
        this.wrapParentIndex = operatorIndex;
        this.wrapGroupEnd = this.tm.lastIndexIn(node.getRightHandSide(), -1);
        this.handleWrap(this.options.alignment_for_assignment);
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        if (node.getInitializer() != null) {
            this.wrapIndexes.add(this.tm.firstIndexIn(node.getInitializer(), -1));
            this.wrapParentIndex = this.tm.firstIndexBefore(node.getInitializer(), 70);
            this.wrapGroupEnd = this.tm.lastIndexIn(node.getInitializer(), -1);
            this.handleWrap(this.options.alignment_for_assignment);
        }
        return true;
    }

    @Override
    public boolean visit(IfStatement node) {
        int elseIndex;
        Statement elseStatement;
        int thenIndex;
        if (!(node.getThenStatement() instanceof Block) && this.tm.get(thenIndex = this.tm.firstIndexIn(node.getThenStatement(), -1)).getLineBreaksBefore() == 0) {
            this.wrapIndexes.add(thenIndex);
        }
        if ((elseStatement = node.getElseStatement()) != null && !(elseStatement instanceof Block) && !(elseStatement instanceof IfStatement) && this.tm.get(elseIndex = this.tm.firstIndexIn(elseStatement, -1)).getLineBreaksBefore() == 0) {
            this.wrapIndexes.add(elseIndex);
        }
        if (!this.wrapIndexes.isEmpty()) {
            this.wrapParentIndex = this.tm.firstIndexAfter(node.getExpression(), 26);
            this.wrapGroupEnd = this.tm.lastIndexIn(node, -1);
            this.handleWrap(this.options.alignment_for_compact_if, node);
        }
        return true;
    }

    @Override
    public boolean visit(TryStatement node) {
        this.handleArguments(node.resources(), this.options.alignment_for_resources_in_try);
        return true;
    }

    @Override
    public boolean visit(UnionType node) {
        List types = node.types();
        if (this.options.wrap_before_or_operator_multicatch && !types.isEmpty()) {
            for (Type type : types) {
                if (this.wrapIndexes.isEmpty()) {
                    this.wrapIndexes.add(this.tm.firstIndexIn(type, -1));
                    continue;
                }
                this.wrapIndexes.add(this.tm.firstIndexBefore(type, 25));
            }
            this.wrapParentIndex = this.tm.firstIndexBefore(node, 24);
            this.wrapGroupEnd = this.tm.lastIndexIn((ASTNode)types.get(types.size() - 1), -1);
            this.handleWrap(this.options.alignment_for_union_type_in_multicatch);
        } else {
            this.handleArguments(types, this.options.alignment_for_union_type_in_multicatch);
        }
        return true;
    }

    @Override
    public boolean visit(LambdaExpression node) {
        if (node.getBody() instanceof Block) {
            this.forceContinuousWrapping(node.getBody(), this.tm.firstIndexIn(node, -1));
        }
        if (node.hasParentheses()) {
            List parameters = node.parameters();
            ++this.currentDepth;
            this.handleArguments(parameters, this.options.alignment_for_parameters_in_method_declaration);
            --this.currentDepth;
        }
        return true;
    }

    @Override
    public boolean visit(FieldDeclaration node) {
        this.handleVariableDeclarations(node.fragments());
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        this.handleVariableDeclarations(node.fragments());
        return true;
    }

    private void forceContinuousWrapping(ASTNode node, int parentIndex) {
        int from = this.tm.firstIndexIn(node, -1);
        int to = this.tm.lastIndexIn(node, -1);
        Token wrapParent = this.tm.get(parentIndex);
        Token previous = null;
        int i = from;
        while (i <= to) {
            Token token = this.tm.get(i);
            if ((token.getLineBreaksBefore() > 0 || previous != null && previous.getLineBreaksAfter() > 0) && token.getWrapPolicy() == null) {
                int indent = token.getIndent() - wrapParent.getIndent();
                token.setWrapPolicy(new Token.WrapPolicy(indent, parentIndex, true));
            }
            previous = token;
            ++i;
        }
    }

    private void handleVariableDeclarations(List<VariableDeclarationFragment> fragments) {
        if (fragments.size() > 1) {
            int i = 1;
            while (i < fragments.size()) {
                this.wrapIndexes.add(this.tm.firstIndexIn(fragments.get(i), -1));
                ++i;
            }
            this.wrapParentIndex = this.tm.firstIndexIn(fragments.get(0), -1);
            this.wrapGroupEnd = this.tm.lastIndexIn(fragments.get(fragments.size() - 1), -1);
            this.handleWrap(this.options.alignment_for_multiple_fields);
        }
    }

    private void handleArguments(List<? extends ASTNode> arguments, int wrappingOption) {
        for (ASTNode aSTNode : arguments) {
            this.wrapIndexes.add(this.tm.firstIndexIn(aSTNode, -1));
        }
        if (!this.wrapIndexes.isEmpty()) {
            Token token = this.tm.get(this.wrapIndexes.get(0));
            this.wrapParentIndex = this.tm.findIndex(token.originalStart - 1, 24, false);
            if (!arguments.isEmpty() && this.wrapGroupEnd < 0) {
                this.wrapGroupEnd = this.tm.lastIndexIn(arguments.get(arguments.size() - 1), -1);
            }
            assert (this.wrapGroupEnd >= 0);
            this.handleWrap(wrappingOption, 1.1428572f);
        }
    }

    private void handleWrap(int wrappingOption) {
        this.handleWrap(wrappingOption, null);
    }

    private void handleWrap(int wrappingOption, float firstPenaltyMultiplier) {
        this.wrapPenalties.add(Float.valueOf(firstPenaltyMultiplier));
        this.handleWrap(wrappingOption, null);
    }

    private void handleWrap(int wrappingOption, ASTNode parentNode) {
        boolean forceWrap;
        if (this.wrapIndexes.isEmpty()) {
            return;
        }
        assert (this.wrapParentIndex >= 0);
        float penalty = this.wrapPenalties.isEmpty() ? 1.0f : this.wrapPenalties.get(0).floatValue();
        Token.WrapPolicy policy = this.getWrapPolicy(wrappingOption, penalty, true, parentNode);
        if (policy == null) {
            this.wrapIndexes.clear();
            this.wrapPenalties.clear();
            this.wrapGroupEnd = -1;
            this.wrapParentIndex = -1;
            return;
        }
        this.setTokenWrapPolicy(this.wrapIndexes.get(0), policy, true);
        boolean wrapPreceedingComments = !(parentNode instanceof InfixExpression) || !this.options.wrap_before_binary_operator;
        int i = 1;
        while (i < this.wrapIndexes.size()) {
            float f = penalty = this.wrapPenalties.size() > i ? this.wrapPenalties.get(i).floatValue() : 1.0f;
            if (penalty != policy.penaltyMultiplier || i == 1) {
                policy = this.getWrapPolicy(wrappingOption, penalty, false, parentNode);
            }
            this.setTokenWrapPolicy(this.wrapIndexes.get(i), policy, wrapPreceedingComments);
            ++i;
        }
        boolean bl = forceWrap = (wrappingOption & 1) != 0;
        if (forceWrap) {
            boolean satisfied = false;
            for (int index : this.wrapIndexes) {
                Token token = this.tm.get(index);
                if (!token.getWrapPolicy().isTopPriority()) continue;
                token.breakBefore();
                satisfied = true;
            }
            if (!satisfied) {
                boolean canWrapFirst;
                boolean bl2 = canWrapFirst = (wrappingOption & 0x50) != 80;
                if (canWrapFirst) {
                    this.tm.get(this.wrapIndexes.get(0)).breakBefore();
                }
            }
        }
        this.wrapIndexes.clear();
        this.wrapPenalties.clear();
        this.wrapGroupEnd = -1;
        this.wrapParentIndex = -1;
    }

    private void setTokenWrapPolicy(int index, Token.WrapPolicy policy, boolean wrapPreceedingComments) {
        if (wrapPreceedingComments) {
            int i = index - 1;
            while (i >= 0) {
                Token previous = this.tm.get(i);
                if (!previous.isComment()) break;
                if (previous.getLineBreaksAfter() == 0 && i == index - 1) {
                    index = i;
                }
                if (previous.getLineBreaksBefore() > 0) {
                    previous.setWrapPolicy(policy);
                }
                --i;
            }
        }
        Token token = this.tm.get(index);
        token.setWrapPolicy(policy);
        if (this.options.join_wrapped_lines && (token.tokenType == 1002 || token.tokenType == 1003)) {
            token.clearLineBreaksBefore();
        }
        int i = index + 1;
        while (i < this.tm.size()) {
            Token next = this.tm.get(i);
            Token.WrapPolicy policy2 = next.getWrapPolicy();
            if (policy2 != null && policy2.isForced && policy2.extraIndent == 0) {
                next.setWrapPolicy(policy);
            } else if (next.tokenType != 1001 && next.tokenType != 1002) break;
            ++i;
        }
    }

    private Token.WrapPolicy getWrapPolicy(int wrappingOption, float penaltyMultiplier, boolean isFirst, ASTNode parentNode) {
        assert (this.wrapParentIndex >= 0 && this.wrapGroupEnd >= 0);
        int extraIndent = this.options.continuation_indentation;
        boolean indentOnColumn = (wrappingOption & 2) != 0;
        boolean isAlreadyWrapped = false;
        if (indentOnColumn) {
            extraIndent = 0;
        } else if (parentNode instanceof EnumDeclaration) {
            extraIndent = (wrappingOption & 4) != 0 ? 2 : 1;
            isAlreadyWrapped = isFirst;
        } else if (parentNode instanceof IfStatement) {
            extraIndent = 1;
            this.wrapParentIndex = this.tm.firstIndexIn(parentNode, -1);
        } else if ((wrappingOption & 4) != 0) {
            extraIndent = 1;
        } else if (parentNode instanceof ArrayInitializer) {
            extraIndent = this.options.continuation_indentation_for_array_initializer;
        }
        boolean isTopPriority = false;
        switch (wrappingOption & 0x70) {
            case 0: {
                return null;
            }
            case 32: {
                isTopPriority = isFirst;
                break;
            }
            case 48: {
                isTopPriority = true;
                break;
            }
            case 64: {
                isTopPriority = true;
                if (isFirst) break;
                ++extraIndent;
                break;
            }
            case 80: {
                boolean bl = isTopPriority = !isFirst;
            }
        }
        if (isAlreadyWrapped) {
            isTopPriority = false;
        }
        int topPriorityGroupEnd = isTopPriority ? this.wrapGroupEnd : -1;
        return new Token.WrapPolicy(extraIndent *= this.options.indentation_size, this.wrapParentIndex, this.currentDepth, penaltyMultiplier, isFirst, indentOnColumn, topPriorityGroupEnd, false);
    }

    public void finishUp(ASTNode astRoot) {
        this.preserveExistingLineBreaks();
        new WrapExecutor(this.tm, this.options).executeWraps();
        this.fieldAligner.alignComments();
        this.wrapComments();
        this.fixEnumConstantIndents(astRoot);
    }

    private void preserveExistingLineBreaks() {
        Token first = this.tm.get(0);
        int startingBreaks = first.getLineBreaksBefore();
        first.clearLineBreaksBefore();
        first.putLineBreaksBefore(startingBreaks - 1);
        this.tm.traverse(0, new TokenTraverser(){
            DefaultCodeFormatterOptions options2;
            {
                this.options2 = WrapPreparator.this.options;
            }

            @Override
            protected boolean token(Token token, int index) {
                int lineBreaks = this.getLineBreaksBetween(this.getPrevious(), token);
                lineBreaks = index > WrapPreparator.this.importsStart && index < WrapPreparator.this.importsEnd ? (lineBreaks > 1 ? this.options2.blank_lines_between_import_groups + 1 : 0) : Math.min(lineBreaks, this.options2.number_of_empty_lines_to_preserve + 1);
                if (lineBreaks <= this.getLineBreaksBefore()) {
                    return true;
                }
                if (!this.options2.join_wrapped_lines && token.isWrappable() && lineBreaks == 1) {
                    token.breakBefore();
                } else if (lineBreaks > 1) {
                    if (index == 0) {
                        --lineBreaks;
                    }
                    token.putLineBreaksBefore(lineBreaks);
                }
                return true;
            }

            private int getLineBreaksBetween(Token token1, Token token2) {
                List<Token> structure2;
                List<Token> structure1;
                if (token1 != null && (structure1 = token1.getInternalStructure()) != null && !structure1.isEmpty()) {
                    token1 = structure1.get(structure1.size() - 1);
                }
                if ((structure2 = token2.getInternalStructure()) != null && !structure2.isEmpty()) {
                    token2 = structure2.get(0);
                }
                int lineBreaks = WrapPreparator.this.tm.countLineBreaksBetween(token1, token2);
                if (token1 == null) {
                    ++lineBreaks;
                }
                return lineBreaks;
            }
        });
        Token last = this.tm.get(this.tm.size() - 1);
        last.clearLineBreaksAfter();
        int endingBreaks = this.tm.countLineBreaksBetween(last, null);
        endingBreaks = Math.min(endingBreaks, this.options.number_of_empty_lines_to_preserve);
        if (endingBreaks > 0) {
            last.putLineBreaksAfter(endingBreaks);
        } else if ((this.kind & 8) != 0 && this.options.insert_new_line_at_end_of_file_if_missing) {
            last.breakAfter();
        }
    }

    private void wrapComments() {
        CommentWrapExecutor commentWrapper = new CommentWrapExecutor(this.tm, this.options);
        boolean isNLSTagInLine = false;
        int i = 0;
        while (i < this.tm.size()) {
            List<Token> structure;
            Token token = this.tm.get(i);
            if (token.getLineBreaksBefore() > 0 || token.getLineBreaksAfter() > 0) {
                isNLSTagInLine = false;
            }
            if (token.hasNLSTag()) {
                assert (token.tokenType == 48);
                isNLSTagInLine = true;
            }
            if ((structure = token.getInternalStructure()) != null && !structure.isEmpty() && !isNLSTagInLine) {
                int startPosition = this.tm.getPositionInLine(i);
                if (token.tokenType == 1001) {
                    commentWrapper.wrapLineComment(token, startPosition);
                } else {
                    assert (token.tokenType == 1002 || token.tokenType == 1003);
                    commentWrapper.wrapMultiLineComment(token, startPosition, false, false);
                }
            }
            ++i;
        }
    }

    private void fixEnumConstantIndents(ASTNode astRoot) {
        if (this.options.use_tabs_only_for_leading_indentations) {
            astRoot.accept(new ASTVisitor(){

                @Override
                public boolean visit(EnumConstantDeclaration node) {
                    WrapPreparator.this.tm.firstTokenIn(node, 22).setWrapPolicy(null);
                    return true;
                }
            });
        }
    }
}

