/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.customizer;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.equinox.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.equinox.http.servlet.internal.registration.ResourceRegistration;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;

public class ContextResourceTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Object, AtomicReference<ResourceRegistration>> {
    private ContextController contextController;

    public ContextResourceTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime);
        this.contextController = contextController;
    }

    public AtomicReference<ResourceRegistration> addingService(ServiceReference<Object> serviceReference) {
        AtomicReference<ResourceRegistration> result = new AtomicReference<ResourceRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        if (!this.contextController.matches(serviceReference)) {
            return result;
        }
        try {
            result.set(this.contextController.addResourceRegistration(serviceReference));
        }
        catch (HttpWhiteboardFailureException hwfe) {
            this.httpServiceRuntime.log(hwfe.getMessage(), hwfe);
            this.recordFailedResourceDTO(serviceReference, hwfe.getFailureReason());
        }
        catch (Exception e) {
            this.httpServiceRuntime.log(e.getMessage(), e);
            this.recordFailedResourceDTO(serviceReference, 4);
        }
        return result;
    }

    public void modifiedService(ServiceReference<Object> serviceReference, AtomicReference<ResourceRegistration> resourceReference) {
        this.removedService(serviceReference, resourceReference);
        Object added = this.addingService((ServiceReference)serviceReference);
        resourceReference.set((ResourceRegistration)((AtomicReference)added).get());
    }

    public void removedService(ServiceReference<Object> serviceReference, AtomicReference<ResourceRegistration> resourceReference) {
        ResourceRegistration registration = resourceReference.get();
        if (registration != null) {
            registration.destroy();
        }
        this.contextController.getHttpServiceRuntime().removeFailedResourceDTO(serviceReference);
    }

    private void recordFailedResourceDTO(ServiceReference<Object> serviceReference, int failureReason) {
        FailedResourceDTO failedResourceDTO = new FailedResourceDTO();
        failedResourceDTO.failureReason = failureReason;
        failedResourceDTO.patterns = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.resource.pattern")).toArray(new String[0]);
        failedResourceDTO.prefix = (String)serviceReference.getProperty("osgi.http.whiteboard.resource.prefix");
        failedResourceDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        failedResourceDTO.servletContextId = this.contextController.getServiceId();
        this.contextController.getHttpServiceRuntime().recordFailedResourceDTO(serviceReference, failedResourceDTO);
    }
}

