/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.internal;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;
import org.eclipse.fx.text.hover.HtmlString;
import org.eclipse.fx.text.hover.LinkActionEvent;
import org.w3c.dom.Document;
import org.w3c.dom.html.HTMLDocument;

public class SimpleHtmlViewer
extends BorderPane {
    private ObjectProperty<HtmlString> content = new SimpleObjectProperty((Object)this, "content");
    private WebView webView;
    private WebEngine webEngine;
    private static String STYLE_INLINE = "<style>body{display: inline;}</style>";
    private static String STYLE_NO_PADDING = "<style>body{padding: 0px}</style>";
    private boolean inline;
    private WorkerStateChangeListener workerStateChangeListener = new WorkerStateChangeListener();

    public ObjectProperty<HtmlString> contentProperty() {
        return this.content;
    }

    public HtmlString getContent() {
        return (HtmlString)this.content.get();
    }

    public void setContent(HtmlString content) {
        this.content.set((Object)content);
    }

    protected double computePrefWidth(double height) {
        if (this.inline && this.webEngine.getDocument() != null) {
            Integer width = (Integer)this.webEngine.executeScript("document.body.offsetWidth");
            System.err.println("computePrefWidth -> " + width);
            return width + 4;
        }
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        if (this.inline && this.webEngine.getDocument() != null) {
            Integer height = (Integer)this.webEngine.executeScript("document.body.offsetHeight");
            System.err.println("computePrefHeight -> " + height);
            return height + 4;
        }
        return super.computePrefHeight(width);
    }

    private Region findFirstParentWithBackground(Node n) {
        System.err.println("CHECKING " + n);
        if (n == null) {
            return null;
        }
        if (n instanceof Region && ((Region)n).getBackground() != null) {
            System.err.println("found parent: " + n);
            System.err.println(" -> " + ((BackgroundFill)((Region)n).getBackground().getFills().get(0)).getFill());
            return (Region)n;
        }
        return this.findFirstParentWithBackground((Node)n.getParent());
    }

    public SimpleHtmlViewer() {
        this(false, false);
    }

    public SimpleHtmlViewer(boolean noPaddingInBody, boolean inline) {
        this.inline = inline;
        this.webView = new WebView();
        this.webEngine = this.webView.getEngine();
        this.webView.setContextMenuEnabled(false);
        this.setCenter((Node)this.webView);
        BiConsumer<Document, Color> applyBackground = (doc, col) -> {
            if (doc == null || col == null) {
                return;
            }
            String style = "background: rgb(" + Math.round(col.getRed() * 255.0) + ", " + Math.round(col.getGreen() * 255.0) + ", " + Math.round(col.getBlue() * 255.0) + ");";
            ((HTMLDocument)doc).getBody().setAttribute("style", style);
        };
        Consumer<Document> updateSizes = doc -> {
            if (inline) {
                Integer width = (Integer)this.webEngine.executeScript("document.body.offsetWidth");
                Integer height = (Integer)this.webEngine.executeScript("document.body.offsetHeight");
                if (width != null) {
                    this.setPrefWidth(width + 20);
                }
                if (height != null) {
                    this.setPrefHeight(height + 4);
                }
            }
        };
        AtomicReference curCol = new AtomicReference();
        this.webEngine.documentProperty().addListener((x, o, n) -> {
            applyBackground.accept((Document)n, (Color)curCol.get());
            updateSizes.accept((Document)n);
        });
        ChangeListener backgroundListener = (x1, o1, background) -> {
            if (background == null) {
                return;
            }
            if (background.getFills().size() > 0 && ((BackgroundFill)background.getFills().get(0)).getFill() instanceof Color) {
                Color c = (Color)((BackgroundFill)background.getFills().get(0)).getFill();
                curCol.set(c);
                applyBackground.accept(this.webEngine.getDocument(), c);
            }
        };
        ChangeListener parentListener = (x, o, n) -> {
            if (o instanceof Region) {
                ((Region)o).backgroundProperty().removeListener(backgroundListener);
            }
            if (n instanceof Region) {
                ((Region)n).backgroundProperty().addListener(backgroundListener);
            }
        };
        this.parentProperty().addListener(parentListener);
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)this.workerStateChangeListener);
        this.contentProperty().addListener((x, o, n) -> {
            if (n != null) {
                this.webEngine.loadContent("<html>" + (noPaddingInBody ? STYLE_NO_PADDING : "") + (inline ? STYLE_INLINE : "") + "<body>" + n.toString() + "</body></html>");
            } else {
                this.webEngine.load("about:blank");
            }
        });
        this.sceneProperty().addListener((x, o, n) -> {
            if (o != null) {
                o.getWindow().setOnHidden(null);
                o.getWindow().setOnShown(null);
            }
            if (n != null) {
                n.getWindow().setOnShown(e -> {
                    JSObject window = (JSObject)this.webEngine.executeScript("window");
                    window.setMember("java", new WebBridge(this.getContent()));
                });
                n.getWindow().setOnHidden(e -> {
                    JSObject window = (JSObject)this.webEngine.executeScript("window");
                    window.removeMember("java");
                });
            }
        });
    }

    public static class WebBridge {
        private HtmlString html;

        public WebBridge(HtmlString html) {
            this.html = html;
        }

        public void onLinkAction(String target, long screenX, long screenY) {
            this.html.fireEvent((Event)new LinkActionEvent(LinkActionEvent.LINK_ACTION, target, (double)screenX, (double)screenY));
        }

        public void onLinkContext(String target, long screenX, long screenY) {
            this.html.fireEvent((Event)new LinkActionEvent(LinkActionEvent.LINK_CONTEXT, target, (double)screenX, (double)screenY));
        }
    }

    private class WorkerStateChangeListener
    implements ChangeListener<Worker.State> {
        private WorkerStateChangeListener() {
        }

        public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
            if (newValue == Worker.State.SUCCEEDED) {
                JSObject window = (JSObject)SimpleHtmlViewer.this.webEngine.executeScript("window");
                window.setMember("java", new WebBridge(SimpleHtmlViewer.this.getContent()));
                SimpleHtmlViewer.this.webEngine.executeScript("var callback = function(e) {\tif (e.button == 0) {\t\tjava.onLinkAction(e.target.href, e.screenX, e.screenY);\t}\telse if (e.button == 2) {\t\tjava.onLinkContext(e.target.href, e.screenX, e.screenY);\t}};var allAnchors = document.getElementsByTagName('a');for (var i = 0; i < allAnchors.length; i++) {\tallAnchors[i].onmousedown = callback;}");
            }
        }
    }
}

