/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWEPlugin
extends EMFPlugin {
    public static final MWEPlugin INSTANCE = new MWEPlugin();
    public static final String ID = "org.eclipse.emf.mwe.core";
    private static Implementation plugin;

    private MWEPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static URI asLocalURI(URI uri) {
        return plugin == null ? uri : Implementation.asLocalURI(uri);
    }

    public static URI resolve(URI uri) {
        return plugin == null ? uri : Implementation.resolve(uri);
    }

    public static Class<?> loadClass(String pluginID, String className) throws ClassNotFoundException {
        return plugin == null ? Class.forName(className) : Implementation.loadClass(pluginID, className);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        protected static URI asLocalURI(URI uri) {
            try {
                String fragment = uri.fragment();
                URL url = FileLocator.toFileURL((URL)new URL(uri.trimFragment().toString()));
                return Implementation.fix(url, fragment);
            }
            catch (IOException iOException) {
                return uri;
            }
        }

        protected static URI resolve(URI uri) {
            String fragment = uri.fragment();
            URI uriWithoutFragment = uri.trimFragment();
            String uriWithoutFragmentToString = uriWithoutFragment.toString();
            URL url = null;
            try {
                url = FileLocator.resolve((URL)new URL(uriWithoutFragmentToString));
            }
            catch (IOException exception1) {
                try {
                    uriWithoutFragmentToString = URI.decode((String)uriWithoutFragmentToString);
                    url = FileLocator.resolve((URL)new URL(uriWithoutFragmentToString));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (url != null) {
                return Implementation.fix(url, fragment);
            }
            return uri;
        }

        protected static URI fix(URL url, String fragment) {
            URI result;
            URI uRI = result = "file".equalsIgnoreCase(url.getProtocol()) ? URI.createFileURI((String)URI.decode((String)url.getFile())) : URI.createURI((String)url.toString());
            if (fragment != null) {
                result = result.appendFragment(fragment);
            }
            return result;
        }

        public static Class<?> loadClass(String pluginID, String className) throws ClassNotFoundException {
            return Platform.getBundle((String)pluginID).loadClass(className);
        }
    }
}

