/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.filebuffers.AbstractFileBuffer;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class FileStoreFileBuffer
extends AbstractFileBuffer {
    protected IPath fLocation;
    protected int fReferenceCount;
    protected boolean fCanBeSaved = false;
    protected IStatus fStatus;
    protected long fSynchronizationStamp = -1L;
    protected int fSynchronizationContextCount;

    public FileStoreFileBuffer(TextFileBufferManager manager) {
        super(manager);
    }

    protected abstract void addFileBufferContentListeners();

    protected abstract void removeFileBufferContentListeners();

    protected abstract void initializeFileBufferContent(IProgressMonitor var1) throws CoreException;

    protected abstract void commitFileBufferContent(IProgressMonitor var1, boolean var2) throws CoreException;

    public void create(IFileStore fileStore, IProgressMonitor monitor) throws CoreException {
        IFileInfo info = fileStore.fetchInfo();
        this.fFileStore = fileStore;
        if (this.fLocation == null) {
            this.fLocation = URIUtil.toPath((URI)fileStore.toURI());
        }
        this.initializeFileBufferContent(monitor);
        if (info.exists()) {
            this.fSynchronizationStamp = info.getLastModified();
        }
        this.addFileBufferContentListeners();
    }

    @Override
    public void create(IPath location, IProgressMonitor monitor) throws CoreException {
        this.fLocation = location;
        this.create(EFS.getStore((URI)URIUtil.toURI((IPath)this.getLocation())), monitor);
    }

    @Override
    public void connect() {
        ++this.fReferenceCount;
        if (this.fReferenceCount == 1) {
            this.connected();
        }
    }

    protected void connected() {
    }

    @Override
    public void disconnect() throws CoreException {
        --this.fReferenceCount;
        if (this.fReferenceCount <= 0) {
            this.disconnected();
        }
    }

    protected void disconnected() {
    }

    @Override
    protected boolean isDisconnected() {
        return this.fReferenceCount <= 0;
    }

    @Override
    public IPath getLocation() {
        return this.fLocation;
    }

    @Override
    public void commit(IProgressMonitor monitor, boolean overwrite) throws CoreException {
        if (!this.isDisconnected() && this.fCanBeSaved) {
            this.fManager.fireStateChanging(this);
            try {
                this.commitFileBufferContent(monitor, overwrite);
            }
            catch (CoreException x) {
                this.fManager.fireStateChangeFailed(this);
                throw x;
            }
            catch (RuntimeException x) {
                this.fManager.fireStateChangeFailed(this);
                throw x;
            }
            this.fCanBeSaved = false;
            this.addFileBufferContentListeners();
            this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
        }
    }

    @Override
    public ISchedulingRule computeCommitRule() {
        return null;
    }

    @Override
    public boolean isDirty() {
        return this.fCanBeSaved;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.fCanBeSaved = isDirty;
    }

    @Override
    public boolean isShared() {
        return this.fReferenceCount > 1;
    }

    @Override
    public ISchedulingRule computeValidateStateRule() {
        return null;
    }

    @Override
    public void validateState(IProgressMonitor monitor, Object computationContext) throws CoreException {
    }

    @Override
    public boolean isStateValidated() {
        return true;
    }

    @Override
    public void resetStateValidation() {
    }

    @Override
    public boolean isSynchronized() {
        return this.fSynchronizationStamp == this.getModificationStamp();
    }

    @Override
    public void requestSynchronizationContext() {
        ++this.fSynchronizationContextCount;
    }

    @Override
    public void releaseSynchronizationContext() {
        --this.fSynchronizationContextCount;
    }

    @Override
    public boolean isSynchronizationContextRequested() {
        return this.fSynchronizationContextCount > 0;
    }

    @Override
    public boolean isCommitable() {
        IFileInfo info = this.fFileStore.fetchInfo();
        return info.exists() && !info.getAttribute(2);
    }

    @Override
    public void validationStateChanged(boolean validationState, IStatus status) {
    }
}

