/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding.edit.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.databinding.internal.EMFResourceContentProperty;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.ReplaceCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EMFEditResourceContentProperty
extends EMFResourceContentProperty {
    private final EditingDomain editingDomain;

    public EMFEditResourceContentProperty(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    protected void doSetList(Object source, List list, ListDiff diff) {
        final ListVisitorImpl visitor = new ListVisitorImpl((Resource)source);
        diff.accept((ListDiffVisitor)visitor);
        this.editingDomain.getCommandStack().execute((Command)new CompoundCommand(){
            protected int index = 0;

            protected boolean prepare() {
                int size = visitor.commands.size();
                while (this.index < size) {
                    if (visitor.commands.get(this.index).canExecute()) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            public void execute() {
                int size = visitor.commands.size();
                while (this.index < size) {
                    this.appendAndExecute(visitor.commands.get(this.index));
                    ++this.index;
                }
            }
        });
    }

    private class ListVisitorImpl
    extends ListDiffVisitor {
        private Resource resource;
        protected final List<Command> commands = new ArrayList<Command>();

        private ListVisitorImpl(Resource resource) {
            this.resource = resource;
        }

        public void handleAdd(int index, Object element) {
            this.commands.add((Command)new AddCommand(EMFEditResourceContentProperty.this.editingDomain, this.resource.getContents(), element, index));
        }

        public void handleMove(int oldIndex, int newIndex, Object element) {
            this.commands.add((Command)new MoveCommand(EMFEditResourceContentProperty.this.editingDomain, this.resource.getContents(), element, newIndex));
        }

        public void handleReplace(int index, Object oldElement, Object newElement) {
            this.commands.add((Command)new ReplaceCommand(EMFEditResourceContentProperty.this.editingDomain, this.resource.getContents(), oldElement, Collections.singleton(newElement)));
        }

        public void handleRemove(int index, Object element) {
            this.commands.add((Command)new RemoveCommand(EMFEditResourceContentProperty.this.editingDomain, this.resource.getContents(), element));
        }
    }
}

