/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.gmodel.generator;

import com.google.common.base.Objects;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.ide.gmodel.gModelDSL.GDomainElement;
import org.eclipse.fx.ide.gmodel.gModelDSL.GDomainMap;
import org.eclipse.fx.ide.gmodel.gModelDSL.GDomainProperty;
import org.eclipse.fx.ide.gmodel.gModelDSL.GModel;
import org.eclipse.fx.ide.gmodel.generator.Util;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class InterfaceGenerator
implements IGenerator {
    public void doGenerate(Resource input, final IFileSystemAccess fsa) {
        EList _contents = input.getContents();
        EObject _head = (EObject)IterableExtensions.head((Iterable)_contents);
        final GModel root = (GModel)_head;
        URI _uRI = input.getURI();
        String _lastSegment = _uRI.lastSegment();
        URI _uRI_1 = input.getURI();
        String _lastSegment_1 = _uRI_1.lastSegment();
        int _length = _lastSegment_1.length();
        int _minus = _length - 5;
        final String name = _lastSegment.substring(0, _minus);
        EList<GDomainElement> _typeList = root.getTypeList();
        Consumer<GDomainElement> _function = new Consumer<GDomainElement>(){

            @Override
            public void accept(GDomainElement t) {
                String _name = root.getName();
                String _replace = _name.replace(".", "/");
                String _plus = String.valueOf(_replace) + "/";
                String _name_1 = t.getName();
                String _plus_1 = String.valueOf(_plus) + _name_1;
                String _plus_2 = String.valueOf(_plus_1) + ".java";
                CharSequence _generateType = InterfaceGenerator.this.generateType(t, name, root);
                fsa.generateFile(_plus_2, _generateType);
            }
        };
        _typeList.forEach((Consumer)_function);
        String _name = root.getName();
        String _replace = _name.replace(".", "/");
        String _plus = String.valueOf(_replace) + "/";
        String _plus_1 = String.valueOf(_plus) + name;
        String _plus_2 = String.valueOf(_plus_1) + "GModel.java";
        CharSequence _generateGmodelAccessor = this.generateGmodelAccessor(name, root);
        fsa.generateFile(_plus_2, _generateGmodelAccessor);
        String _name_1 = root.getName();
        String _replace_1 = _name_1.replace(".", "/");
        String _plus_3 = String.valueOf(_replace_1) + "/";
        String _plus_4 = String.valueOf(_plus_3) + name;
        String _plus_5 = String.valueOf(_plus_4) + "Base.java";
        CharSequence _generateBaseInterface = this.generateBaseInterface(name, root);
        fsa.generateFile(_plus_5, _generateBaseInterface);
    }

    public CharSequence generateBaseInterface(String name, GModel m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public interface ");
        _builder.append((Object)name, "");
        _builder.append((Object)"Base {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateGmodelAccessor(String name, GModel m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public interface ");
        _builder.append((Object)name, "");
        _builder.append((Object)"GModel {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"GModel create() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new ");
        String _name_1 = m.getName();
        _builder.append((Object)_name_1, "\t\t");
        _builder.append((Object)".gson.GsonElementFactory();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public <T extends ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"Base> T createObject(java.io.Reader json);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public <T extends ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"Base> java.util.List<T> createList(java.io.Reader json);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String toString(");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"Base o);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String toString(java.util.List<");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"Base> o);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList<GDomainElement> _typeList = m.getTypeList();
        for (GDomainElement t : _typeList) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_2 = t.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)".Builder ");
            String _name_3 = t.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)"Builder();");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateType(GDomainElement e, String name, GModel m) {
        boolean _notEquals;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList<GDomainElement> _superTypeList = e.getSuperTypeList();
        Set<GDomainElement> superHierarchy = Util.collectHierarchicalList(_superTypeList);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public interface ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" extends ");
        _builder.append((Object)name, "");
        _builder.append((Object)"Base");
        EList<GDomainElement> _superTypeList_1 = e.getSuperTypeList();
        boolean _isEmpty = _superTypeList_1.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)", ");
            Functions.Function1<GDomainElement, String> _function = new Functions.Function1<GDomainElement, String>(){

                public String apply(GDomainElement v) {
                    return v.getName();
                }
            };
            List _sortBy = IterableExtensions.sortBy(superHierarchy, (Functions.Function1)_function);
            Functions.Function1<GDomainElement, String> _function_1 = new Functions.Function1<GDomainElement, String>(){

                public String apply(GDomainElement v) {
                    return v.getName();
                }
            };
            List _map = ListExtensions.map((List)_sortBy, (Functions.Function1)_function_1);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
            _builder.append((Object)_join, "");
        }
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        EList<GDomainProperty> _propertyList = e.getPropertyList();
        for (GDomainProperty p : _propertyList) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _type = InterfaceGenerator.getType(p);
            _builder.append((Object)_type, "\t");
            _builder.append((Object)" ");
            String _type_1 = InterfaceGenerator.getType(p);
            boolean _equals = Objects.equal((Object)_type_1, (Object)"boolean");
            if (_equals) {
                _builder.append((Object)"is");
            } else {
                _builder.append((Object)"get");
            }
            String _name_2 = p.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name_2);
            _builder.append((Object)_firstUpper, "\t");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        GDomainMap _map_1 = e.getMap();
        boolean bl2 = _notEquals = !Objects.equal((Object)_map_1, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public java.util.Map<String,");
            GDomainMap _map_2 = e.getMap();
            String _plainType = InterfaceGenerator.getPlainType(_map_2);
            _builder.append((Object)_plainType, "\t");
            _builder.append((Object)"> getPropertyMap();");
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1<GDomainElement, String> _function_2 = new Functions.Function1<GDomainElement, String>(){

            public String apply(GDomainElement v) {
                return v.getName();
            }
        };
        List _sortBy_1 = IterableExtensions.sortBy(superHierarchy, (Functions.Function1)_function_2);
        for (Object t : _sortBy_1) {
            EList<GDomainProperty> _propertyList_1 = t.getPropertyList();
            for (GDomainProperty p_1 : _propertyList_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                String _type_2 = InterfaceGenerator.getType(p_1);
                _builder.append((Object)_type_2, "\t");
                _builder.append((Object)" ");
                String _type_3 = InterfaceGenerator.getType(p_1);
                boolean _equals_1 = Objects.equal((Object)_type_3, (Object)"boolean");
                if (_equals_1) {
                    _builder.append((Object)"is");
                } else {
                    _builder.append((Object)"get");
                }
                String _name_3 = p_1.getName();
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_3);
                _builder.append((Object)_firstUpper_1, "\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public interface Builder {");
        _builder.newLine();
        EList<GDomainProperty> _propertyList_2 = e.getPropertyList();
        for (GDomainProperty p_2 : _propertyList_2) {
            boolean _isList = p_2.isList();
            if (_isList) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"public Builder ");
                String _name_4 = p_2.getName();
                _builder.append((Object)_name_4, "\t\t");
                _builder.append((Object)"(");
                String _type_4 = InterfaceGenerator.getType(p_2);
                _builder.append((Object)_type_4, "\t\t");
                _builder.append((Object)" ");
                String _name_5 = p_2.getName();
                _builder.append((Object)_name_5, "\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"public Builder append");
                String _name_6 = p_2.getName();
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_6);
                _builder.append((Object)_firstUpper_2, "\t\t");
                _builder.append((Object)"(");
                String _plainType_1 = InterfaceGenerator.getPlainType(p_2);
                _builder.append((Object)_plainType_1, "\t\t");
                _builder.append((Object)" ");
                String _name_7 = p_2.getName();
                _builder.append((Object)_name_7, "\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                String _builtIn = p_2.getBuiltIn();
                boolean _equals_2 = Objects.equal((Object)_builtIn, null);
                if (!_equals_2) continue;
                _builder.append((Object)"\t\t");
                _builder.append((Object)"public Builder ");
                String _name_8 = p_2.getName();
                _builder.append((Object)_name_8, "\t\t");
                _builder.append((Object)"(java.util.function.Function<");
                _builder.append((Object)name, "\t\t");
                _builder.append((Object)"GModel,java.util.List<");
                String _plainType_2 = InterfaceGenerator.getPlainType(p_2);
                _builder.append((Object)_plainType_2, "\t\t");
                _builder.append((Object)">> provider);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"public Builder append");
                String _name_9 = p_2.getName();
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_9);
                _builder.append((Object)_firstUpper_3, "\t\t");
                _builder.append((Object)"(java.util.function.Function<");
                String _plainType_3 = InterfaceGenerator.getPlainType(p_2);
                _builder.append((Object)_plainType_3, "\t\t");
                _builder.append((Object)".Builder,");
                String _plainType_4 = InterfaceGenerator.getPlainType(p_2);
                _builder.append((Object)_plainType_4, "\t\t");
                _builder.append((Object)"> provider);");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"public Builder ");
            String _name_10 = p_2.getName();
            _builder.append((Object)_name_10, "\t\t");
            _builder.append((Object)"(");
            String _type_5 = InterfaceGenerator.getType(p_2);
            _builder.append((Object)_type_5, "\t\t");
            _builder.append((Object)" ");
            String _name_11 = p_2.getName();
            _builder.append((Object)_name_11, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1<GDomainElement, String> _function_3 = new Functions.Function1<GDomainElement, String>(){

            public String apply(GDomainElement v) {
                return v.getName();
            }
        };
        List _sortBy_2 = IterableExtensions.sortBy(superHierarchy, (Functions.Function1)_function_3);
        for (GDomainElement t_1 : _sortBy_2) {
            EList<GDomainProperty> _propertyList_3 = t_1.getPropertyList();
            for (GDomainProperty p_3 : _propertyList_3) {
                boolean _isList_1 = p_3.isList();
                if (_isList_1) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"public Builder ");
                    String _name_12 = p_3.getName();
                    _builder.append((Object)_name_12, "\t\t");
                    _builder.append((Object)"(");
                    String _type_6 = InterfaceGenerator.getType(p_3);
                    _builder.append((Object)_type_6, "\t\t");
                    _builder.append((Object)" ");
                    String _name_13 = p_3.getName();
                    _builder.append((Object)_name_13, "\t\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"public Builder append");
                    String _name_14 = p_3.getName();
                    String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_14);
                    _builder.append((Object)_firstUpper_4, "\t\t");
                    _builder.append((Object)"(");
                    String _plainType_5 = InterfaceGenerator.getPlainType(p_3);
                    _builder.append((Object)_plainType_5, "\t\t");
                    _builder.append((Object)" ");
                    String _name_15 = p_3.getName();
                    _builder.append((Object)_name_15, "\t\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    String _builtIn_1 = p_3.getBuiltIn();
                    boolean _equals_3 = Objects.equal((Object)_builtIn_1, null);
                    if (!_equals_3) continue;
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"public Builder ");
                    String _name_16 = p_3.getName();
                    _builder.append((Object)_name_16, "\t\t");
                    _builder.append((Object)"(java.util.function.Function<");
                    _builder.append((Object)name, "\t\t");
                    _builder.append((Object)"GModel,java.util.List<");
                    String _plainType_6 = InterfaceGenerator.getPlainType(p_3);
                    _builder.append((Object)_plainType_6, "\t\t");
                    _builder.append((Object)">> provider);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"public Builder append");
                    String _name_17 = p_3.getName();
                    String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_17);
                    _builder.append((Object)_firstUpper_5, "\t\t");
                    _builder.append((Object)"(java.util.function.Function<");
                    String _plainType_7 = InterfaceGenerator.getPlainType(p_3);
                    _builder.append((Object)_plainType_7, "\t\t");
                    _builder.append((Object)".Builder,");
                    String _plainType_8 = InterfaceGenerator.getPlainType(p_3);
                    _builder.append((Object)_plainType_8, "\t\t");
                    _builder.append((Object)"> provider);");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"public Builder ");
                String _name_18 = p_3.getName();
                _builder.append((Object)_name_18, "\t\t");
                _builder.append((Object)"(");
                String _type_7 = InterfaceGenerator.getType(p_3);
                _builder.append((Object)_type_7, "\t\t");
                _builder.append((Object)" ");
                String _name_19 = p_3.getName();
                _builder.append((Object)_name_19, "\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public ");
        String _name_20 = e.getName();
        _builder.append((Object)_name_20, "\t\t");
        _builder.append((Object)" build();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public static String getType(GDomainProperty p) {
        boolean _isList = p.isList();
        if (_isList) {
            String _plainType = InterfaceGenerator.getPlainType(p);
            String _plus = "java.util.List<" + _plainType;
            return String.valueOf(_plus) + ">";
        }
        return InterfaceGenerator.getPlainType(p);
    }

    public static String getPlainType(GDomainProperty p) {
        boolean _notEquals;
        String _xifexpression = null;
        String _builtIn = p.getBuiltIn();
        boolean bl = _notEquals = !Objects.equal((Object)_builtIn, null);
        if (_notEquals) {
            String _builtIn_1 = p.getBuiltIn();
            _xifexpression = Util.toJavaType(_builtIn_1);
        } else {
            GDomainElement _ref = p.getRef();
            _xifexpression = _ref.getName();
        }
        return _xifexpression;
    }

    public static String getPlainType(GDomainMap p) {
        boolean _notEquals;
        String _xifexpression = null;
        String _builtIn = p.getBuiltIn();
        boolean bl = _notEquals = !Objects.equal((Object)_builtIn, null);
        if (_notEquals) {
            String _builtIn_1 = p.getBuiltIn();
            _xifexpression = Util.toJavaType(_builtIn_1);
        } else {
            GDomainElement _ref = p.getRef();
            _xifexpression = _ref.getName();
        }
        return _xifexpression;
    }
}

