/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Spacing implements Enumerator
{
    AUTO(0, "auto", "auto"),
    EXACT(1, "exact", "exact");

    public static final int AUTO_VALUE = 0;
    public static final int EXACT_VALUE = 1;
    private static final Spacing[] VALUES_ARRAY;
    public static final List<Spacing> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Spacing[]{AUTO, EXACT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Spacing get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Spacing result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Spacing getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Spacing result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Spacing get(int value) {
        switch (value) {
            case 0: {
                return AUTO;
            }
            case 1: {
                return EXACT;
            }
        }
        return null;
    }

    private Spacing(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

