/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.pde.ui.e4.project.boot;

import org.eclipse.fx.ide.pde.ui.e4.project.boot.AppBundleProjectData;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class GeneratorConfigurationPage
extends WizardPage {
    private AppBundleProjectData data;
    private Button tychoButton;
    private Button nativePackaging;
    private Text productName;
    private ModifyListener propertiesListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            GeneratorConfigurationPage.this.setPageComplete(GeneratorConfigurationPage.this.validate());
        }
    };
    private SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            GeneratorConfigurationPage.this.setPageComplete(GeneratorConfigurationPage.this.validate());
        }
    };
    private ISelectionChangedListener sListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            GeneratorConfigurationPage.this.setPageComplete(GeneratorConfigurationPage.this.validate());
        }
    };
    private Button p2Update;
    private Text p2UpdateSite;
    private ComboViewer classloading;

    public GeneratorConfigurationPage(AppBundleProjectData data, String pageName, String title) {
        super(pageName, title, null);
        this.data = data;
        this.setPageComplete(false);
    }

    protected boolean validate() {
        this.setErrorMessage(null);
        this.p2UpdateSite.setEnabled(this.p2Update.getSelection());
        if (this.productName.getText().trim().isEmpty()) {
            this.setErrorMessage("You need to enter a product name");
            return false;
        }
        this.data.setProductName(this.productName.getText());
        this.data.setP2Update(this.p2Update.getSelection());
        this.data.setUpdateSite(this.p2UpdateSite.getText());
        this.data.setTychoIntegration(this.tychoButton.getSelection());
        this.data.setNativeExport(this.nativePackaging.getSelection());
        this.data.setClassloadingStrategy(this.classloading.getStructuredSelection().getFirstElement().toString());
        return true;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Group group = new Group(container, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText("Customizations");
        group.setLayout((Layout)new GridLayout(2, false));
        this.createLabel((Composite)group, "Product Name:");
        this.productName = this.createText((Composite)group, this.propertiesListener, 1);
        this.productName.setMessage("Enter a product name");
        this.createLabel((Composite)group, "Classloading:");
        this.classloading = this.createCombo((Composite)group);
        this.classloading.setInput((Object)new String[]{"default", "ext", "boot", "app", "fwk", "ccl"});
        this.classloading.setSelection((ISelection)new StructuredSelection((Object)this.data.getClassloadingStrategy()));
        this.classloading.addSelectionChangedListener(this.sListener);
        this.createLabel((Composite)group, "Tycho Build Stubs:");
        this.tychoButton = this.createCheckbox((Composite)group, this.listener);
        this.tychoButton.setSelection(this.data.isTychoIntegration());
        this.createLabel((Composite)group, "Native packaging:");
        this.nativePackaging = this.createCheckbox((Composite)group, this.listener);
        this.nativePackaging.setSelection(this.data.isNativeExport());
        this.createLabel((Composite)group, "Enable p2 updates");
        this.p2Update = this.createCheckbox((Composite)group, this.listener);
        this.p2Update.setSelection(this.data.isP2Update());
        this.createLabel((Composite)group, "p2 Update-URL");
        this.p2UpdateSite = this.createText((Composite)group, this.propertiesListener, 1);
        this.p2UpdateSite.setText(this.data.getUpdateSite());
        this.p2UpdateSite.setEnabled(this.data.isP2Update());
        this.setControl((Control)container);
    }

    protected Text createText(Composite parent, ModifyListener listener, int horizSpan) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(768);
        data.horizontalSpan = horizSpan;
        text.setLayoutData((Object)data);
        text.addModifyListener(listener);
        return text;
    }

    private Button createCheckbox(Composite container, SelectionListener listener) {
        Button b = new Button(container, 32);
        b.addSelectionListener(listener);
        return b;
    }

    private ComboViewer createCombo(Composite container) {
        ComboViewer v = new ComboViewer(container, 8);
        v.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        v.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        return v;
    }

    private Label createLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        return label;
    }
}

