/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.common.dnd.DragSourcePlaceHolder;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MEMultiLinkControlDropAdapter
implements DropTargetListener {
    private List<EObject> source;
    private EObject dropee;
    private EObject target;
    private EReference reference;
    private final ECPModelelementContext modelElementContext;

    public MEMultiLinkControlDropAdapter(EObject me, EReference reference, ECPModelelementContext modelElementContext) {
        this.reference = reference;
        this.target = me;
        this.modelElementContext = modelElementContext;
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        if (this.dropee != null) {
            new ECPCommand(this.dropee){

                protected void doRun() {
                    MEMultiLinkControlDropAdapter.this.addME();
                }
            };
        }
    }

    private void addME() {
        if (this.reference == null) {
            return;
        }
        if (this.reference.getEOpposite() != null) {
            EReference oppositeRef = this.reference.getEOpposite();
            for (EObject me : this.source) {
                Object object = me.eGet((EStructuralFeature)oppositeRef);
                if (oppositeRef.isMany()) {
                    EList eList = (EList)object;
                    eList.add((Object)this.target);
                    continue;
                }
                me.eSet((EStructuralFeature)oppositeRef, (Object)this.target);
            }
        } else if (this.reference.isMany()) {
            Object object = this.target.eGet((EStructuralFeature)this.reference);
            EList eList = (EList)object;
            eList.addAll(this.source);
        } else {
            this.target.eSet((EStructuralFeature)this.reference, (Object)this.source.get(0));
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        this.source = null;
        event.detail = 1;
        if (!this.extractDnDSourceAndTarget()) {
            event.detail = 0;
            return;
        }
        if (this.source.size() > 1) {
            event.detail = 0;
            return;
        }
        if (!this.canDrop(event)) {
            event.detail = 0;
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public boolean canDrop(DropTargetEvent event) {
        if (this.target == this.dropee) {
            return false;
        }
        if (EcoreUtil.isAncestor((EObject)this.dropee, (EObject)this.target)) {
            return false;
        }
        if (!this.haveSameEContainer(this.source)) {
            return false;
        }
        EClass eReferenceType = this.reference.getEReferenceType();
        return eReferenceType.isSuperTypeOf(this.dropee.eClass()) || eReferenceType.equals(EcorePackage.eINSTANCE.getEObject());
    }

    protected boolean haveSameEContainer(List<EObject> source) {
        EObject first = source.get(0);
        for (EObject me : source) {
            if (first.eContainer().equals(me.eContainer())) continue;
            return false;
        }
        return true;
    }

    private boolean extractDnDSourceAndTarget() {
        boolean result = true;
        if (this.target == null) {
            return false;
        }
        List tmpSource = (List)DragSourcePlaceHolder.getDragSource();
        if (tmpSource == null) {
            result = false;
        }
        for (Object obj : tmpSource) {
            if (obj instanceof EObject) continue;
            result = false;
        }
        this.source = (List)DragSourcePlaceHolder.getDragSource();
        if (this.source.size() == 0) {
            return false;
        }
        if (result) {
            this.dropee = this.source.get(0);
            if (this.modelElementContext.contains(this.dropee)) {
                result = false;
            }
        }
        return result;
    }
}

