/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.associationclasscontrol;

import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.Activator;
import org.eclipse.emf.ecp.common.MEClassLabelProvider;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.common.model.ECPMetaModelElementContext;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.emf.ecp.common.model.workSpaceModel.util.AssociationClassHelper;
import org.eclipse.emf.ecp.common.util.OverlayImageDescriptor;
import org.eclipse.emf.ecp.common.utilities.ActionHelper;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class NewAssociationClassAction
extends Action {
    private static final String DIALOG_MESSAGE = "Select a model element type to be created:";
    private EReference eReference;
    private EObject modelElement;
    private final ECPModelelementContext context;

    public NewAssociationClassAction(EObject modelElement, EReference eReference, IItemPropertyDescriptor descriptor, ECPModelelementContext context) {
        this.modelElement = modelElement;
        this.eReference = eReference;
        this.context = context;
        EObject obj = null;
        if (!eReference.getEReferenceType().isAbstract()) {
            obj = eReference.getEReferenceType().getEPackage().getEFactoryInstance().create(eReference.getEReferenceType());
        }
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        Image image = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory).getImage((Object)obj);
        adapterFactory.dispose();
        ImageDescriptor addOverlay = Activator.getImageDescriptor((String)"icons/add_overlay.png");
        OverlayImageDescriptor imageDescriptor = new OverlayImageDescriptor(image, addOverlay, 2);
        this.setImageDescriptor((ImageDescriptor)imageDescriptor);
        String attribute = descriptor.getDisplayName((Object)eReference);
        if (attribute.endsWith("ies")) {
            attribute = String.valueOf(attribute.substring(0, attribute.length() - 3)) + "y";
        } else if (attribute.endsWith("s")) {
            attribute = attribute.substring(0, attribute.length() - 1);
        }
        this.setToolTipText("Create and link new " + attribute);
    }

    public void run() {
        new NewAssociationClassCommand(this.modelElement).run(true);
    }

    private final class NewAssociationClassCommand
    extends ECPCommand {
        public NewAssociationClassCommand(EObject eObject) {
            super(eObject);
        }

        protected void doRun() {
            EClass relatedModelElementClass = null;
            Set subclasses = NewAssociationClassAction.this.context.getMetaModelElementContext().getAllSubEClasses(NewAssociationClassAction.this.modelElement.eClass(), false);
            if (subclasses.size() == 1) {
                relatedModelElementClass = (EClass)subclasses.iterator().next();
            } else {
                ElementListSelectionDialog dlg = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new MEClassLabelProvider());
                dlg.setMessage(NewAssociationClassAction.DIALOG_MESSAGE);
                dlg.setElements(subclasses.toArray());
                dlg.setTitle("Select Element type");
                dlg.setBlockOnOpen(true);
                if (dlg.open() != 0) {
                    return;
                }
                Object result = dlg.getFirstResult();
                if (result instanceof EClass) {
                    relatedModelElementClass = (EClass)result;
                }
            }
            EPackage ePackage = relatedModelElementClass.getEPackage();
            EObject relatedModelElement = ePackage.getEFactoryInstance().create(relatedModelElementClass);
            if (!NewAssociationClassAction.this.eReference.isContainer()) {
                EObject parent = NewAssociationClassAction.this.modelElement.eContainer();
                while (parent != null && relatedModelElement.eContainer() == null) {
                    EReference reference = NewAssociationClassAction.this.context.getMetaModelElementContext().getPossibleContainingReference(relatedModelElement, parent);
                    if (reference != null && reference.isMany()) {
                        Object object = parent.eGet((EStructuralFeature)reference);
                        EList eList = (EList)object;
                        eList.add((Object)relatedModelElement);
                    }
                    parent = parent.eContainer();
                }
                if (relatedModelElement.eContainer() == null) {
                    throw new RuntimeException("No matching container for model element found");
                }
            }
            AssociationClassHelper.createAssociation((EReference)NewAssociationClassAction.this.eReference, (EObject)NewAssociationClassAction.this.modelElement, (EObject)relatedModelElement, (ECPMetaModelElementContext)NewAssociationClassAction.this.context.getMetaModelElementContext());
            ActionHelper.openModelElement((EObject)relatedModelElement, (String)((Object)((Object)this)).getClass().getName());
        }
    }
}

