/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.model.versioning.operations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContainmentType implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    CONTAINER(1, "CONTAINER", "CONTAINER"),
    CONTAINMENT(2, "CONTAINMENT", "CONTAINMENT");

    public static final int NONE_VALUE = 0;
    public static final int CONTAINER_VALUE = 1;
    public static final int CONTAINMENT_VALUE = 2;
    private static final ContainmentType[] VALUES_ARRAY;
    public static final List<ContainmentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContainmentType[]{NONE, CONTAINER, CONTAINMENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContainmentType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainmentType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainmentType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainmentType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainmentType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CONTAINER;
            }
            case 2: {
                return CONTAINMENT;
            }
        }
        return null;
    }

    private ContainmentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

