/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.navigator.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.util.DialogHandler;
import org.eclipse.emf.ecp.common.util.PreferenceHelper;
import org.eclipse.emf.ecp.common.util.UiUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportModelHandler
extends AbstractHandler {
    private static final String FILE_EXTENSION = "ecm";
    public static final String[] FILTER_NAMES = new String[]{"EMFStore Project Files (*.ecm)", "All Files (*.*)"};
    public static final String[] FILTER_EXTS = new String[]{"*.ecm, *.*"};
    private static final String EXPORT_MODEL_PATH = "org.eclipse.emf.emfstore.client.ui.exportModelPath";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<EObject> exportModelElements = this.getSelfContainedModelElementTree(event);
        if (exportModelElements.size() > 0) {
            String filePath = this.getFilePathByFileDialog(UiUtil.getNameForModelElement((EObject)exportModelElements.get(0)));
            if (filePath == null) {
                return null;
            }
            PreferenceHelper.setPreference((String)EXPORT_MODEL_PATH, (String)new File(filePath).getParent());
            this.runCommand(exportModelElements, filePath);
        }
        return null;
    }

    private void runCommand(List<EObject> exportModelElements, String filePath) {
        File file = new File(filePath);
        URI uri = URI.createFileURI((String)filePath);
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        progressDialog.open();
        progressDialog.getProgressMonitor().beginTask("Export modelelement...", 100);
        progressDialog.getProgressMonitor().worked(10);
        try {
            this.saveEObjectToResource(exportModelElements, uri);
        }
        catch (IOException e) {
            DialogHandler.showExceptionDialog((String)e.getMessage(), (Exception)e);
        }
        progressDialog.getProgressMonitor().done();
        progressDialog.close();
        MessageDialog.openInformation(null, (String)"Export", (String)("Exported modelelement to file " + file.getName()));
    }

    private List<EObject> getSelfContainedModelElementTree(ExecutionEvent event) {
        Object firstElement;
        ArrayList<EObject> result = new ArrayList<EObject>();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IStructuredSelection strucSel = null;
        EObject copyModelElement = null;
        if (selection != null && selection instanceof IStructuredSelection && (firstElement = (strucSel = (IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            copyModelElement = EcoreUtil.copy((EObject)((EObject)firstElement));
            result.add(copyModelElement);
        }
        return result;
    }

    private String getFilePathByFileDialog(String modelElementName) {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        dialog.setFilterNames(FILTER_NAMES);
        dialog.setFilterExtensions(FILTER_EXTS);
        String initialPath = PreferenceHelper.getPreference((String)EXPORT_MODEL_PATH, (String)System.getProperty("user.home"));
        dialog.setFilterPath(initialPath);
        dialog.setOverwrite(true);
        try {
            String initialFileName = "ModelElement_" + modelElementName + "." + FILE_EXTENSION;
            dialog.setFileName(initialFileName);
        }
        catch (NullPointerException initialFileName) {
            // empty catch block
        }
        String filePath = dialog.open();
        return filePath;
    }

    public void saveEObjectToResource(List<? extends EObject> eObjects, URI resourceURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(resourceURI);
        EList contents = resource.getContents();
        for (EObject eObject : eObjects) {
            contents.add((Object)eObject);
        }
        contents.addAll(eObjects);
        resource.save(null);
    }

    public void saveEObjectToResource(EObject eObject, URI resourceURI) throws IOException {
        ArrayList<EObject> list = new ArrayList<EObject>();
        list.add(eObject);
        this.saveEObjectToResource(list, resourceURI);
    }
}

