/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.emfstore.client.model.CompositeOperationHandle;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.impl.OperationRecorder;
import org.eclipse.emf.emfstore.client.model.impl.OperationRecorderListener;
import org.eclipse.emf.emfstore.client.model.observers.OperationObserver;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.semantic.SemanticCompositeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationManager
implements OperationRecorderListener {
    private OperationRecorder operationRecorder;
    private List<OperationObserver> operationListeners;
    private ProjectSpace projectSpace;

    public OperationManager(OperationRecorder operationRecorder, ProjectSpace projectSpace) {
        this.operationRecorder = operationRecorder;
        operationRecorder.addOperationRecorderListener(this);
        this.operationListeners = new ArrayList<OperationObserver>();
        this.projectSpace = projectSpace;
    }

    public void undoLastOperation() {
        if (!this.projectSpace.getOperations().isEmpty()) {
            List<AbstractOperation> operations = this.projectSpace.getOperations();
            AbstractOperation lastOperation = operations.get(operations.size() - 1);
            this.operationRecorder.stopChangeRecording();
            try {
                lastOperation.reverse().apply(this.operationRecorder.getCollection());
                this.notifyOperationUndone(lastOperation);
            }
            finally {
                this.operationRecorder.startChangeRecording();
            }
            operations.remove(lastOperation);
        }
    }

    public void addOperationListener(OperationObserver operationListener) {
        this.operationListeners.add(operationListener);
    }

    public void removeOperationListener(OperationObserver operationListner) {
        this.operationListeners.remove(operationListner);
    }

    public void notifyOperationUndone(AbstractOperation operation) {
        for (OperationObserver operationListener : this.operationListeners) {
            operationListener.operationUnDone(operation);
        }
    }

    void notifyOperationExecuted(AbstractOperation operation) {
        if (operation instanceof CompositeOperation && ((CompositeOperation)operation).getMainOperation() == null) {
            return;
        }
        for (OperationObserver operationListener : this.operationListeners) {
            operationListener.operationExecuted(operation);
        }
    }

    public void abortCompositeOperation() {
        this.undoLastOperation();
        this.operationRecorder.abortCompositeOperation();
    }

    public void endCompositeOperation() {
        this.notifyOperationExecuted((AbstractOperation)this.operationRecorder.getCompositeOperation());
        this.operationRecorder.endCompositeOperation();
    }

    public void endCompositeOperation(SemanticCompositeOperation semanticCompositeOperation) {
        List<AbstractOperation> operations = this.projectSpace.getOperations();
        operations.remove(operations.size() - 1);
        operations.add((AbstractOperation)semanticCompositeOperation);
        this.endCompositeOperation();
    }

    public CompositeOperationHandle beginCompositeOperation() {
        return this.operationRecorder.beginCompositeOperation();
    }

    @Override
    public void operationsRecorded(List<? extends AbstractOperation> operations) {
        this.projectSpace.addOperations(operations);
    }

    public void clearOperations() {
        this.operationRecorder.clearOperations();
    }
}

