/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XLine2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.svek.extremity.ExtremityArrow;
import net.sourceforge.plantuml.wbs.WElement;

class WBSLink
implements UDrawable {
    private final WElement element1;
    private final WElement element2;
    private final HColor color;

    public WBSLink(WElement element1, WElement element2, HColor color) {
        this.element1 = element1;
        this.element2 = element2;
        this.color = color;
        if (color == null) {
            throw new IllegalArgumentException();
        }
    }

    public final WElement getElement1() {
        return this.element1;
    }

    public final WElement getElement2() {
        return this.element2;
    }

    @Override
    public void drawU(UGraphic ug) {
        WElement element1 = this.getElement1();
        WElement element2 = this.getElement2();
        UTranslate position1 = element1.getPosition();
        UTranslate position2 = element2.getPosition();
        XDimension2D dim1 = element1.getDimension();
        XDimension2D dim2 = element2.getDimension();
        if (position1 != null && position2 != null) {
            XRectangle2D rect1 = new XRectangle2D(position1.getDx(), position1.getDy(), dim1.getWidth(), dim1.getHeight());
            XRectangle2D rect2 = new XRectangle2D(position2.getDx(), position2.getDy(), dim2.getWidth(), dim2.getHeight());
            XLine2D line = new XLine2D(rect1.getCenterX(), rect1.getCenterY(), rect2.getCenterX(), rect2.getCenterY());
            XPoint2D c1 = rect1.intersect(line);
            XPoint2D c2 = rect2.intersect(line);
            line = XLine2D.line(c1, c2);
            ug = ug.apply(this.color);
            line.drawU(ug);
            double angle = line.getAngle();
            ExtremityArrow arrow = new ExtremityArrow(c2, angle);
            arrow.drawU(ug);
        }
    }
}

