/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.base.record.RecordMapper;
import org.apache.jena.dboe.trans.bplustree.AccessPath;
import org.apache.jena.dboe.trans.bplustree.BPTreeNode;
import org.apache.jena.dboe.trans.bplustree.BPTreePage;
import org.apache.jena.dboe.trans.bplustree.BPTreeRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BPTreeRangeIteratorMapper<X>
implements Iterator<X> {
    static Logger log = LoggerFactory.getLogger(BPTreeRangeIteratorMapper.class);
    private final Deque<Iterator<BPTreePage>> stack = new ArrayDeque<Iterator<BPTreePage>>();
    private final Record minRecord;
    private final Record maxRecord;
    private final RecordMapper<X> mapper;
    private Iterator<X> current;
    private X slot = null;
    private final byte[] keySlot;
    private boolean finished = false;

    public static <X> Iterator<X> create(BPTreeNode node, Record minRec, Record maxRec, int keyLength, RecordMapper<X> mapper) {
        if (minRec != null && maxRec != null && Record.keyGE(minRec, maxRec)) {
            return Iter.nullIter();
        }
        return new BPTreeRangeIteratorMapper<X>(node, minRec, maxRec, keyLength, mapper);
    }

    BPTreeRangeIteratorMapper(BPTreeNode node, Record minRec, Record maxRec, int keyLength, RecordMapper<X> mapper) {
        this.minRecord = minRec;
        this.maxRecord = maxRec;
        this.mapper = mapper;
        this.keySlot = new byte[keyLength];
        BPTreeRecords r = this.loadStack(node);
        this.current = BPTreeRangeIteratorMapper.getRecordsIterator(r, this.minRecord, this.maxRecord, mapper);
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.slot != null) {
            return true;
        }
        while (this.current != null && !this.current.hasNext()) {
            this.current = this.moveOnCurrent();
        }
        if (this.current == null) {
            this.end();
            return false;
        }
        this.slot = this.current.next();
        return true;
    }

    private Iterator<X> moveOnCurrent() {
        Iterator<BPTreePage> iter = null;
        while (!this.stack.isEmpty() && !(iter = this.stack.peek()).hasNext()) {
            this.stack.pop();
        }
        if (iter == null || !iter.hasNext()) {
            return null;
        }
        BPTreePage p = iter.next();
        BPTreeRecords r = null;
        r = p instanceof BPTreeNode ? this.loadStack((BPTreeNode)p) : (BPTreeRecords)p;
        return BPTreeRangeIteratorMapper.getRecordsIterator(r, this.minRecord, this.maxRecord, this.mapper);
    }

    private static <X> Iterator<X> getRecordsIterator(BPTreeRecords records, Record minRecord, Record maxRecord, RecordMapper<X> mapper) {
        records.bpTree.startReadBlkMgr();
        Iterator<X> iter = records.getRecordBuffer().iterator(minRecord, maxRecord, mapper);
        records.bpTree.finishReadBlkMgr();
        return iter;
    }

    private BPTreeRecords loadStack(BPTreeNode node) {
        AccessPath path = new AccessPath(null);
        node.bpTree.startReadBlkMgr();
        if (this.minRecord == null) {
            node.internalMinRecord(path);
        } else {
            node.internalSearch(path, this.minRecord);
        }
        List<AccessPath.AccessStep> steps = path.getPath();
        for (AccessPath.AccessStep step : steps) {
            BPTreeNode n = step.node;
            Iterator<BPTreePage> it = n.iterator(this.minRecord, this.maxRecord);
            if (it == null || !it.hasNext()) continue;
            BPTreePage p = it.next();
            this.stack.push(it);
        }
        BPTreePage p = steps.get((int)(steps.size() - 1)).page;
        if (!(p instanceof BPTreeRecords)) {
            throw new InternalErrorException("Last path step not to a records block");
        }
        node.bpTree.finishReadBlkMgr();
        return (BPTreeRecords)p;
    }

    private void end() {
        this.finished = true;
        this.current = null;
    }

    public void close() {
        if (!this.finished) {
            this.end();
        }
    }

    @Override
    public X next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        X r = this.slot;
        if (r == null) {
            throw new InternalErrorException("Null slot after hasNext is true");
        }
        this.slot = null;
        return r;
    }
}

