/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.shared.JenaException;

public enum TextDirection {
    LTR("ltr"),
    RTL("rtl");

    private final String direction;

    private TextDirection(String string2) {
        this.direction = string2;
    }

    public String direction() {
        return this.direction;
    }

    public String toString() {
        return this.direction;
    }

    public static TextDirection create(String label) {
        String s;
        return switch (s = Lib.lowercase(label)) {
            case "ltr" -> LTR;
            case "rtl" -> RTL;
            default -> throw new JenaException("Initial text direction must be 'ltr' or 'rtl'");
        };
    }
}

