/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.codegen.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.codegen.util.CodegenXtendPlugin;
import org.eclipse.gmf.codegen.util.IExtensionTemplatesProvider;
import org.eclipse.gmf.codegen.util.ManifestUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;

public class ExtensionTemplatesProviderImpl
implements IExtensionTemplatesProvider {
    public static String DEFAULT_DYNAMIC_TEMPLATES_FOLDER = "/aspects";
    public static String POINT_SEPARATOR = ".";
    public static String EMPLTY_STRING = "";
    public static String TEMPLATE_FILE_EXTENSIION = "xtend";
    private final String myCustomTemplatePath;
    private List<Class<?>> myDinamicClasses;
    private List<Class<?>> myCustomClasses;
    private static final String SLASH = "/";
    private final Bundle myBundle;
    private final boolean myAspectsNeed;
    private final boolean myUsePluginNotProject;

    public ExtensionTemplatesProviderImpl(String customPath, boolean aspectsNeed) {
        this.myUsePluginNotProject = customPath.startsWith("platform:/plugin/");
        if (!this.myUsePluginNotProject) {
            if (customPath.startsWith(SLASH)) {
                customPath = customPath.substring(1, customPath.length() - 1);
            }
            String[] parts = customPath.split(SLASH);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(parts[0]);
            this.myCustomTemplatePath = ExtensionTemplatesProviderImpl.getTemplateEntryFromURL(customPath, 1);
            ManifestUtil.createOrFillManifest(project);
            try {
                this.myBundle = ExtensionTemplatesProviderImpl.loadBundle(project);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Cannot create correct URL for Bundle.", e);
            }
            catch (BundleException e) {
                throw new RuntimeException("Error. Bundle was not load.", e);
            }
        } else {
            this.myCustomTemplatePath = ExtensionTemplatesProviderImpl.getTemplateEntryFromURL(customPath, 3);
            this.myBundle = Platform.getBundle((String)ExtensionTemplatesProviderImpl.getBundleNameFromURL(customPath));
        }
        this.myAspectsNeed = aspectsNeed;
    }

    private static String getBundleNameFromURL(String url) {
        return url.split(SLASH)[2];
    }

    private static String getTemplateEntryFromURL(String url, int part) {
        StringBuilder result = new StringBuilder();
        String[] parts = url.split(SLASH);
        int i = part;
        while (i < parts.length) {
            result.append(parts[i]).append(SLASH);
            ++i;
        }
        return result.toString();
    }

    private static Bundle loadBundle(IProject project) throws MalformedURLException, BundleException {
        String url = project.getLocation().toFile().toURI().toURL().toExternalForm();
        return CodegenXtendPlugin.getInstance().getContext().installBundle(url);
    }

    @Override
    public List<Class<?>> getCustomTemplateClasses() {
        if (this.myCustomClasses == null) {
            this.myCustomClasses = new LinkedList();
            this.myCustomClasses.addAll(this.loadClassesFromBundle(false));
        }
        return this.myCustomClasses;
    }

    @Override
    public List<Class<?>> getDynamicTemplateClasses() {
        if (this.myDinamicClasses == null) {
            this.myDinamicClasses = new LinkedList();
            if (this.myAspectsNeed) {
                this.myDinamicClasses.addAll(this.loadClassesFromBundle(true));
            }
        }
        return this.myDinamicClasses;
    }

    @Override
    public Class<?> getSuperClassForDynamic(Class<?> _class) {
        return _class.getSuperclass();
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException, IOException {
        return this.myBundle.loadClass(className);
    }

    @Override
    public void dispose() {
        if (!this.myUsePluginNotProject) {
            try {
                Bundle systemBundle = CodegenXtendPlugin.getInstance().getContext().getBundle(0L);
                this.myBundle.uninstall();
                FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
                frameworkWiring.refreshBundles(frameworkWiring.getRemovalPendingBundles(), new FrameworkListener[0]);
            }
            catch (BundleException e) {
                throw new RuntimeException("Error while unloading bundle.", e);
            }
        }
    }

    private List<Class<?>> loadClassesFromBundle(boolean aspectNotCustom) {
        LinkedList result = new LinkedList();
        Enumeration classsesURL = this.myBundle.findEntries(this.myCustomTemplatePath, "*.xtend", true);
        while (classsesURL != null && classsesURL.hasMoreElements()) {
            String classPath = ((URL)classsesURL.nextElement()).toString().trim();
            classPath = classPath.substring(classPath.indexOf(this.myCustomTemplatePath), classPath.length()).replace(this.myCustomTemplatePath, EMPLTY_STRING).replace(String.valueOf(POINT_SEPARATOR) + TEMPLATE_FILE_EXTENSIION, EMPLTY_STRING);
            try {
                if (aspectNotCustom && classPath.startsWith("aspects")) {
                    result.add(this.loadClass(this.getFQCN(classPath)));
                    continue;
                }
                if (aspectNotCustom || classPath.startsWith("aspects")) continue;
                result.add(this.loadClass(this.getFQCN(classPath)));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error. Did not load " + classPath + ". Class not found.", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Error has occurred when try to load " + classPath, e);
            }
        }
        return result;
    }

    private String getFQCN(String entryPath) {
        return entryPath.replace(SLASH, POINT_SEPARATOR);
    }
}

