/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.labels;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.lite.edit.parts.labels.AbstractFeatureBasedLabelTextDisplayer;

public class PrintfLabelTextDisplayer
extends AbstractFeatureBasedLabelTextDisplayer {
    private final String myViewPattern;
    private final String myEditorPattern;

    public PrintfLabelTextDisplayer(String viewPattern, EStructuralFeature ... features) {
        this(viewPattern, viewPattern, features);
    }

    public PrintfLabelTextDisplayer(String viewPattern, String editorPattern, EStructuralFeature ... features) {
        super(features);
        this.myViewPattern = this.adjustPattern(viewPattern);
        this.myEditorPattern = this.adjustPattern(editorPattern);
    }

    @Override
    protected Object[] parseEditedValues(String newString) throws IllegalArgumentException {
        return null;
    }

    @Override
    protected String buildDisplayText(Object[] featureValues) {
        return this.buildText(featureValues, this.myViewPattern);
    }

    @Override
    protected String buildEditText(Object[] featureValues) {
        return this.buildText(featureValues, this.myEditorPattern);
    }

    protected String adjustPattern(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.getFeatures().length) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append('%');
                sb.append(i + 1);
                sb.append('$');
                sb.append('s');
                ++i;
            }
            return sb.toString();
        }
        return pattern;
    }

    protected String buildText(Object[] featureValues, String pattern) {
        return String.format(pattern, featureValues);
    }
}

