/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.ComplexType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.CppProcedureHelpers;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class DataClassGen {
    @Inject
    @Extension
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private CppExtensions stdExt;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private CppProcedureHelpers helpers;
    @Inject
    private Initialization initHelper;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;

    public void doGenerate(final Root root) {
        Functions.Function1<DataClass, Boolean> function1 = new Functions.Function1<DataClass, Boolean>(){

            public Boolean apply(DataClass it) {
                boolean bl = DataClassGen.this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
                return !bl;
            }
        };
        Consumer<DataClass> consumer = new Consumer<DataClass>(){

            @Override
            public void accept(DataClass dc) {
                String path = DataClassGen.this.roomExt.getPath((RoomClass)dc);
                String string = DataClassGen.this.stdExt.getCppHeaderFileName((RoomClass)dc);
                String string2 = String.valueOf(path) + string;
                DataClassGen.this.fileIO.generateFile("generating DataClass header", string2, DataClassGen.this.generateHeaderFile(root, dc));
                String string3 = DataClassGen.this.stdExt.getCppSourceFileName((RoomClass)dc);
                String string4 = String.valueOf(path) + string3;
                DataClassGen.this.fileIO.generateFile("generating DataClass source", string4, DataClassGen.this.generateSourceFile(root, dc));
            }
        };
        IterableExtensions.filter((Iterable)root.getDataClasses(), (Functions.Function1)function1).forEach(consumer);
    }

    public CharSequence generateHeaderFile(Root root, DataClass dc) {
        CharSequence charSequence;
        String string;
        boolean bl;
        CharSequence charSequence2;
        boolean bl2;
        String string2;
        CharSequence charSequence3;
        Object object;
        boolean bl3;
        StringConcatenation stringConcatenation = new StringConcatenation();
        CharSequence charSequence4 = this.stdExt.generateIncludeGuardBegin((RoomClass)dc, "");
        stringConcatenation.append((Object)charSequence4);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"common/etDatatypesCpp.hpp\"");
        stringConcatenation.newLine();
        Object object2 = dc.getBase();
        boolean bl4 = bl3 = object2 != null;
        if (bl3) {
            stringConcatenation.append("#include \"");
            object = this.roomExt.getPath((RoomClass)dc.getBase());
            stringConcatenation.append((String)object);
            charSequence3 = dc.getBase().getName();
            stringConcatenation.append(charSequence3);
            stringConcatenation.append(".h\"");
        }
        stringConcatenation.newLineIfNotEmpty();
        object2 = root.getReferencedDataClasses((RoomClass)dc);
        for (DataClass classes : object2) {
            stringConcatenation.append("#include \"");
            charSequence3 = this.roomExt.getPath((RoomClass)classes);
            stringConcatenation.append(charSequence3);
            string2 = classes.getName();
            stringConcatenation.append(string2);
            stringConcatenation.append(".h\"");
            stringConcatenation.newLineIfNotEmpty();
        }
        object2 = root.getReferencedDataClasses((RoomClass)dc);
        for (DataClass classes_1 : object2) {
            stringConcatenation.append("#include \"");
            charSequence3 = this.roomExt.getPath((RoomClass)classes_1);
            stringConcatenation.append(charSequence3);
            string2 = classes_1.getName();
            stringConcatenation.append(string2);
            stringConcatenation.append(".h\"");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        object2 = this.helpers.userCode(dc.getUserCode1());
        stringConcatenation.append(object2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("using namespace etRuntime; // TODO JH remove");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        String string3 = this.stdExt.generateNamespaceBegin((RoomClass)dc);
        stringConcatenation.append(string3);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("class ");
        object = dc.getName();
        stringConcatenation.append((String)object);
        charSequence3 = dc.getBase();
        boolean bl5 = bl2 = charSequence3 != null;
        if (bl2) {
            stringConcatenation.append(" : public ");
            charSequence2 = dc.getBase().getName();
            stringConcatenation.append(charSequence2);
        }
        stringConcatenation.append(" {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("public:");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        charSequence3 = this.helpers.userCode(dc.getUserCode2());
        stringConcatenation.append((Object)charSequence3, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        CharSequence charSequence5 = this.helpers.attributes((List)dc.getAttributes());
        stringConcatenation.append((Object)charSequence5, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        charSequence2 = this.helpers.attributeSettersGettersImplementation((List)dc.getAttributes(), dc.getName());
        stringConcatenation.append((Object)charSequence2, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        CharSequence charSequence6 = this.helpers.operationsDeclaration((List)dc.getOperations(), dc.getName());
        stringConcatenation.append((Object)charSequence6, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("// default constructor, copy constructor and assignment operator");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        String string4 = dc.getName();
        stringConcatenation.append(string4, "\t");
        stringConcatenation.append("();");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        String string5 = dc.getName();
        stringConcatenation.append(string5, "\t");
        stringConcatenation.append("(const ");
        String string6 = dc.getName();
        stringConcatenation.append(string6, "\t");
        stringConcatenation.append("& rhs);");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("// constructor using fields");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        boolean bl6 = this._roomHelpers.getAllAttributes(dc).isEmpty();
        boolean bl7 = bl = !bl6;
        if (bl) {
            string = dc.getName();
            stringConcatenation.append(string, "\t");
            stringConcatenation.append("(");
            charSequence = this.helpers.constArgList(this._roomHelpers.getAllAttributes(dc));
            stringConcatenation.append(charSequence, "\t");
            stringConcatenation.append(");");
        }
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        String string7 = dc.getName();
        stringConcatenation.append(string7, "\t");
        stringConcatenation.append("& operator=(const ");
        String string8 = dc.getName();
        stringConcatenation.append(string8, "\t");
        stringConcatenation.append("& rhs);");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("};");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        string = this.stdExt.generateNamespaceEnd((RoomClass)dc);
        stringConcatenation.append(string);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        charSequence = this.stdExt.generateIncludeGuardEnd((RoomClass)dc, "");
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    public CharSequence generateSourceFile(Root root, DataClass dc) {
        boolean bl;
        Object object;
        CharSequence charSequence;
        String string;
        boolean bl2;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @author generated by eTrice");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* Source File of DataClass ");
        String string2 = dc.getName();
        stringConcatenation.append(string2, " ");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"");
        String string3 = this.stdExt.getCppHeaderFileName((RoomClass)dc);
        stringConcatenation.append(string3);
        stringConcatenation.append("\"");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"etUnit/etUnit.h\"");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        String string4 = this.stdExt.generateNamespaceBegin((RoomClass)dc);
        stringConcatenation.append(string4);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        CharSequence charSequence2 = this.helpers.userCode(dc.getUserCode3());
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("// default constructor");
        stringConcatenation.newLine();
        String string5 = dc.getName();
        stringConcatenation.append(string5);
        stringConcatenation.append("::");
        String string6 = dc.getName();
        stringConcatenation.append(string6);
        stringConcatenation.append("()");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        CharSequence charSequence3 = this.generateDefaultInitalizerList(dc);
        stringConcatenation.append((Object)charSequence3, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("{");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        CharSequence charSequence4 = this.initHelper.genExtraInitializers((Iterable<Attribute>)dc.getAttributes());
        stringConcatenation.append((Object)charSequence4, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        String string7 = this.helpers.userStructorBody((RoomClass)dc, true);
        stringConcatenation.append(string7, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("// copy constructor");
        stringConcatenation.newLine();
        String string8 = dc.getName();
        stringConcatenation.append(string8);
        stringConcatenation.append("::");
        String string9 = dc.getName();
        stringConcatenation.append(string9);
        stringConcatenation.append("(const ");
        String string10 = dc.getName();
        stringConcatenation.append(string10);
        stringConcatenation.append("& rhs)");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        CharSequence charSequence5 = this.generateCopyInitalizerList(dc);
        stringConcatenation.append((Object)charSequence5, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("{");
        stringConcatenation.newLine();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("// constructor using fields");
        stringConcatenation.newLine();
        stringConcatenation.append("// TODO");
        stringConcatenation.newLine();
        boolean bl3 = this._roomHelpers.getAllAttributes(dc).isEmpty();
        boolean bl4 = bl2 = !bl3;
        if (bl2) {
            string = dc.getName();
            stringConcatenation.append(string);
            stringConcatenation.append("::");
            charSequence = dc.getName();
            stringConcatenation.append(charSequence);
            stringConcatenation.append("(");
            String string11 = this.helpers.constArgList(this._roomHelpers.getAllAttributes(dc));
            stringConcatenation.append(string11);
            stringConcatenation.append(")");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            object = this.generateFieldInitializerList(dc);
            stringConcatenation.append(object, "\t");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("{");
            stringConcatenation.newLine();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
        }
        stringConcatenation.newLine();
        stringConcatenation.append("// assignment operator");
        stringConcatenation.newLine();
        String string12 = dc.getName();
        stringConcatenation.append(string12);
        stringConcatenation.append("& ");
        String string13 = dc.getName();
        stringConcatenation.append(string13);
        stringConcatenation.append("::operator=(const ");
        string = dc.getName();
        stringConcatenation.append(string);
        stringConcatenation.append("& rhs)");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("{");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("if (this == &rhs) { return *this; };");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        charSequence = dc.getBase();
        boolean bl5 = bl = charSequence != null;
        if (bl) {
            object = dc.getBase().getName();
            stringConcatenation.append((String)object, "\t");
            stringConcatenation.append("::operator=(rhs);");
        }
        stringConcatenation.newLineIfNotEmpty();
        charSequence = dc.getAttributes();
        object = charSequence.iterator();
        while (object.hasNext()) {
            Attribute attr = (Attribute)object.next();
            stringConcatenation.append("\t");
            stringConcatenation.append("this->");
            String string14 = attr.getName();
            stringConcatenation.append(string14, "\t");
            stringConcatenation.append(" = rhs.");
            String string15 = attr.getName();
            stringConcatenation.append(string15, "\t");
            stringConcatenation.append(";");
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.append("\t");
        stringConcatenation.append("return *this;");
        stringConcatenation.newLine();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        charSequence = this.helpers.operationsImplementation((List)dc.getOperations(), dc.getName());
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        String string16 = this.stdExt.generateNamespaceEnd((RoomClass)dc);
        stringConcatenation.append(string16);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    private CharSequence generateDefaultInitalizerList(DataClass dataClass) {
        Object object;
        Object object2;
        boolean bl;
        CharSequence charSequence = null;
        final Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList();
        DataClass dataClass2 = dataClass.getBase();
        boolean bl2 = bl = dataClass2 != null;
        if (bl) {
            object2 = dataClass.getBase().getName();
            object = String.valueOf(object2) + "()";
            initList.add(object);
        }
        object2 = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute it) {
                StringConcatenation stringConcatenation = new StringConcatenation();
                String string = it.getName();
                stringConcatenation.append(string);
                stringConcatenation.append("(");
                String string2 = initHelper.getInitializerListValue(it);
                stringConcatenation.append(string2);
                stringConcatenation.append(")");
                return stringConcatenation.toString();
            }
        };
        object = ListExtensions.map((List)dataClass.getAttributes(), (Functions.Function1)object2);
        Iterables.addAll((Collection)initList, (Iterable)object);
        charSequence = initHelper.generateCtorInitializerList(initList);
        return charSequence;
    }

    private CharSequence generateCopyInitalizerList(DataClass dataClass) {
        Object object;
        Object object2;
        boolean bl;
        CharSequence charSequence = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList();
        DataClass dataClass2 = dataClass.getBase();
        boolean bl2 = bl = dataClass2 != null;
        if (bl) {
            object2 = dataClass.getBase().getName();
            object = String.valueOf(object2) + "(rhs)";
            initList.add(object);
        }
        object2 = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute it) {
                StringConcatenation stringConcatenation = new StringConcatenation();
                String string = it.getName();
                stringConcatenation.append(string);
                stringConcatenation.append("(rhs.");
                String string2 = it.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append(")");
                return stringConcatenation.toString();
            }
        };
        object = ListExtensions.map((List)dataClass.getAttributes(), (Functions.Function1)object2);
        Iterables.addAll((Collection)initList, (Iterable)object);
        charSequence = initHelper.generateCtorInitializerList(initList);
        return charSequence;
    }

    private CharSequence generateFieldInitializerList(DataClass dataClass) {
        Object object;
        Object object2;
        boolean bl;
        CharSequence charSequence = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList();
        DataClass dataClass2 = dataClass.getBase();
        boolean bl2 = bl = dataClass2 != null;
        if (bl) {
            object2 = new StringConcatenation();
            object = dataClass.getBase().getName();
            object2.append((String)object);
            object2.append("(");
            Functions.Function1<Attribute, String> function1 = new Functions.Function1<Attribute, String>(){

                public String apply(Attribute it) {
                    return it.getName();
                }
            };
            String string = IterableExtensions.join((Iterable)ListExtensions.map((List)this._roomHelpers.getAllAttributes(dataClass.getBase()), (Functions.Function1)function1), (CharSequence)", ");
            object2.append(string);
            object2.append(")");
            initList.add(object2.toString());
        }
        object2 = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute it) {
                StringConcatenation stringConcatenation = new StringConcatenation();
                String string = it.getName();
                stringConcatenation.append(string);
                stringConcatenation.append("(");
                String string2 = it.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append(")");
                return stringConcatenation.toString();
            }
        };
        object = ListExtensions.map((List)dataClass.getAttributes(), (Functions.Function1)object2);
        Iterables.addAll((Collection)initList, (Iterable)object);
        charSequence = initHelper.generateCtorInitializerList(initList);
        return charSequence;
    }

    public String deepCopy(DataClass _dc) {
        String result = "";
        DataClass dc = _dc;
        while (dc != null) {
            String string;
            String string2 = this.deepCopy((List<Attribute>)dc.getAttributes()).toString();
            result = string = String.valueOf(string2) + result;
            dc = dc.getBase();
        }
        return result;
    }

    public CharSequence deepCopy(List<Attribute> attributes) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        for (Attribute a : attributes) {
            String string;
            String string2;
            int n;
            DataType dataType = a.getType().getType();
            if (dataType instanceof ComplexType) {
                boolean bl;
                stringConcatenation.append("if (");
                String string3 = a.getName();
                stringConcatenation.append(string3);
                stringConcatenation.append("!=null) {");
                stringConcatenation.newLineIfNotEmpty();
                n = a.getSize();
                boolean bl2 = bl = n == 0;
                if (bl) {
                    stringConcatenation.append("\t");
                    stringConcatenation.append("copy.");
                    string2 = a.getName();
                    stringConcatenation.append(string2, "\t");
                    stringConcatenation.append(" = ");
                    string = a.getName();
                    stringConcatenation.append(string, "\t");
                    stringConcatenation.append(".deepCopy();");
                    stringConcatenation.newLineIfNotEmpty();
                } else {
                    stringConcatenation.append("\t");
                    stringConcatenation.append("for (int i=0;i<");
                    string2 = a.getName();
                    stringConcatenation.append(string2, "\t");
                    stringConcatenation.append(".length;i++){");
                    stringConcatenation.newLineIfNotEmpty();
                    stringConcatenation.append("\t");
                    stringConcatenation.append("\t");
                    stringConcatenation.append("copy.");
                    string = a.getName();
                    stringConcatenation.append(string, "\t\t");
                    stringConcatenation.append("[i] = ");
                    String string4 = a.getName();
                    stringConcatenation.append(string4, "\t\t");
                    stringConcatenation.append("[i].deepCopy();");
                    stringConcatenation.newLineIfNotEmpty();
                    stringConcatenation.append("\t");
                    stringConcatenation.append("}");
                    stringConcatenation.newLine();
                }
                stringConcatenation.append("}");
                stringConcatenation.newLine();
                continue;
            }
            int n2 = a.getSize();
            int n3 = n = n2 == 0 ? 1 : 0;
            if (n != 0) {
                stringConcatenation.append("copy.");
                String string5 = a.getName();
                stringConcatenation.append(string5);
                stringConcatenation.append(" = ");
                string2 = a.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append(";");
                stringConcatenation.newLineIfNotEmpty();
                continue;
            }
            stringConcatenation.append("for (int i=0;i<");
            String string6 = a.getName();
            stringConcatenation.append(string6);
            stringConcatenation.append(".length;i++){");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t");
            stringConcatenation.append("copy.");
            string2 = a.getName();
            stringConcatenation.append(string2, "\t");
            stringConcatenation.append("[i] = ");
            string = a.getName();
            stringConcatenation.append(string, "\t");
            stringConcatenation.append("[i];");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("}");
            stringConcatenation.newLine();
        }
        return stringConcatenation;
    }
}

