/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.Wire;
import org.eclipse.etrice.core.genmodel.etricegen.WiredActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.WiredStructureClass;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.ReferenceType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.gen.ConfigGenAddon;
import org.eclipse.etrice.generator.java.gen.Initialization;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.etrice.generator.java.gen.StateMachineGen;
import org.eclipse.etrice.generator.java.setup.GeneratorOptionsHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class ActorClassGen
extends GenericActorClassGenerator {
    @Inject
    protected IGeneratorFileIO fileIO;
    @Inject
    @Extension
    protected JavaExtensions _javaExtensions;
    @Inject
    @Extension
    protected RoomExtensions _roomExtensions;
    @Inject
    protected IDataConfiguration dataConfigExt;
    protected final ConfigGenAddon configGenAddon;
    @Inject
    @Extension
    protected ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    protected Initialization _initialization;
    @Inject
    @Extension
    protected StateMachineGen _stateMachineGen;
    @Inject
    @Extension
    protected TypeHelpers _typeHelpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;

    @Inject
    public ActorClassGen(ConfigGenAddon configGenAddon) {
        this.configGenAddon = configGenAddon;
    }

    public void doGenerate(Root root) {
        HashMap ac2wired = new HashMap();
        Functions.Function1 function1 = w -> w instanceof WiredActorClass;
        Consumer<WiredStructureClass> consumer = w -> ac2wired.put(((WiredActorClass)w).getActorClass(), (WiredActorClass)w);
        IterableExtensions.filter((Iterable)root.getWiredInstances(), (Functions.Function1)function1).forEach(consumer);
        Functions.Function1 function12 = it -> {
            boolean bl = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !bl;
        };
        Functions.Function1 function13 = it -> root.getExpandedActorClass(it);
        Consumer<ExpandedActorClass> consumer2 = xpac -> {
            WiredActorClass wired = (WiredActorClass)ac2wired.get(xpac.getActorClass());
            boolean manualBehavior = this._roomHelpers.isBehaviorAnnotationPresent(xpac.getActorClass(), "BehaviorManual");
            String path = this._roomExtensions.getPath((RoomClass)xpac.getActorClass());
            Object file = this._javaExtensions.getJavaFileName((RoomClass)xpac.getActorClass());
            if (manualBehavior) {
                file = "Abstract" + (String)file;
            }
            this.fileIO.generateFile("generating ActorClass implementation", path + (String)file, this.generate(root, (ExpandedActorClass)xpac, wired, manualBehavior));
        };
        IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)root.getActorClasses(), (Functions.Function1)function12), (Functions.Function1)function13).forEach(consumer2);
    }

    public CharSequence generate(Root root, ExpandedActorClass xpac, WiredActorClass wired, boolean manualBehavior) {
        Object object;
        String string;
        boolean svc_22;
        Object object2;
        String string2;
        String string3;
        String string4;
        String string5;
        Object object3;
        Object object4;
        String string6;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        boolean bl;
        boolean bl2;
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        Object object9 = null;
        if (manualBehavior) {
            String string7 = ac.getName();
            object9 = "Abstract" + string7;
        } else {
            object9 = ac.getName();
        }
        String clsname = object9;
        EList models = root.getReferencedModels((RoomClass)ac);
        String string8 = null;
        boolean bl3 = this._generatorOptionsHelper.isGeneratePersistenceInterface(Main.getSettings());
        string8 = bl3 ? "implements IPersistable " : "";
        String impPersist = string8;
        String string9 = ac.getName();
        String dataObjClass = string9 + "_DataObject";
        String string10 = null;
        ActorClass actorClass = ac.getActorBase();
        boolean bl4 = bl2 = actorClass != null;
        if (bl2) {
            string10 = ac.getActorBase().getName();
        } else {
            boolean bl5;
            String string11 = null;
            boolean bl6 = this._roomHelpers.getAttribute(ac, "ActorBaseClass", "class").isEmpty();
            boolean bl7 = bl5 = !bl6;
            if (bl5) {
                string11 = this._roomHelpers.getAttribute(ac, "ActorBaseClass", "class");
            } else {
                String string12 = null;
                bl = this._generatorOptionsHelper.isGenerateStoreDataObj(Main.getSettings());
                string12 = bl ? "ActorClassFinalActionBase" : "ActorClassBase";
                string11 = string12;
            }
            string10 = string11;
        }
        String baseClass = string10;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("package ");
        String string13 = this._roomExtensions.getPackage((RoomClass)ac);
        stringConcatenation2.append(string13);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        boolean bl8 = this.dataConfigExt.getDynConfigReadAttributes(ac).isEmpty();
        boolean bl9 = bl = !bl8;
        if (bl) {
            stringConcatenation2.append("import org.eclipse.etrice.runtime.java.config.DynConfigLock;");
            stringConcatenation2.newLine();
        }
        if (bl8 = this._generatorOptionsHelper.isGeneratePersistenceInterface(Main.getSettings())) {
            stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.IPersistable;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("import java.io.IOException;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("import java.io.ObjectInput;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("import java.io.ObjectOutput;");
            stringConcatenation2.newLine();
        }
        if (bl8 = this._generatorOptionsHelper.isGenerateStoreDataObj(Main.getSettings())) {
            stringConcatenation2.append("import java.util.Arrays;");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.messaging.*;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.modelbase.*;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("import org.eclipse.etrice.runtime.java.debugging.*;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("import static org.eclipse.etrice.runtime.java.etunit.EtUnit.*;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        for (RoomModel model : models) {
            stringConcatenation2.append("import ");
            object8 = model.getName();
            stringConcatenation2.append((String)object8);
            stringConcatenation2.append(".*;");
            stringConcatenation2.newLineIfNotEmpty();
        }
        Object object10 = root.getReferencedProtocolClasses((RoomClass)ac);
        for (ProtocolClass pc : object10) {
            stringConcatenation2.append("import ");
            object7 = this._roomExtensions.getPackage((RoomClass)pc);
            stringConcatenation2.append((String)object7);
            stringConcatenation2.append(".");
            object6 = pc.getName();
            stringConcatenation2.append((String)object6);
            stringConcatenation2.append(".*;");
            stringConcatenation2.newLineIfNotEmpty();
        }
        object10 = r -> {
            ReferenceType referenceType = r.getRefType();
            return Objects.equal((Object)referenceType, (Object)ReferenceType.OPTIONAL);
        };
        Object object11 = IterableExtensions.filter((Iterable)ac.getActorRefs(), (Functions.Function1)object10);
        object7 = object11.iterator();
        while (object7.hasNext()) {
            ActorRef sub = (ActorRef)object7.next();
            stringConcatenation2.append("import ");
            object6 = this._roomExtensions.getPackage((RoomClass)sub.getType());
            stringConcatenation2.append((String)object6);
            stringConcatenation2.append(".");
            object5 = sub.getType().getName();
            stringConcatenation2.append((String)object5);
            stringConcatenation2.append("Interface;");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        object10 = this._procedureHelpers.userCode((ActorContainerClass)ac, 1, true);
        stringConcatenation2.append(object10);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("public ");
        if (manualBehavior || ac.isAbstract()) {
            stringConcatenation2.append("abstract ");
        }
        stringConcatenation2.append("class ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(" extends ");
        stringConcatenation2.append(baseClass);
        stringConcatenation2.append(" ");
        stringConcatenation2.append(impPersist);
        stringConcatenation2.append("{");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        object11 = this._procedureHelpers.userCode((ActorContainerClass)ac, 2, false);
        stringConcatenation2.append(object11, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("//--------------------- ports");
        stringConcatenation2.newLine();
        object8 = this._roomHelpers.getEndPorts(ac);
        object6 = object8.iterator();
        while (object6.hasNext()) {
            Port ep = (Port)object6.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("protected ");
            object5 = this._roomExtensions.getPortClassName((RoomElement)ep);
            stringConcatenation2.append((String)object5, "\t");
            stringConcatenation2.append(" ");
            string6 = ep.getName();
            stringConcatenation2.append(string6, "\t");
            stringConcatenation2.append(" = null;");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("//--------------------- saps");
        stringConcatenation2.newLine();
        object8 = ac.getServiceAccessPoints();
        object6 = object8.iterator();
        while (object6.hasNext()) {
            SAP sap = (SAP)object6.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("protected ");
            object5 = this._roomExtensions.getPortClassName((RoomElement)sap);
            stringConcatenation2.append((String)object5, "\t");
            stringConcatenation2.append(" ");
            string6 = sap.getName();
            stringConcatenation2.append(string6, "\t");
            stringConcatenation2.append(" = null;");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("//--------------------- services");
        stringConcatenation2.newLine();
        object8 = ac.getServiceImplementations();
        object6 = object8.iterator();
        while (object6.hasNext()) {
            ServiceImplementation svc = (ServiceImplementation)object6.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("protected ");
            object5 = this._roomExtensions.getPortClassName((RoomElement)svc);
            stringConcatenation2.append((String)object5, "\t");
            stringConcatenation2.append(" ");
            string6 = svc.getSpp().getName();
            stringConcatenation2.append(string6, "\t");
            stringConcatenation2.append(" = null;");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("//--------------------- optional actors");
        stringConcatenation2.newLine();
        object8 = r -> {
            ReferenceType referenceType = r.getRefType();
            return Objects.equal((Object)referenceType, (Object)ReferenceType.OPTIONAL);
        };
        object7 = IterableExtensions.filter((Iterable)ac.getActorRefs(), (Functions.Function1)object8);
        object5 = object7.iterator();
        while (object5.hasNext()) {
            boolean bl10;
            ActorRef sub_1 = (ActorRef)object5.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("protected ");
            string6 = sub_1.getType().getName();
            stringConcatenation2.append(string6, "\t");
            int n = sub_1.getMultiplicity();
            boolean bl11 = bl10 = n != 1;
            if (bl10) {
                stringConcatenation2.append("Replicated");
            }
            stringConcatenation2.append("Interface ");
            object4 = sub_1.getName();
            stringConcatenation2.append((String)object4, "\t");
            stringConcatenation2.append(" = null;");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("//--------------------- interface item IDs");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        object8 = this.genInterfaceItemConstants(xpac);
        stringConcatenation2.append((String)object8, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        object7 = this.configGenAddon.genMinMaxConstants(ac);
        stringConcatenation2.append((String)object7, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        object6 = this._procedureHelpers.attributes((List)ac.getAttributes());
        stringConcatenation2.append(object6, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        object5 = this.dataConfigExt.getDynConfigReadAttributes(ac);
        object4 = object5.iterator();
        while (object4.hasNext()) {
            Attribute a = (Attribute)object4.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("private DynConfigLock lock_");
            String string14 = a.getName();
            stringConcatenation2.append(string14, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        object5 = this._procedureHelpers.operationsImplementation((List)ac.getOperations(), ac.getName());
        stringConcatenation2.append(object5, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("//--------------------- construction");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public ");
        stringConcatenation2.append(clsname, "\t");
        stringConcatenation2.append("(IRTObject parent, String name) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("super(parent, name);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("setClassName(\"");
        string6 = ac.getName();
        stringConcatenation2.append(string6, "\t\t");
        stringConcatenation2.append("\");");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        object4 = this._initialization.attributeInitialization((List<Attribute>)ac.getAttributes(), (EObject)ac, false);
        stringConcatenation2.append(object4, "\t\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// own ports");
        stringConcatenation2.newLine();
        Object object12 = this._roomHelpers.getEndPorts(ac);
        Object object13 = object12.iterator();
        while (object13.hasNext()) {
            Port ep_1 = (Port)object13.next();
            stringConcatenation2.append("\t\t");
            object3 = ep_1.getName();
            stringConcatenation2.append((String)object3, "\t\t");
            stringConcatenation2.append(" = new ");
            string5 = this._roomExtensions.getPortClassName((RoomElement)ep_1);
            stringConcatenation2.append(string5, "\t\t");
            stringConcatenation2.append("(this, \"");
            string4 = ep_1.getName();
            stringConcatenation2.append(string4, "\t\t");
            stringConcatenation2.append("\", ");
            string3 = this.getIfItemId((AbstractInterfaceItem)ep_1);
            stringConcatenation2.append(string3, "\t\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// own saps");
        stringConcatenation2.newLine();
        object12 = ac.getServiceAccessPoints();
        object13 = object12.iterator();
        while (object13.hasNext()) {
            SAP sap_1 = (SAP)object13.next();
            stringConcatenation2.append("\t\t");
            object3 = sap_1.getName();
            stringConcatenation2.append((String)object3, "\t\t");
            stringConcatenation2.append(" = new ");
            string5 = this._roomExtensions.getPortClassName((RoomElement)sap_1);
            stringConcatenation2.append(string5, "\t\t");
            stringConcatenation2.append("(this, \"");
            string4 = sap_1.getName();
            stringConcatenation2.append(string4, "\t\t");
            stringConcatenation2.append("\", ");
            string3 = this.getIfItemId((AbstractInterfaceItem)sap_1);
            stringConcatenation2.append(string3, "\t\t");
            stringConcatenation2.append(", 0);");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// own service implementations");
        stringConcatenation2.newLine();
        object12 = ac.getServiceImplementations();
        object13 = object12.iterator();
        while (object13.hasNext()) {
            ServiceImplementation svc_1 = (ServiceImplementation)object13.next();
            stringConcatenation2.append("\t\t");
            object3 = svc_1.getSpp().getName();
            stringConcatenation2.append((String)object3, "\t\t");
            stringConcatenation2.append(" = new ");
            string5 = this._roomExtensions.getPortClassName((RoomElement)svc_1);
            stringConcatenation2.append(string5, "\t\t");
            stringConcatenation2.append("(this, \"");
            string4 = svc_1.getSpp().getName();
            stringConcatenation2.append(string4, "\t\t");
            stringConcatenation2.append("\", ");
            string3 = this.getIfItemId((AbstractInterfaceItem)svc_1.getSpp());
            stringConcatenation2.append(string3, "\t\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// sub actors");
        stringConcatenation2.newLine();
        object12 = ac.getActorRefs();
        object13 = object12.iterator();
        while (object13.hasNext()) {
            boolean bl12;
            boolean bl13;
            ActorRef sub_2 = (ActorRef)object13.next();
            object3 = sub_2.getRefType();
            boolean bl14 = Objects.equal((Object)object3, (Object)ReferenceType.OPTIONAL);
            if (bl14) {
                stringConcatenation2.append("\t\t");
                String string15 = sub_2.getName();
                stringConcatenation2.append(string15, "\t\t");
                stringConcatenation2.append(" = new ");
                String string16 = sub_2.getType().getName();
                stringConcatenation2.append(string16, "\t\t");
                int n = sub_2.getMultiplicity();
                boolean bl15 = bl13 = n != 1;
                if (bl13) {
                    stringConcatenation2.append("Replicated");
                }
                stringConcatenation2.append("Interface(this, \"");
                String string17 = sub_2.getName();
                stringConcatenation2.append(string17, "\t\t");
                stringConcatenation2.append("\");");
                stringConcatenation2.newLineIfNotEmpty();
                continue;
            }
            int n = sub_2.getMultiplicity();
            boolean bl16 = bl12 = n > 1;
            if (bl12) {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("for (int i=0; i<");
                int n2 = sub_2.getMultiplicity();
                stringConcatenation2.append((Object)n2, "\t\t");
                stringConcatenation2.append("; ++i) {");
                stringConcatenation2.newLineIfNotEmpty();
                bl13 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
                if (bl13) {
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("DebuggingService.getInstance().addMessageActorCreate(this, \"");
                    string2 = sub_2.getName();
                    stringConcatenation2.append(string2, "\t\t\t");
                    stringConcatenation2.append((Object)Character.valueOf(':'), "\t\t\t");
                    stringConcatenation2.append("\"+i);");
                    stringConcatenation2.newLineIfNotEmpty();
                }
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("new ");
                String string18 = sub_2.getType().getName();
                stringConcatenation2.append(string18, "\t\t\t");
                stringConcatenation2.append("(this, \"");
                string2 = sub_2.getName();
                stringConcatenation2.append(string2, "\t\t\t");
                stringConcatenation2.append((Object)Character.valueOf(':'), "\t\t\t");
                stringConcatenation2.append("\"+i);");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                continue;
            }
            boolean bl17 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (bl17) {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("DebuggingService.getInstance().addMessageActorCreate(this, \"");
                String string19 = sub_2.getName();
                stringConcatenation2.append(string19, "\t\t");
                stringConcatenation2.append("\");");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("new ");
            String string20 = sub_2.getType().getName();
            stringConcatenation2.append(string20, "\t\t");
            stringConcatenation2.append("(this, \"");
            String string21 = sub_2.getName();
            stringConcatenation2.append(string21, "\t\t");
            stringConcatenation2.append("\");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// wiring");
        stringConcatenation2.newLine();
        object12 = wired.getWires();
        object13 = object12.iterator();
        while (object13.hasNext()) {
            Wire wire = (Wire)object13.next();
            stringConcatenation2.append("\t\t");
            object3 = null;
            boolean bl18 = wire.isDataDriven();
            object3 = bl18 ? "DataPortBase" : "InterfaceItemBase";
            stringConcatenation2.append((String)object3, "\t\t");
            stringConcatenation2.append(".connect(this, \"");
            String string22 = IterableExtensions.join((Iterable)wire.getPath1(), (CharSequence)"/");
            stringConcatenation2.append(string22, "\t\t");
            stringConcatenation2.append("\", \"");
            String string23 = IterableExtensions.join((Iterable)wire.getPath2(), (CharSequence)"/");
            stringConcatenation2.append(string23, "\t\t");
            stringConcatenation2.append("\");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        if (Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS) || Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN)) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("// activate polling for data-driven communication");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("RTServices.getInstance().getMsgSvcCtrl().getMsgSvc(getThread()).addPollingMessageReceiver(this);");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        object12 = this._procedureHelpers.userStructorBody((RoomClass)ac, true);
        stringConcatenation2.append((String)object12, "\t\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        if (!this.dataConfigExt.getDynConfigReadAttributes(ac).isEmpty() || !this.dataConfigExt.getDynConfigWriteAttributes(ac).isEmpty()) {
            object2 = this.dataConfigExt.getDynConfigReadAttributes(ac);
            object3 = object2.iterator();
            while (object3.hasNext()) {
                Attribute a_1 = (Attribute)object3.next();
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("lock_");
                String string24 = a_1.getName();
                stringConcatenation2.append(string24, "\t\t");
                stringConcatenation2.append(" = new DynConfigLock();");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        object2 = this._procedureHelpers.attributeSettersGettersImplementation(this._roomExtensions.minus((List)ac.getAttributes(), this.dataConfigExt.getDynConfigReadAttributes(ac)), ac.getName());
        stringConcatenation2.append(object2, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        object13 = this.configGenAddon.genDynConfigGetterSetter(ac);
        stringConcatenation2.append(object13, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("//--------------------- port getters");
        stringConcatenation2.newLine();
        object3 = this._roomHelpers.getEndPorts(ac);
        Object object14 = object3.iterator();
        while (object14.hasNext()) {
            Port ep_2 = (Port)object14.next();
            stringConcatenation2.append("\t");
            CharSequence charSequence = this._procedureHelpers.getterImplementation(this._roomExtensions.getPortClassName((RoomElement)ep_2), ep_2.getName(), ac.getName());
            stringConcatenation2.append((Object)charSequence, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        object3 = ac.getServiceAccessPoints();
        object14 = object3.iterator();
        while (object14.hasNext()) {
            SAP sap_2 = (SAP)object14.next();
            stringConcatenation2.append("\t");
            CharSequence charSequence = this._procedureHelpers.getterImplementation(this._roomExtensions.getPortClassName((RoomElement)sap_2), sap_2.getName(), ac.getName());
            stringConcatenation2.append((Object)charSequence, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        object3 = ac.getServiceImplementations();
        object14 = object3.iterator();
        while (object14.hasNext()) {
            ServiceImplementation svc_22 = (ServiceImplementation)object14.next();
            stringConcatenation2.append("\t");
            CharSequence charSequence = this._procedureHelpers.getterImplementation(this._roomExtensions.getPortClassName((RoomElement)svc_22), svc_22.getSpp().getName(), ac.getName());
            stringConcatenation2.append((Object)charSequence, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("//--------------------- lifecycle functions");
        stringConcatenation2.newLine();
        boolean bl19 = this._roomExtensions.overridesStop(ac);
        boolean bl20 = svc_22 = !bl19;
        if (svc_22) {
            if (manualBehavior) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("public abstract void stop();");
                stringConcatenation2.newLine();
            } else {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("public void stop(){");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("super.stop();");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
        }
        stringConcatenation2.newLine();
        if (manualBehavior) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("public abstract void destroy();");
            stringConcatenation2.newLine();
        } else {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("public void destroy(){");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            String string25 = this._procedureHelpers.userStructorBody((RoomClass)ac, false);
            stringConcatenation2.append(string25, "\t\t");
            stringConcatenation2.newLineIfNotEmpty();
            svc_22 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (svc_22) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("DebuggingService.getInstance().addMessageActorDestroy(this);");
                stringConcatenation2.newLine();
            }
            if (Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS) || Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN)) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("RTServices.getInstance().getMsgSvcCtrl().getMsgSvc(getThread()).removePollingMessageReceiver(this);");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("super.destroy();");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        if (manualBehavior) {
            Object object15;
            stringConcatenation2.append("\t");
            stringConcatenation2.append("public void receiveEvent(InterfaceItemBase ifitem, int evt, Object generic_data) {");
            stringConcatenation2.newLine();
            List list = this._roomHelpers.getAllInterfaceItems(ac);
            svc_22 = false;
            for (InterfaceItem ifitem : list) {
                if (!svc_22) {
                    svc_22 = true;
                } else {
                    stringConcatenation2.appendImmediate((Object)"else ", "\t\t");
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("if (ifitem==");
                String string26 = ifitem.getName();
                stringConcatenation2.append(string26, "\t\t");
                stringConcatenation2.append(") {");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("switch (evt) {");
                stringConcatenation2.newLine();
                List list2 = this._roomHelpers.getIncoming(ifitem);
                for (Message msg : list2) {
                    boolean bl21;
                    String string27;
                    boolean bl22;
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("case ");
                    object15 = this._roomHelpers.getProtocolClass((EObject)msg).getName();
                    stringConcatenation2.append((String)object15, "\t\t\t\t");
                    stringConcatenation2.append(".");
                    String string28 = null;
                    boolean bl23 = this._roomExtensions.isIncoming(msg);
                    string28 = bl23 ? "IN_" : "OUT_";
                    stringConcatenation2.append(string28, "\t\t\t\t");
                    string = msg.getName();
                    stringConcatenation2.append(string, "\t\t\t\t");
                    stringConcatenation2.append(":");
                    stringConcatenation2.newLineIfNotEmpty();
                    object = msg.getData();
                    boolean bl24 = bl22 = object != null;
                    if (bl22) {
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("{");
                        string27 = this._javaExtensions.getTypedDataDefinition((EObject)msg);
                        stringConcatenation2.append(string27, "\t\t\t\t\t");
                        stringConcatenation2.newLineIfNotEmpty();
                    }
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("on_");
                    object = ifitem.getName();
                    stringConcatenation2.append((String)object, "\t\t\t\t\t");
                    stringConcatenation2.append("_");
                    String string29 = msg.getName();
                    stringConcatenation2.append(string29, "\t\t\t\t\t");
                    stringConcatenation2.append("(ifitem");
                    string27 = msg.getData();
                    boolean bl25 = bl21 = string27 != null;
                    if (bl21) {
                        stringConcatenation2.append(", ");
                        stringConcatenation2.append("transitionData", "\t\t\t\t\t");
                    }
                    stringConcatenation2.append(");");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("break;");
                    stringConcatenation2.newLine();
                    string27 = msg.getData();
                    boolean bl26 = bl21 = string27 != null;
                    if (!bl21) continue;
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("}");
                    stringConcatenation2.newLine();
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            list = this._roomHelpers.getAllInterfaceItems(ac);
            for (InterfaceItem ifitem_1 : list) {
                List list3 = this._roomHelpers.getIncoming(ifitem_1);
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    boolean bl27;
                    Message msg_1 = (Message)iterator.next();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("protected void on_");
                    string2 = ifitem_1.getName();
                    stringConcatenation2.append(string2, "\t");
                    stringConcatenation2.append("_");
                    String string30 = msg_1.getName();
                    stringConcatenation2.append(string30, "\t");
                    stringConcatenation2.append("(InterfaceItemBase ifitem");
                    object15 = msg_1.getData();
                    boolean bl28 = bl27 = object15 != null;
                    if (bl27) {
                        String string31 = this._javaExtensions.generateArglistAndTypedData((EObject)msg_1.getData())[2];
                        stringConcatenation2.append(string31, "\t");
                    }
                    stringConcatenation2.append(") {}");
                    stringConcatenation2.newLineIfNotEmpty();
                }
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("public abstract void executeInitTransition();");
            stringConcatenation2.newLine();
        } else {
            boolean bl29 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac);
            if (bl29) {
                stringConcatenation2.append("\t");
                CharSequence charSequence = this._stateMachineGen.genStateMachine(xpac.getGraphContainer());
                stringConcatenation2.append((Object)charSequence, "\t");
                stringConcatenation2.newLineIfNotEmpty();
                object14 = ac.getCommType();
                boolean bl30 = Objects.equal((Object)object14, (Object)ComponentCommunicationType.DATA_DRIVEN);
                if (bl30) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("public void receiveEvent(InterfaceItemBase ifitem, int evt, Object generic_data) {");
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("handleSystemEvent(ifitem, evt, generic_data);");
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("}");
                    stringConcatenation2.newLine();
                }
                if (Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.ASYNCHRONOUS) || Objects.equal((Object)ac.getCommType(), (Object)ComponentCommunicationType.DATA_DRIVEN)) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("@Override");
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("public void receive(Message msg) {");
                    stringConcatenation2.newLine();
                    object14 = ac.getCommType();
                    bl30 = Objects.equal((Object)object14, (Object)ComponentCommunicationType.ASYNCHRONOUS);
                    if (bl30) {
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("receiveEvent(null, -1, null);");
                        stringConcatenation2.newLine();
                    } else {
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("receiveEventInternal();");
                        stringConcatenation2.newLine();
                    }
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("}");
                    stringConcatenation2.newLine();
                }
            } else {
                boolean bl31 = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
                if (bl31) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("//--------------------- no state machine");
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("public void receiveEvent(InterfaceItemBase ifitem, int evt, Object data) {");
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("handleSystemEvent(ifitem, evt, data);");
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("}");
                    stringConcatenation2.newLine();
                    stringConcatenation2.newLine();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("public void executeInitTransition() {}");
                    stringConcatenation2.newLine();
                }
            }
        }
        stringConcatenation2.newLine();
        boolean bl32 = this._generatorOptionsHelper.isGeneratePersistenceInterface(Main.getSettings());
        if (bl32) {
            boolean bl33;
            boolean bl34;
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("@Override");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("public void saveObject(ObjectOutput output) throws IOException {");
            stringConcatenation2.newLine();
            boolean bl35 = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
            boolean bl36 = bl34 = !bl35;
            if (bl34) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("// state and history");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("output.writeInt(getState());");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("for (int h: history) output.writeInt(h);");
                stringConcatenation2.newLine();
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("saveAttributes(output);");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("protected void saveAttributes(ObjectOutput output) throws IOException {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            CharSequence charSequence = this.genSaveImpl(xpac);
            stringConcatenation2.append((Object)charSequence, "\t\t");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("@Override");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("public void loadObject(ObjectInput input) throws IOException, ClassNotFoundException {");
            stringConcatenation2.newLine();
            bl34 = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
            boolean bl37 = bl33 = !bl34;
            if (bl33) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("// state and history");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("setState(input.readInt());");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("for (int i=0; i<history.length; ++i) history[i] = input.readInt();");
                stringConcatenation2.newLine();
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("loadAttributes(input);");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("protected void loadAttributes(ObjectInput input) throws IOException, ClassNotFoundException {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            object14 = this.genLoadImpl(xpac);
            stringConcatenation2.append(object14, "\t\t");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        if (bl32 = this._generatorOptionsHelper.isGenerateStoreDataObj(Main.getSettings())) {
            boolean bl38;
            boolean bl39;
            boolean bl40;
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("protected void store(IActorClassDataObject obj) {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("if (!(obj instanceof ");
            stringConcatenation2.append(dataObjClass, "\t\t");
            stringConcatenation2.append("))");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("return;");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append(dataObjClass, "\t\t");
            stringConcatenation2.append(" dataObject = (");
            stringConcatenation2.append(dataObjClass, "\t\t");
            stringConcatenation2.append(") obj;");
            stringConcatenation2.newLineIfNotEmpty();
            ActorClass actorClass2 = ac.getActorBase();
            boolean bl41 = bl40 = actorClass2 != null;
            if (bl40) {
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("super.store(dataObject);");
                stringConcatenation2.newLine();
            }
            if (bl39 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac)) {
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("dataObject.setState(getState());");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("dataObject.setHistory(Arrays.copyOf(history, history.length));");
                stringConcatenation2.newLine();
            }
            boolean bl42 = bl40 = !(bl39 = ac.getAttributes().isEmpty());
            if (bl40) {
                stringConcatenation2.newLine();
                EList eList = ac.getAttributes();
                for (Attribute att : eList) {
                    boolean bl43;
                    boolean bl44 = this._typeHelpers.isEnumerationOrPrimitive(att.getType().getType());
                    if (bl44) {
                        boolean bl45;
                        int n = att.getSize();
                        boolean bl46 = bl45 = n > 1;
                        if (bl45) {
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("dataObject.set");
                            String string32 = StringExtensions.toFirstUpper((String)att.getName());
                            stringConcatenation2.append(string32, "\t\t");
                            stringConcatenation2.append("(Arrays.copyOf(");
                            String string33 = att.getName();
                            stringConcatenation2.append(string33, "\t\t");
                            stringConcatenation2.append(", ");
                            string = att.getName();
                            stringConcatenation2.append(string, "\t\t");
                            stringConcatenation2.append(".length));");
                            stringConcatenation2.newLineIfNotEmpty();
                            continue;
                        }
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("dataObject.set");
                        String string34 = StringExtensions.toFirstUpper((String)att.getName());
                        stringConcatenation2.append(string34, "\t\t");
                        stringConcatenation2.append("(");
                        String string35 = att.getName();
                        stringConcatenation2.append(string35, "\t\t");
                        stringConcatenation2.append(");");
                        stringConcatenation2.newLineIfNotEmpty();
                        continue;
                    }
                    int n = att.getSize();
                    boolean bl47 = bl43 = n > 1;
                    if (bl43) {
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("{");
                        stringConcatenation2.newLine();
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        String string36 = att.getType().getType().getName();
                        stringConcatenation2.append(string36, "\t\t\t");
                        stringConcatenation2.append("[] arr = Arrays.copyOf(");
                        String string37 = att.getName();
                        stringConcatenation2.append(string37, "\t\t\t");
                        stringConcatenation2.append(", ");
                        string = att.getName();
                        stringConcatenation2.append(string, "\t\t\t");
                        stringConcatenation2.append(".length);");
                        stringConcatenation2.newLineIfNotEmpty();
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("for(int i=0; i<arr.length; ++i) arr[i] = arr[i].deepCopy();");
                        stringConcatenation2.newLine();
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("dataObject.set");
                        object = StringExtensions.toFirstUpper((String)att.getName());
                        stringConcatenation2.append((String)object, "\t\t\t");
                        stringConcatenation2.append("(arr);");
                        stringConcatenation2.newLineIfNotEmpty();
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("}");
                        stringConcatenation2.newLine();
                        continue;
                    }
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("dataObject.set");
                    String string38 = StringExtensions.toFirstUpper((String)att.getName());
                    stringConcatenation2.append(string38, "\t\t");
                    stringConcatenation2.append("(");
                    String string39 = att.getName();
                    stringConcatenation2.append(string39, "\t\t");
                    stringConcatenation2.append(".deepCopy());");
                    stringConcatenation2.newLineIfNotEmpty();
                }
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("protected void restore(IActorClassDataObject obj) {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("if (!(obj instanceof ");
            stringConcatenation2.append(dataObjClass, "\t\t");
            stringConcatenation2.append("))");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("return;");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append(dataObjClass, "\t\t");
            stringConcatenation2.append(" dataObject = (");
            stringConcatenation2.append(dataObjClass, "\t\t");
            stringConcatenation2.append(") obj;");
            stringConcatenation2.newLineIfNotEmpty();
            ActorClass actorClass3 = ac.getActorBase();
            boolean bl48 = bl40 = actorClass3 != null;
            if (bl40) {
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("super.restore(dataObject);");
                stringConcatenation2.newLine();
            }
            if (bl38 = this._roomHelpers.hasNonEmptyStateMachine((ModelComponent)ac)) {
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("setState(dataObject.getState());");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("history = Arrays.copyOf(dataObject.getHistory(), dataObject.getHistory().length);");
                stringConcatenation2.newLine();
            }
            boolean bl49 = bl40 = !(bl38 = ac.getAttributes().isEmpty());
            if (bl40) {
                stringConcatenation2.newLine();
                EList eList = ac.getAttributes();
                for (Attribute att_1 : eList) {
                    boolean bl50;
                    boolean bl51 = this._typeHelpers.isEnumerationOrPrimitive(att_1.getType().getType());
                    if (bl51) {
                        boolean bl52;
                        int n = att_1.getSize();
                        boolean bl53 = bl52 = n > 1;
                        if (bl52) {
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("\t");
                            stringConcatenation2.append("set");
                            String string40 = StringExtensions.toFirstUpper((String)att_1.getName());
                            stringConcatenation2.append(string40, "\t\t");
                            stringConcatenation2.append("(Arrays.copyOf(dataObject.get");
                            String string41 = StringExtensions.toFirstUpper((String)att_1.getName());
                            stringConcatenation2.append(string41, "\t\t");
                            stringConcatenation2.append("(), ");
                            string = att_1.getName();
                            stringConcatenation2.append(string, "\t\t");
                            stringConcatenation2.append(".length));");
                            stringConcatenation2.newLineIfNotEmpty();
                            continue;
                        }
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("set");
                        String string42 = StringExtensions.toFirstUpper((String)att_1.getName());
                        stringConcatenation2.append(string42, "\t\t");
                        stringConcatenation2.append("(dataObject.get");
                        String string43 = StringExtensions.toFirstUpper((String)att_1.getName());
                        stringConcatenation2.append(string43, "\t\t");
                        stringConcatenation2.append("());");
                        stringConcatenation2.newLineIfNotEmpty();
                        continue;
                    }
                    int n = att_1.getSize();
                    boolean bl54 = bl50 = n > 1;
                    if (bl50) {
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("{");
                        stringConcatenation2.newLine();
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        String string44 = att_1.getType().getType().getName();
                        stringConcatenation2.append(string44, "\t\t\t");
                        stringConcatenation2.append("[] arr = Arrays.copyOf(dataObject.get");
                        String string45 = StringExtensions.toFirstUpper((String)att_1.getName());
                        stringConcatenation2.append(string45, "\t\t\t");
                        stringConcatenation2.append("(), ");
                        string = att_1.getName();
                        stringConcatenation2.append(string, "\t\t\t");
                        stringConcatenation2.append(".length);");
                        stringConcatenation2.newLineIfNotEmpty();
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("for(int i=0; i<arr.length; ++i) arr[i] = arr[i].deepCopy();");
                        stringConcatenation2.newLine();
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("set");
                        object = StringExtensions.toFirstUpper((String)att_1.getName());
                        stringConcatenation2.append((String)object, "\t\t\t");
                        stringConcatenation2.append("(arr);");
                        stringConcatenation2.newLineIfNotEmpty();
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("\t");
                        stringConcatenation2.append("}");
                        stringConcatenation2.newLine();
                        continue;
                    }
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("set");
                    String string46 = StringExtensions.toFirstUpper((String)att_1.getName());
                    stringConcatenation2.append(string46, "\t\t");
                    stringConcatenation2.append("(dataObject.get");
                    String string47 = StringExtensions.toFirstUpper((String)att_1.getName());
                    stringConcatenation2.append(string47, "\t\t");
                    stringConcatenation2.append("().deepCopy());");
                    stringConcatenation2.newLineIfNotEmpty();
                }
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("protected ");
            stringConcatenation2.append(dataObjClass, "\t");
            stringConcatenation2.append(" newDataObject() {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("return new ");
            stringConcatenation2.append(dataObjClass, "\t\t");
            stringConcatenation2.append("();");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence genSaveImpl(ExpandedActorClass xpac) {
        boolean bl;
        boolean bl2;
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        ActorClass actorClass = ac.getActorBase();
        boolean bl3 = bl2 = actorClass != null;
        if (bl2) {
            stringConcatenation2.append("super.saveAttributes(output);");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
        }
        boolean bl4 = bl2 = !(bl = ac.getAttributes().isEmpty());
        if (bl2) {
            EList eList = ac.getAttributes();
            for (Attribute att : eList) {
                String string;
                boolean bl5;
                boolean bl6 = this._typeHelpers.isEnumerationOrPrimitive(att.getType().getType());
                if (bl6) {
                    String string2 = this.genSavePrimitive(att);
                    stringConcatenation2.append(string2);
                    stringConcatenation2.newLineIfNotEmpty();
                    continue;
                }
                int n = att.getSize();
                boolean bl7 = bl5 = n > 1;
                if (bl5) {
                    stringConcatenation2.append("for (");
                    string = att.getType().getType().getName();
                    stringConcatenation2.append(string);
                    stringConcatenation2.append(" v: ");
                    String string3 = att.getName();
                    stringConcatenation2.append(string3);
                    stringConcatenation2.append(") output.writeObject(v);");
                    stringConcatenation2.newLineIfNotEmpty();
                    continue;
                }
                stringConcatenation2.append("output.writeObject(");
                string = att.getName();
                stringConcatenation2.append(string);
                stringConcatenation2.append(");");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence genLoadImpl(ExpandedActorClass xpac) {
        boolean bl;
        boolean bl2;
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        ActorClass actorClass = ac.getActorBase();
        boolean bl3 = bl2 = actorClass != null;
        if (bl2) {
            stringConcatenation2.append("super.loadAttributes(input);");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
        }
        boolean bl4 = bl2 = !(bl = ac.getAttributes().isEmpty());
        if (bl2) {
            EList eList = ac.getAttributes();
            for (Attribute att : eList) {
                String string;
                String string2;
                boolean bl5;
                boolean bl6 = this._typeHelpers.isEnumerationOrPrimitive(att.getType().getType());
                if (bl6) {
                    String string3 = this.genLoadPrimitive(att);
                    stringConcatenation2.append(string3);
                    stringConcatenation2.newLineIfNotEmpty();
                    continue;
                }
                int n = att.getSize();
                boolean bl7 = bl5 = n > 1;
                if (bl5) {
                    stringConcatenation2.append("for (int i=0; i< ");
                    string2 = att.getName();
                    stringConcatenation2.append(string2);
                    stringConcatenation2.append(".length; ++i) ");
                    string = att.getName();
                    stringConcatenation2.append(string);
                    stringConcatenation2.append("[i] = (");
                    String string4 = att.getType().getType().getName();
                    stringConcatenation2.append(string4);
                    stringConcatenation2.append(") input.readObject();");
                    stringConcatenation2.newLineIfNotEmpty();
                    continue;
                }
                string2 = att.getName();
                stringConcatenation2.append(string2);
                stringConcatenation2.append(" = (");
                string = att.getType().getType().getName();
                stringConcatenation2.append(string);
                stringConcatenation2.append(") input.readObject();");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String genSavePrimitive(Attribute att) {
        boolean bl;
        String string = null;
        String string2 = null;
        string2 = att.getType().getType() instanceof EnumerationType && ((EnumerationType)att.getType().getType()).getPrimitiveType() == null ? "int" : this._typeHelpers.typeName(att.getType().getType());
        String type = string2;
        String method = this.getSaveMethod(type);
        String string3 = null;
        int n = att.getSize();
        boolean bl2 = bl = n > 0;
        if (bl) {
            String string4 = att.getName();
            String string5 = "for (" + type + " v: " + string4;
            String string6 = string5 + ") output.";
            String string7 = string6 + method;
            string3 = string7 + "(v);";
        } else {
            String string8 = att.getName();
            String string9 = "output." + method + "(" + string8;
            string3 = string9 + ");";
        }
        string = string3;
        return string;
    }

    private String getSaveMethod(String type) {
        String string;
        block31: {
            string = null;
            if (type == null) break block31;
            switch (type) {
                case "boolean": {
                    string = "writeBoolean";
                    break;
                }
                case "char": {
                    string = "writeChar";
                    break;
                }
                case "byte": {
                    string = "writeByte";
                    break;
                }
                case "short": {
                    string = "writeShort";
                    break;
                }
                case "int": {
                    string = "write";
                    break;
                }
                case "long": {
                    string = "writeLong";
                    break;
                }
                case "float": {
                    string = "writeFloat";
                    break;
                }
                case "double": {
                    string = "writeDouble";
                    break;
                }
                case "String": {
                    string = "writeUTF";
                }
            }
        }
        return string;
    }

    private String genLoadPrimitive(Attribute att) {
        boolean bl;
        String string = null;
        String string2 = null;
        string2 = att.getType().getType() instanceof EnumerationType && ((EnumerationType)att.getType().getType()).getPrimitiveType() == null ? "int" : this._typeHelpers.typeName(att.getType().getType());
        String type = string2;
        String method = this.getLoadMethod(type);
        String string3 = null;
        int n = att.getSize();
        boolean bl2 = bl = n > 0;
        if (bl) {
            String string4 = att.getName();
            String string5 = "for (int i=0; i<" + string4;
            String string6 = string5 + ".length; ++i) ";
            String string7 = att.getName();
            String string8 = string6 + string7;
            String string9 = string8 + "[i] = input.";
            String string10 = string9 + method;
            string3 = string10 + "();";
        } else {
            String string11 = att.getName();
            String string12 = string11 + " = input.";
            String string13 = string12 + method;
            string3 = string13 + "();";
        }
        string = string3;
        return string;
    }

    private String getLoadMethod(String type) {
        String string;
        block31: {
            string = null;
            if (type == null) break block31;
            switch (type) {
                case "boolean": {
                    string = "readBoolean";
                    break;
                }
                case "char": {
                    string = "readChar";
                    break;
                }
                case "byte": {
                    string = "readByte";
                    break;
                }
                case "short": {
                    string = "readShort";
                    break;
                }
                case "int": {
                    string = "read";
                    break;
                }
                case "long": {
                    string = "readLong";
                    break;
                }
                case "float": {
                    string = "readFloat";
                    break;
                }
                case "double": {
                    string = "readDouble";
                    break;
                }
                case "String": {
                    string = "readUTF";
                }
            }
        }
        return string;
    }
}

