/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.meta.features;

import org.eclipse.fmc.blockdiagram.editor.features.TextDirectEditingFeature;
import org.eclipse.fmc.blockdiagram.editor.meta.features.TextDirectEditingVisitor;
import org.eclipse.fmc.blockdiagram.editor.meta.profile.IStereotypeProvider;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.fmc.mm.FMCElement;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class TextDirectEditingMetaFeature
extends TextDirectEditingFeature {
    private IStereotypeProvider stereotypeProvider;

    public TextDirectEditingMetaFeature(IFeatureProvider fp, IStereotypeProvider stereotypeProvider) {
        super(fp);
        this.stereotypeProvider = stereotypeProvider;
    }

    public void setValue(String value, IDirectEditingContext context) {
        FMCElement element = (FMCElement)FMCUtil.getBO((PictogramElement)context.getPictogramElement());
        TextDirectEditingVisitor visitor = new TextDirectEditingVisitor(context);
        visitor.visit(element, value);
        if (this.stereotypeProvider != null) {
            value = String.valueOf(this.stereotypeProvider.getStereotypeText(element)) + value;
        }
        super.setValue(value, context);
    }

    public String getInitialValue(IDirectEditingContext context) {
        AbstractText text = this.getText(context);
        if (text != null) {
            String value = text.getValue();
            if (this.stereotypeProvider != null) {
                value = FMCUtil.substringStereotype((String)value);
            }
            return value;
        }
        return "";
    }
}

