/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.algorithm.node;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.AnchoredNode;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.ContainerNode;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.MultipleNode;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.NamedNode;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.ResizableNode;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.CompositeConnection;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.CurvedConnection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public abstract class AbstractNode
implements AnchoredNode,
MultipleNode,
NamedNode,
ResizableNode,
ContainerNode {
    protected IGaService ga = Graphiti.getGaService();
    protected IPeService pe = Graphiti.getPeService();
    protected int textMargin = 0;

    @Override
    public void setBoxAnchorsVisible(Shape shape, boolean visible) {
        for (Anchor anchor : shape.getAnchors()) {
            if (!(anchor instanceof BoxRelativeAnchor)) continue;
            anchor.getGraphicsAlgorithm().setFilled(Boolean.valueOf(visible));
            anchor.getGraphicsAlgorithm().setLineVisible(Boolean.valueOf(visible));
        }
    }

    @Override
    public boolean isBoxAnchorsVisible(Shape shape) {
        for (Anchor anchor : shape.getAnchors()) {
            if (!(anchor instanceof BoxRelativeAnchor)) continue;
            return anchor.getGraphicsAlgorithm().getLineVisible();
        }
        return false;
    }

    @Override
    public void resizeBoxAnchorSet(ContainerShape container, int x, int y, int width, int height) {
        this.createBoxAnchorSet((Shape)container);
    }

    @Override
    public void createBoxAnchorSet(Shape shape) {
        boolean isAnchorsVisible = this.isBoxAnchorsVisible(shape);
        FMCUtil.removeObsoleteAnchors(shape);
        this.addBoxAnchorSet(shape);
        this.setBoxAnchorsVisible(shape, isAnchorsVisible);
    }

    @Override
    public void removeUnusedBoxAnchors(Shape shape) {
        FMCUtil.removeObsoleteAnchors(shape);
    }

    @Override
    public boolean hasUnusedAnchors(Shape shape) {
        for (Anchor anchor : new HashSet(shape.getAnchors())) {
            if (!(anchor instanceof BoxRelativeAnchor) || !anchor.getIncomingConnections().isEmpty() || !anchor.getOutgoingConnections().isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected abstract void addBoxAnchorSet(Shape var1);

    public BoxRelativeAnchor createBoxAnchor(Shape shape, double rw, double rh, int w, int h) {
        BoxRelativeAnchor boxRelativeAnchor = this.pe.createBoxRelativeAnchor((AnchorContainer)shape);
        boxRelativeAnchor.setRelativeWidth(rw);
        boxRelativeAnchor.setRelativeHeight(rh);
        boxRelativeAnchor.setReferencedGraphicsAlgorithm(shape.getGraphicsAlgorithm());
        Ellipse ellipse = this.ga.createEllipse((GraphicsAlgorithmContainer)boxRelativeAnchor);
        ellipse.setBackground(this.ga.manageColor(this.pe.getDiagramForPictogramElement((PictogramElement)shape), 195, 195, 240));
        ellipse.setTransparency(Double.valueOf(0.3));
        ellipse.setLineVisible(Boolean.valueOf(false));
        ellipse.setFilled(Boolean.valueOf(false));
        this.ga.setLocationAndSize((GraphicsAlgorithm)ellipse, 0, 0, w, h);
        return boxRelativeAnchor;
    }

    @Override
    public void setMultipleInstances(ContainerShape container, IFeatureProvider provider, boolean multipleInstances) {
        if (multipleInstances) {
            GraphicsAlgorithm mainShapeGa = (GraphicsAlgorithm)container.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
            this.resize(mainShapeGa, mainShapeGa.getX() + 5, mainShapeGa.getY(), mainShapeGa.getWidth() - 5, mainShapeGa.getHeight() - 5);
            Diagram diagram = Graphiti.getPeService().getDiagramForPictogramElement((PictogramElement)container);
            GraphicsAlgorithm bgShapeGa = this.createGraphics(diagram, (GraphicsAlgorithmContainer)container.getGraphicsAlgorithm(), 0, 5, mainShapeGa.getWidth(), mainShapeGa.getHeight());
            bgShapeGa.setBackground(mainShapeGa.getBackground());
            bgShapeGa.setForeground(mainShapeGa.getForeground());
            bgShapeGa.setTransparency(mainShapeGa.getTransparency());
            bgShapeGa.setStyle(mainShapeGa.getStyle());
            this.synchronizeMultiInstanceChildren(container);
            this.createBoxAnchorSet((Shape)container);
            this.synchronizeFirstLevelShape(container);
            this.relocateText(mainShapeGa);
        } else {
            GraphicsAlgorithm backgroundGa = this.getMultiInstanceChild(container, false);
            GraphicsAlgorithm foregroundGa = this.getMultiInstanceChild(container, true);
            container.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().remove((Object)backgroundGa);
            this.resize(foregroundGa, foregroundGa.getX() - 5, foregroundGa.getY(), foregroundGa.getWidth() + 5, foregroundGa.getHeight() + 5);
            this.relocateText(foregroundGa);
            this.createBoxAnchorSet((Shape)container);
            this.synchronizeFirstLevelShape(container);
        }
    }

    protected void synchronizeFirstLevelShape(ContainerShape firstLevelContainer) {
    }

    @Override
    public void synchronizeMultiInstanceChildren(ContainerShape firstLevelContainer) {
    }

    @Override
    public GraphicsAlgorithm getMultiInstanceChild(ContainerShape container, boolean main) {
        GraphicsAlgorithm invisibleGa = container.getGraphicsAlgorithm();
        if (invisibleGa.getGraphicsAlgorithmChildren().size() > 1) {
            return (GraphicsAlgorithm)invisibleGa.getGraphicsAlgorithmChildren().get(main ? 0 : 1);
        }
        return null;
    }

    @Override
    public boolean isMultipleInstances(ContainerShape container) {
        return this.getMultiInstanceChild(container, false) != null;
    }

    @Override
    public ContainerShape getContainerShape(GraphicsAlgorithm ga) {
        if (ga.getPictogramElement() != null) {
            return (ContainerShape)ga.getPictogramElement();
        }
        return this.getContainerShape(ga.getParentGraphicsAlgorithm());
    }

    @Override
    public boolean isEmpty(ContainerShape cs) {
        return this.getContainedShapes(cs).isEmpty();
    }

    @Override
    public boolean isHiding(ContainerShape cs) {
        for (Shape child : this.getContainedShapes(cs)) {
            if (!child.isVisible()) continue;
            return false;
        }
        return true;
    }

    @Override
    public EList<Shape> getContainedShapes(ContainerShape cs) {
        BasicEList results = new BasicEList();
        for (Shape shape : cs.getChildren()) {
            if (shape.getGraphicsAlgorithm() instanceof MultiText) continue;
            results.add((Object)shape);
        }
        return results;
    }

    @Override
    public void hideContainedShapes(ContainerShape cs, boolean hideChildren) {
        for (Shape child : this.getContainedShapes(cs)) {
            child.setVisible(!hideChildren);
            this.hideContainedConnections(child, hideChildren);
        }
    }

    private void hideContainedConnections(Shape s, boolean hideChildren) {
        for (Anchor anchor : s.getAnchors()) {
            ArrayList connections = new ArrayList();
            connections.addAll(anchor.getIncomingConnections());
            connections.addAll(anchor.getOutgoingConnections());
            for (Connection con : connections) {
                if (!hideChildren && (!con.getStart().getParent().isVisible() || !con.getEnd().getParent().isVisible())) continue;
                con.setVisible(!hideChildren);
                for (ConnectionDecorator conDecorator : con.getConnectionDecorators()) {
                    conDecorator.setVisible(!hideChildren);
                }
                if (!(con instanceof CompositeConnection)) continue;
                CompositeConnection cc = (CompositeConnection)con;
                con.setVisible(!hideChildren);
                for (CurvedConnection conChild : cc.getChildren()) {
                    conChild.setVisible(!hideChildren);
                    conChild.getGraphicsAlgorithm().setTransparency(Double.valueOf(hideChildren ? 1.0 : 0.0));
                    for (ConnectionDecorator conChildDecorator : conChild.getConnectionDecorators()) {
                        conChildDecorator.setVisible(!hideChildren);
                        conChildDecorator.getGraphicsAlgorithm().setTransparency(Double.valueOf(hideChildren ? 1.0 : 0.0));
                    }
                }
            }
        }
        if (s instanceof ContainerShape) {
            for (Shape childShape : ((ContainerShape)s).getChildren()) {
                if (!hideChildren && !childShape.isVisible()) continue;
                this.hideContainedConnections(childShape, hideChildren);
            }
        }
    }

    @Override
    public int getContainedWidth(ContainerShape cs) {
        int result = 0;
        for (Shape child : this.getContainedShapes(cs)) {
            if (!child.isVisible()) continue;
            result = Math.max(result, child.getGraphicsAlgorithm().getX() + child.getGraphicsAlgorithm().getWidth());
        }
        if (result == 0) {
            return this.getDefaultWidth();
        }
        return result + 5;
    }

    @Override
    public int getContainedHeight(ContainerShape cs) {
        int result = 0;
        for (Shape child : this.getContainedShapes(cs)) {
            if (!child.isVisible()) continue;
            result = Math.max(result, child.getGraphicsAlgorithm().getY() + child.getGraphicsAlgorithm().getHeight());
        }
        if (result == 0) {
            return this.getDefaultHeight();
        }
        return result + 5;
    }

    @Override
    public MultiText getText(GraphicsAlgorithm graphicsAlgorithm) {
        ContainerShape container = this.getContainerShape(graphicsAlgorithm);
        for (Shape child : container.getChildren()) {
            if (!(child.getGraphicsAlgorithm() instanceof MultiText)) continue;
            return (MultiText)child.getGraphicsAlgorithm();
        }
        return null;
    }

    @Override
    public void setTextMargin(int margin) {
        this.textMargin = margin;
    }
}

