/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features;

import org.eclipse.fmc.blockdiagram.editor.features.CompositeFeature;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class CreateShapeAndConnectionFeature
extends CompositeFeature
implements ICreateConnectionFeature {
    private final int width;
    private final int height;

    public CreateShapeAndConnectionFeature(ICreateFeature createFeature, ICreateConnectionFeature createConnectionFeature, int width, int height) {
        super(new IFeature[]{createFeature, createConnectionFeature});
        this.width = width;
        this.height = height;
    }

    private ICreateFeature getCreateFeature() {
        return (ICreateFeature)this.getFeature(0);
    }

    private ICreateConnectionFeature getCreateConnectionFeature() {
        return (ICreateConnectionFeature)this.getFeature(1);
    }

    @Override
    public boolean canExecute(IContext context) {
        return true;
    }

    @Override
    public void execute(IContext context) {
        CreateConnectionContext ctx = (CreateConnectionContext)context;
        this.getCreateFeature().execute((IContext)this.createContext((ICreateConnectionContext)ctx));
        ContainerShape container = (ContainerShape)ctx.getTargetPictogramElement();
        Shape shape = this.getShapeBehind((Shape)container.getChildren().get(container.getChildren().size() - 1));
        ctx.setTargetPictogramElement((PictogramElement)shape);
        ctx.setTargetAnchor((Anchor)shape.getAnchors().get(0));
        this.getCreateConnectionFeature().execute((IContext)ctx);
    }

    private Shape getShapeBehind(Shape shape) {
        if (shape.getGraphicsAlgorithm() instanceof AbstractText) {
            return shape.getContainer();
        }
        return shape;
    }

    private ICreateContext createContext(ICreateConnectionContext ctx) {
        CreateContext cctx = new CreateContext();
        ILocation relativePosition = FMCUtil.getRelativePosition(ctx.getTargetPictogramElement(), ctx.getTargetLocation());
        cctx.setX(relativePosition.getX());
        cctx.setY(relativePosition.getY());
        cctx.setSize(this.width, this.height);
        cctx.setTargetContainer((ContainerShape)ctx.getTargetPictogramElement());
        return cctx;
    }

    public boolean canCreate(ICreateConnectionContext context) {
        return this.getCreateConnectionFeature().canCreate(context);
    }

    public Connection create(ICreateConnectionContext context) {
        return this.getCreateConnectionFeature().create(context);
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        return this.getCreateConnectionFeature().canStartConnection(context);
    }

    public String getCreateName() {
        return this.getCreateConnectionFeature().getCreateName();
    }

    public String getCreateDescription() {
        return this.getCreateConnectionFeature().getCreateDescription();
    }

    public String getCreateImageId() {
        return this.getCreateConnectionFeature().getCreateImageId();
    }

    public String getCreateLargeImageId() {
        return this.getCreateConnectionFeature().getCreateLargeImageId();
    }

    public void startConnecting() {
        this.getCreateConnectionFeature().startConnecting();
    }

    public void endConnecting() {
        this.getCreateConnectionFeature().endConnecting();
    }

    public void attachedToSource(ICreateConnectionContext context) {
        this.getCreateConnectionFeature().attachedToSource(context);
    }

    public void canceledAttaching(ICreateConnectionContext context) {
        this.getCreateConnectionFeature().canceledAttaching(context);
    }
}

