/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.clipboard;

import java.util.HashSet;
import org.eclipse.fmc.blockdiagram.editor.clipboard.img.GraphitiImageConverter;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeChecker;
import org.eclipse.fmc.blockdiagram.editor.model.FMCTypeCheckerFactory;
import org.eclipse.fmc.blockdiagram.editor.util.FMCUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.parts.ConnectionDecoratorEditPart;
import org.eclipse.graphiti.ui.internal.parts.ShapeEditPart;

public class CopyToClipboard {
    private static FMCTypeChecker helper = FMCTypeCheckerFactory.getInstance();

    private CopyToClipboard() {
    }

    public static void copyToClipboard(DiagramEditor editor, int imageFormat) {
        PictogramElement[] els = editor.getSelectedPictogramElements();
        if (els.length > 0 && els[0] instanceof Diagram) {
            els = (PictogramElement[])((Diagram)els[0]).getChildren().toArray((Object[])new PictogramElement[0]);
        }
        int[] minMaxCoords = FMCUtil.getMinMaxCoords(els);
        GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
        HashSet<EditPart> selectedEditParts = new HashSet<EditPart>(viewer.getSelectedEditParts());
        if (selectedEditParts.isEmpty()) {
            for (Object part : viewer.getEditPartRegistry().values()) {
                if (part instanceof ShapeEditPart && helper.isFMCNode(((ShapeEditPart)part).getPictogramElement())) {
                    selectedEditParts.add((EditPart)((ShapeEditPart)part));
                    continue;
                }
                if (!(part instanceof ConnectionDecoratorEditPart)) continue;
                selectedEditParts.add((EditPart)((ShapeEditPart)part));
            }
        }
        GraphitiImageConverter.convertEditParts(minMaxCoords, selectedEditParts);
    }
}

