/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gemoc.dsl.debug.DebugTarget;
import org.eclipse.gemoc.dsl.debug.DebugTargetUtils;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.Thread;
import org.eclipse.gemoc.dsl.debug.ThreadUtils;
import org.eclipse.gemoc.dsl.debug.Variable;
import org.eclipse.gemoc.dsl.debug.ide.ModelUpdater;

public class TransactionalModelUpdater
extends ModelUpdater {
    protected final TransactionalEditingDomain domain;

    public TransactionalModelUpdater(TransactionalEditingDomain domain) {
        this.domain = domain;
    }

    protected void doExecute(Command command) {
        this.domain.getCommandStack().execute(command);
    }

    public void terminateRequest(final DebugTarget target) {
        RecordingCommand command = new RecordingCommand(this.domain, "Terminate Request"){

            protected void doExecute() {
                DebugTargetUtils.terminateRequest((DebugTarget)target);
            }
        };
        this.doExecute((Command)command);
    }

    public void disconnectRequest(final DebugTarget target) {
        RecordingCommand command = new RecordingCommand(this.domain, "Disconnect Request"){

            protected void doExecute() {
                DebugTargetUtils.disconnectRequest((DebugTarget)target);
            }
        };
        this.doExecute((Command)command);
    }

    public void spawnRunningThreadReply(final DebugTarget target, final String threadName, final EObject threadContext) {
        RecordingCommand command = new RecordingCommand(this.domain, "Spawn Running Thread Reply"){

            protected void doExecute() {
                DebugTargetUtils.spawnRunningThreadReply((DebugTarget)target, (String)threadName, (EObject)threadContext);
            }
        };
        this.doExecute((Command)command);
    }

    public void terminatedReply(final DebugTarget target) {
        RecordingCommand command = new RecordingCommand(this.domain, "Terminated Reply"){

            protected void doExecute() {
                DebugTargetUtils.terminatedReply((DebugTarget)target);
            }
        };
        this.doExecute((Command)command);
    }

    public void deleteVariableReply(final Thread thread, final String name) {
        RecordingCommand command = new RecordingCommand(this.domain, "Delete Variable Reply"){

            protected void doExecute() {
                ThreadUtils.deleteVariableReply((Thread)thread, (String)name);
            }
        };
        this.doExecute((Command)command);
    }

    public StackFrame popStackFrameReply(final Thread thread) {
        RecordingCommand command = new RecordingCommand(this.domain, "Pop Stack Frame Reply"){
            StackFrame res;

            protected void doExecute() {
                this.res = ThreadUtils.popStackFrameReply((Thread)thread);
            }

            public Collection<?> getResult() {
                ArrayList<StackFrame> list = new ArrayList<StackFrame>();
                list.add(this.res);
                return list;
            }
        };
        this.doExecute((Command)command);
        return (StackFrame)command.getResult().iterator().next();
    }

    public StackFrame pushStackFrameReply(final Thread thread, final String name, final EObject context, final EObject instruction, final boolean canStepInto) {
        RecordingCommand command = new RecordingCommand(this.domain, "Push Stack Frame Reply"){
            StackFrame res;

            protected void doExecute() {
                this.res = ThreadUtils.pushStackFrameReply((Thread)thread, (String)name, (EObject)context, (EObject)instruction, (boolean)canStepInto);
            }

            public Collection<?> getResult() {
                ArrayList<StackFrame> list = new ArrayList<StackFrame>();
                list.add(this.res);
                return list;
            }
        };
        this.doExecute((Command)command);
        return (StackFrame)command.getResult().iterator().next();
    }

    public void stepIntoReply(final Thread thread) {
        RecordingCommand command = new RecordingCommand(this.domain, "Step Into Reply"){

            protected void doExecute() {
                ThreadUtils.stepIntoReply((Thread)thread);
            }
        };
        this.doExecute((Command)command);
    }

    public void stepOverReply(final Thread thread) {
        RecordingCommand command = new RecordingCommand(this.domain, "Step Over Reply"){

            protected void doExecute() {
                ThreadUtils.stepOverReply((Thread)thread);
            }
        };
        this.doExecute((Command)command);
    }

    public void stepReturnReply(final Thread thread) {
        RecordingCommand command = new RecordingCommand(this.domain, "Step Return Reply"){

            protected void doExecute() {
                ThreadUtils.stepReturnReply((Thread)thread);
            }
        };
        this.doExecute((Command)command);
    }

    public void resumedReply(final Thread thread) {
        RecordingCommand command = new RecordingCommand(this.domain, "Resumed Reply"){

            protected void doExecute() {
                ThreadUtils.resumedReply((Thread)thread);
            }
        };
        this.doExecute((Command)command);
    }

    public void setCurrentInstructionReply(final Thread thread, final EObject instruction, final boolean canStepInto) {
        RecordingCommand command = new RecordingCommand(this.domain, "Set Current Instruction Reply"){

            protected void doExecute() {
                ThreadUtils.setCurrentInstructionReply((Thread)thread, (EObject)instruction, (boolean)canStepInto);
            }
        };
        this.doExecute((Command)command);
    }

    public void suspendedReply(final Thread thread) {
        RecordingCommand command = new RecordingCommand(this.domain, "Suspended Reply"){

            protected void doExecute() {
                ThreadUtils.suspendedReply((Thread)thread);
            }
        };
        this.doExecute((Command)command);
    }

    public void terminatedReply(final Thread thread) {
        RecordingCommand command = new RecordingCommand(this.domain, "Terminated Reply"){

            protected void doExecute() {
                ThreadUtils.terminatedReply((Thread)thread);
            }
        };
        this.doExecute((Command)command);
    }

    public void setVariableReply(final StackFrame stackFrame, final String declarationTypeName, final String name, final Object value, final boolean supportModifications) {
        RecordingCommand command = new RecordingCommand(this.domain, "Set Variable Reply"){

            protected void doExecute() {
                ThreadUtils.setVariableReply((StackFrame)stackFrame, (String)declarationTypeName, (String)name, (Object)value, (boolean)supportModifications);
            }
        };
        this.doExecute((Command)command);
    }

    public void setVariableValueReply(final Variable variable, final Object value) {
        RecordingCommand command = new RecordingCommand(this.domain, "Set Variable Reply"){

            protected void doExecute() {
                ThreadUtils.setVariableValueReply((Variable)variable, (Object)value);
            }
        };
        this.doExecute((Command)command);
    }

    public void terminateRequest(final Thread thread) {
        RecordingCommand command = new RecordingCommand(this.domain, "Terminate Request"){

            protected void doExecute() {
                ThreadUtils.terminateRequest((Thread)thread);
            }
        };
        this.doExecute((Command)command);
    }
}

